from OpenGL.GL import *
from effect import Effect
from math import cos, sin

class TestEffect(Effect):

    def __init__(self):
        Effect.__init__(self)
        pass

    def draw(self, time, delta):
        glDisable(GL_LIGHTING)
        glDisable(GL_DEPTH_TEST)
 
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(-1,1,1,-1,0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)


        glColor3f(.0,.0,.0)
        glPolygonStippleub( [[0,1,1,0]*8,[0,0,1,1]*8,[1,0,0,1]*8,[1,1,0,0]*8]*8 )
        glEnable(GL_POLYGON_STIPPLE)
        glBegin(GL_QUADS)

        glVertex2f(-1,-1)
        glVertex2f(1,-1)
        glVertex2f(1,1)
        glVertex2f(-1,1)


        glEnd()



        glColor3f(1,1,1)

        glDisable(GL_POLYGON_STIPPLE)

        glPolygonStippleub( [[1,1,0,0]*8,[0,1,1,0]*8,[0,0,1,1]*8,[1,0,0,1]*8]*8 )
        glEnable(GL_POLYGON_STIPPLE)

        pattern = [1,1,1,
                   1,1,1,
                   1,1,0]

        glBegin(GL_QUADS)
        width = .1
        height = .1
        spacingx = .22
        spacingy = .22
        centerx = 0
        centery = 0

        for x in xrange(3):
            for y in xrange(3):

                if pattern[y*3+x]:
                
                    i = (x-1) * spacingx
                    j = (y-1) * spacingy

                    i += cos(time+y)
                    j += sin(time+x)
                    
                    glColor3f(1,0,0)
                    glVertex2f( i - width, -(j - height) )
                    glVertex2f( i + width, -(j - height) )
                    glColor3f(0,0,1)
                    glVertex2f( i + width, -(j + height) )
                    glVertex2f( i - width, -(j + height) )                

        
        glEnd()

        glDisable(GL_POLYGON_STIPPLE)
