from math import *
from effect import *
import simpleloader
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import perlin

#try:
#    from cgtypes import *
#except:
#    from cgkit.cgtypes import *


class Scene(Effect):
    def __init__(self, modelname):
        Effect.__init__(self)
        (self._list, bbox) = simpleloader.simpleLoader(modelname)
        self.fov = 85
        self.xnoise = perlin.PerlinNoise((32,),perlin.ease_interpolation)
        self.ynoise = perlin.PerlinNoise((34,),perlin.ease_interpolation)
        self.test = 0
        
        
    def draw(self, time, delta, start, end):



        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(self.fov, 1.333, .1, 150)
#        P = mat4(1).perspective(self.fov, 1.3333, 0.1, 150)
#        glMultMatrixd(P.toList())


        xn = 0
        yn = 0
        ntime = time * .3
        for i in xrange(3):
            xn += self.xnoise.value_at((ntime*(i*1+1),) ) * 1.0 / (i+1) 
            yn += self.ynoise.value_at((ntime*(i*1+1),) ) * 1.0 / (i+1)

        xn *= 0.1
        yn *= 0.1

        if self.fft:
            self.test =  self.test * .95 + (self.fft.getSpectralDensity(0,10) / 10.0) * .05

        glTranslatef(xn, yn+self.test, -5)

        glLightfv(GL_LIGHT0,GL_POSITION,[0,0,1,0])
        glLightfv(GL_LIGHT0,GL_DIFFUSE,[.5,.5,.5,1])
        glLightfv(GL_LIGHT0,GL_SPECULAR,[1,1,1,1])
        glEnable(GL_LIGHT0)
        glDisable(GL_LIGHTING)


        glDisable(GL_BLEND)



        for y in [-1,0]:
            for x in [-1,0,1]:
                glMatrixMode(GL_MODELVIEW)
                glLoadIdentity()


                s = .9
                glTranslatef(x*10,0,y*10)


                rotspeed = cos(x*y)
                rotsign = rotspeed > 0
                if rotsign == 0:
                    rotsign == -1


                glRotatef(x+time*rotsign*(4+rotspeed),1,0,0)
                glRotatef(y+time*rotsign*(5.4+rotspeed),0,1,0)
                glColor3f(1,1,1)
                glScalef(s,s,s)


                glEnable(GL_DEPTH_TEST)

                glCallList(self._list)




        glDisable(GL_LIGHTING)
        glDisable(GL_LIGHT0)

        glDisable(GL_DEPTH_TEST)

    
