from effect import Effect
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

class Interlace(Effect):

    def __init__(self, intensity = .2):
        Effect.__init__(self)
        self.intensity = intensity
        

    def draw(self, time, delta, start, stop):
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)

        glPolygonStippleub( [[1,1,1,1]*8,[0,0,0,0]*8,[0,0,0,0]*8,[0,0,0,0]*8]*8 )
        glEnable(GL_POLYGON_STIPPLE)

        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,1,0,0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        glBegin(GL_QUADS)
        glColor4f(0,0,0,self.intensity)
        glVertex2f(0,0)
        glVertex2f(1,0)
        glVertex2f(1,1)
        glVertex2f(0,1)
        glEnd()

        
        glDisable(GL_BLEND)
        glDisable(GL_POLYGON_STIPPLE)
