from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

#try:
#    from cgtypes import *
#except:
#    from cgkit.cgtypes import *
    
from effect import Effect


from core.texture import Texture


class Image(Effect):

    def __init__(self, filename, xpos = .5, ypos = .5, xdir = 0, ydir = 0, fadeInStart = None, fadeInEnd = None, fadeOutStart = None, fadeOutEnd = None):
        Effect.__init__(self)
        self._texture = Texture(filename)


        if fadeInEnd != None:
            self.fadeInEnd = float(fadeInEnd)
        else:
            self.fadeInEnd = None
            

        if fadeOutEnd != None:
            self.fadeOutEnd = float(fadeOutEnd)
        else:
            self.fadeOutEnd = None


        if fadeInStart != None:
            self.fadeInStart = float(fadeInStart)
        else:
            self.fadeInStart = None            

        if fadeOutStart != None:
            self.fadeOutStart = float(fadeOutStart)
        else:
            self.fadeOutStart = None
            

        self.xpos = float(xpos)
        self.ypos = float(ypos)

        self.vwidth = 1024
        self.vheight = 1024
        self.xdir = float(xdir)
        self.ydir = float(ydir)

    def draw(self, time, delta, start, end):





        if self.fadeInStart != None and self.fadeOutEnd != None:
            if time < self.fadeInStart or time > self.fadeOutEnd:
                return

        # assume we are faded in
        intensity = 1

        if self.fadeInStart != None and self.fadeInEnd != None:
            # are we fading in?
            if self.fadeInStart <= time < self.fadeInEnd:
                fadeTime = self.fadeInEnd - self.fadeInStart
                t0 = time - self.fadeInStart
                intensity = t0 / fadeTime


        if self.fadeOutStart != None and self.fadeOutEnd != None:
            # are we fading out?
            if self.fadeOutStart <= time <= self.fadeOutEnd:
                fadeTime = self.fadeOutEnd - self.fadeOutStart
                t0 = time - self.fadeOutStart
                intensity = 1.0 - (t0 / fadeTime)
                


        if intensity > 1:
            intensity = 1

        if intensity < 0:
            intensity = 0
        

        ##
        glDisable(GL_DEPTH_TEST)
 
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,.125,1-.125,0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        dt = time - start


        glTranslatef(self.xpos + (dt * self.xdir), self.ypos + (dt * self.ydir),0)

        glEnable(GL_TEXTURE_2D)


        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)



        glEnable(GL_TEXTURE_2D)
        self._texture.bind()

        width = self._texture.size[0] / float(self.vwidth)
        height = self._texture.size[1] / float( self.vheight)

        width /= 2
        height /= 2

        

        glBegin(GL_QUADS)

        glColor4f(1,1,1, intensity)
        glTexCoord2d(0,0)
        glVertex2f(-width,-height)

        glTexCoord2d(1,0)
        glVertex2f(width,-height)

        glTexCoord2d(1,1)
        glVertex2f(width,height)

        glTexCoord2d(0,1)
        glVertex2f(-width,height)
        
        glEnd()

        
        glDisable(GL_TEXTURE_2D)
        glDisable(GL_BLEND)

