from effect import Effect
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import random
class Gradient(Effect):
    
    def __init__(self, topColor = [1,0,0], bottomColor = [0,0,1]):
        Effect.__init__(self)

        # parameters
        self.topColor = topColor
        self.bottomColor = bottomColor




    def draw(self, time, delta, start, stop):
        self.drawGradient(self.bottomColor, self.topColor)


    def drawGradient(self, bottomColor, topColor):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,1,0,0.1,1000)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)
        
        glBegin(GL_QUADS)
        glColor3f(*topColor)
        glVertex2f(0,0)
        glVertex2f(1,0)
        
        glColor3f(*bottomColor)
        glVertex2f(1,1)
        glVertex2f(0,1)
        glEnd()
    

class FFTGradient(Gradient):
    
    def __init__(self, topColor = [1,0,0], bottomColor = [0,0,1]):
        Gradient.__init__(self, topColor, bottomColor)
       

    def draw(self, time, delta, start, stop):
        bottomColor = self.bottomColor[:]
        topColor =self.topColor[:]
        v = self.fft.getSmoothSpectralDensity(0,20) * .5
        bottomColor[0] *= v
        bottomColor[1] *= v
        bottomColor[2] *= v
        
        self.drawGradient(bottomColor, topColor)
        
    
    
