from effect import Effect
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from math import cos

class Distort(Effect):

    def __init__(self, screenres):
        Effect.__init__(self)

        format = GL_RGBA
        self.width = 1024
        self.height = 512
        
        self._buffer = glGenTextures(1)
        glBindTexture(GL_TEXTURE_2D, self._buffer)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        glTexImage2D(GL_TEXTURE_2D, 0, format, self.width, self.height, 0, format, GL_UNSIGNED_BYTE, 0)
        self._screenres = screenres
        print self._screenres
        print "it did not crash"
        
    def draw(self, time, delta):

        glDisable(GL_DEPTH_TEST)
 
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,480,0,0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        glEnable(GL_TEXTURE_2D)

        glBindTexture(GL_TEXTURE_2D, self._buffer)
        glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenres[0], self._screenres[1])

        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)

        glBegin(GL_QUADS)

        for y in xrange(480):


            v0 = 1.0 - (y * self._screenres[1]/float(self.height))
            v1 = 1.0 - ((y+1) * self._screenres[1]/float(self.height))
            u0 = 0
            u1 = self._screenres[0]/float(self.width)



            glTexCoord2d(u0,v0)
            glVertex2f(0,y)

            glTexCoord2d(u1,v0)
            glVertex2f(1,y)

            glTexCoord2d(u1,v1)
            glVertex2f(1,y+1)

            glTexCoord2d(u0,v1)
            glVertex2f(0,y+1)
            
            

        glEnd()



        glDisable(GL_BLEND)
       
        glDisable(GL_TEXTURE_2D)
