from effect import Effect
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from math import cos
import random

class Distort(Effect):

    """
    A simple distortion effect

    parameters: intensity - determines the transparency 0 = fully transparent, 1 = fully opaque
              : amplitude - determines the amount of distortion (in pixels)

    """

    def __init__(self, screenres, intensity = .2, amplitude = 50):
        Effect.__init__(self)

        format = GL_RGBA
        self.width = 1024
        if (screenres[1] > 512):
            self.height = 1024
        else:
            self.height = 512
        
        
        self._buffer = glGenTextures(1)
        glBindTexture(GL_TEXTURE_2D, self._buffer)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)

        texTemp = "aaaa" * self.width * self.height
        
        glTexImage2D(GL_TEXTURE_2D, 0, format, self.width, self.height, 0, format, GL_UNSIGNED_BYTE, texTemp)
        self._screenres = screenres

        # parameters
        self.intensity = intensity
        self.amplitude = amplitude

        
    def draw(self, time, delta, start, stop):

        glDisable(GL_DEPTH_TEST)
 
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,0,self._screenres[1],0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        glEnable(GL_TEXTURE_2D)

        glBindTexture(GL_TEXTURE_2D, self._buffer)
        glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenres[0], self._screenres[1])

        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)

        glBegin(GL_QUADS)

        glColor4f(1,1,1, self.intensity)

        

        for y in xrange(self._screenres[1]):

            test = random.random() * self.amplitude

            yn0 = (y+test) / float(self._screenres[1])
            yn1 = (y+1+test) / float(self._screenres[1])

            v0 =  (yn0 * (self._screenres[1]/float(self.height)))
            v1 = (yn1 * (self._screenres[1]/float(self.height)))


            #offset = random.random() * (cos(time) * .5 + .5) * .1
            offset = 0
            
            u0 = offset
            u1 = (self._screenres[0]/float (self.width))  - offset


            """ for extra distortion """
            #freq = 240
            #a = cos(yn0*freq+time)*.1+.9
            #u0 *= a
            #u1 *= a


            glTexCoord2d(u0,v0)
            glVertex2f(0,y)

            glTexCoord2d(u1,v0)
            glVertex2f(1,y)

            glTexCoord2d(u1,v1)
            glVertex2f(1,y+1)

            glTexCoord2d(u0,v1)
            glVertex2f(0,y+1)
            
        

        glEnd()

        glDisable(GL_BLEND)
        glDisable(GL_TEXTURE_2D)
