from PIL import Image
from PIL import TgaImagePlugin

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *


class Texture:

    def __init__(self, filename):
        self.size = None

        image = Image.open(filename)
        self._texture = glGenTextures(1)
        self._texture_image_2d(image, True)
        self.bind()
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)


    def _texture_image_2d(self, image, mipmap):

        self.bind()

	if image.mode == 'RGB':
		data = image.tostring("raw","RGBX",0,-1)
	elif image.mode == 'RGBA':
# 		image2 = image.convert('RGBa')
# 		image2.mode = 'RGBA'
		data = image.tostring("raw","RGBA",0,-1)
	else:
		assert False, image.mode
	width, height = image.size
#	data =list(data)

#        for p in range(width*height):
#		alpha = (ord(data[p*4+3])/255.0)
#		if (alpha>0):
#			for ofs in range(3):
#				i=int( ord(data[p*4+ofs])/(alpha))
#				data[p*4+ofs] = chr(min(i,255))
#                else:
#                    for ofs in range(3):
#                        data[p*4+ofs] = chr(0)
                        
		# data[p*4+3] = chr(255)
#	data = "".join(data)
	if mipmap:
		gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, width, height,
				  GL_RGBA, GL_UNSIGNED_BYTE, data)
	else:
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height,
			     0, GL_RGBA, GL_UNSIGNED_BYTE, data)


        self.size = image.size[:]

    def bind(self):
        glBindTexture(GL_TEXTURE_2D, self._texture)

