#include <GL/gl.h>
#include <math.h>

#include "water.hpp"

#define N_WIDTH 100
#define N_HEIGHT 100

#define X_OFFSET -3.0
#define Y_OFFSET -4.0
#define Z_OFFSET 0.0
#define WIDTH 8.0
#define HEIGHT 8.0

#define FREQ 25

#define SKIP 1

Water::Water() {
  _n_width = N_WIDTH;
  _n_height = N_HEIGHT;
  _map0 = new double[_n_width * _n_height];
  _map1 = new double[_n_width * _n_height];
  init_buffers();
}

double last_time = 0.0;
int count = 0;

void Water::effect(double t) {
  if (t > last_time + (1.0 / FREQ)) {
    update_buffers();
    last_time = t;
  }

  count++;
  if (count > 50) {
    count = 0;
    double x = sin(t * 10.0) / 3.0 + 0.5;
    double y = cos(t * 2.0) / 3.0 + 0.5;
    double height = 1.0; // cos(t / 2.0) / 2.0;

    int row = (int) (y * N_HEIGHT);
    int col = (int) (x * N_WIDTH);
    if ((row >= 0) && (row < N_HEIGHT) && (col >= 0) && (col < N_WIDTH)) {
      _map0[row * N_WIDTH + col] = height;
    }
  }

  draw();
}

void Water::init_buffers() {
  for (int i = 0; i < _n_height; i++) {
    for (int j = 0; j < _n_width; j++) {
      int ofs = i * _n_width + j;
      _map0[ofs] = 0.0;
      _map1[ofs] = 0.0;
    }
  }
}

void Water::update_buffers() {
  double* page0 = _map0;
  double* page1 = _map1;

  // we do this with doubles arghl
  for (int i = 1; i < _n_height - 1; i++) {
    for (int j = 1; j < _n_width - 1; j++) {
      int ofs = i * _n_width + j;
//       double value = 0.5 * (page1[ofs - _n_width] + page1[ofs + _n_width] + page1[ofs - 1] + page1[ofs + 1]) - page0[ofs];
      double value = 0.5 * (page1[ofs - _n_width] + page1[ofs + _n_width] + page1[ofs - 1] + page1[ofs + 1]) - page0[ofs];
      page0[ofs] = 0.8 * value;
    }
  }

  _map1 = page0;
  _map0 = page1;
}

void Water::draw() {
  glPushMatrix();
  glTranslatef(-0.0f, -0.0f, -0.1f);
  glRotatef(-60.0, 1.0, 0.0, 0.0);

  double z = Z_OFFSET;
  //  double cell_width = WIDTH / _n_width;
  //double cell_height = HEIGHT / _n_height;

      glDisable(GL_LIGHTING);
  for (int i = 0; i < _n_height; i++) {
    for (int j = 0; j < _n_width; j++) {
      double x0 = WIDTH / _n_width * j + X_OFFSET;
      double y0 = HEIGHT / _n_height * i + Y_OFFSET;
      double x1 = WIDTH / _n_width * (j + 1) + X_OFFSET;
      double y1 = HEIGHT / _n_height * (i + 1) + Y_OFFSET;


      glBegin(GL_QUADS);

      {
      double value0 = get_height(i, j) * 8.0;
      glColor3f(value0, value0, value0);
      glVertex3f(x0, y0, z + get_height(i, j));
      }

      {
      double value0 = get_height(i, j + SKIP) * 8.0;
      glColor3f(value0, value0, value0);
      glVertex3f(x1, y0, z + get_height(i, j + SKIP));
      }

      {
      double value0 = get_height(i + SKIP, j + SKIP) * 8.0;
      glColor3f(value0, value0, value0);
      glVertex3f(x1, y1, z + get_height(i + SKIP, j + SKIP));
      }

      {
      double value0 = get_height(i + SKIP, j) * 8.0;
      glColor3f(value0, value0, value0);
      glVertex3f(x0, y1, z + get_height(i + SKIP, j));
      }

      glEnd();
    }
  }

  glPopMatrix();
}

double Water::get_height(int i, int j) {
  int map_offset = i * _n_width + j;
  double value = _map1[map_offset];
  if (value > 0.5 / 64.0) {
    value = 0.0;
  }
  return value * 64.0;
}
