#include "graphics.hpp"
#include "hermite.hpp"

Hermite::Hermite(Vector3 p0, Vector3 p1, Vector3 p2, Vector3 p3) {
  _p0 = p0;
  _p1 = p1;
  _p2 = p2;
  _p3 = p3;
}

void Hermite::setCoords(Vector3 p0, Vector3 p1, Vector3 p2, Vector3 p3) {
  _p0 = p0;
  _p1 = p1;
  _p2 = p2;
  _p3 = p3;
}

Vector3 Hermite::interpolate(float t) {
  Vector3 value;
  value.x = interpolate(t, _p0.x, _p1.x, _p2.x, _p3.x);
  value.y = interpolate(t, _p0.y, _p1.y, _p2.y, _p3.y);
  value.z = interpolate(t, _p0.z, _p1.z, _p2.z, _p3.z);
  return value;
}

float Hermite::interpolate(float t, float p0, float p1, float p2, float p3) {
  float tSquared = t * t;
  float tCubed = t * t * t;
  return (2.0 * tCubed - 3.0 * tSquared + 1.0) * p1
    + (-2.0 * tCubed + 3.0 * tSquared) * p2
    + (tCubed - 2.0 * tSquared + t) * p0
    + (tCubed - tSquared) * p3;
}
