#ifndef FONT_HPP
#define FONT_HPP

#include "vector.hpp"

class Font {
public:
  Font(char* filename, int nChars, int charMap[], int width, int height);
  void paint(Vector3 pos, char c);
  void paint(int x0, int y0, int x1, int y1, char c);
private:
  void buildCoords(int nChars, int charMap[], int width, int height);

  Vector2* getCharOffset0(char c);
  Vector2* getCharOffset1(char c);

  int _textureId;

  /* Coordinate of each font */
  Vector2 _ofs0[256];
  Vector2 _ofs1[256];
};

Font* getDefaultFont();
Font* getFont12x12();
Font* getFont14x16();
Font* getFontDance();

#endif
