#ifndef __CUBES_HPP
#define __CUBES_HPP

#include "effect.hpp"
#include "cube.hpp"

/**
 * A 3d set of cubes.
 */
class Cubes : Effect {
public:
  Cubes(int nWidth, int nHeight, int nDepth);
  void effect(double t, int stage, int noot);
private:
  void draw();
  void draw_antialiased();
  void setCoords(double dist[], double y_offsets[], double all_size, double cube_size);
  void setCoords9(double dist0, double dist1, double all_size, double cube_size);
  Cube* _cubes;
  double* _shades;
  int _n_width;
  int _n_height;
  int _n_depth;
  int _prev_stage;
  double _t0;
  double _peel_time;
  double _time;
};

#endif // __CUBES_HPP

