#ifndef CUBE_HPP
#define CUBE_HPP

#include "vector.hpp"

/**
 * A single 3d cube
 */
class Cube {
public:
  void set(double x0, double y0, double z0, double x1, double y1, double z1);
  void set_color(double r, double g, double b);
  void draw();

  /**
   * Adds the faces that make up this cube to an array of faces.
   */
  int add_faces(Face4* faces);
private:
  double _x0, _y0, _z0;
  double _x1, _y1, _z1;
  double _r, _g, _b;
};

#endif
