#include <GL/gl.h>

#include "cube.hpp"

void Cube::set(double x0, double y0, double z0, double x1, double y1, double z1) {
  _x0 = x0;
  _y0 = y0;
  _z0 = z0;
  _x1 = x1;
  _y1 = y1;
  _z1 = z1;
}

void Cube::draw() {
  // Front
  glBegin(GL_QUADS);
  glNormal3f( 0.0,  0.0, +1.0);
  glVertex3f(_x0, _y0, _z1);
  glVertex3f(_x1, _y0, _z1);
  glVertex3f(_x1, _y1, _z1);
  glVertex3f(_x0, _y1, _z1);
  // Back
  glNormal3f( 0.0,  0.0, -1.0);
  glVertex3f(_x0, _y0, _z0);
  glVertex3f(_x0, _y1, _z0);
  glVertex3f(_x1, _y1, _z0);
  glVertex3f(_x1, _y0, _z0);
  // Left
  glNormal3f(-1.0,  0.0,  0.0);
  glVertex3f(_x0, _y0, _z0);
  glVertex3f(_x0, _y0, _z1);
  glVertex3f(_x0, _y1, _z1);
  glVertex3f(_x0, _y1, _z0);
  // Right
  glNormal3f(+1.0,  0.0,  0.0);
  glVertex3f(_x1, _y0, _z0);
  glVertex3f(_x1, _y1, _z0);
  glVertex3f(_x1, _y1, _z1);
  glVertex3f(_x1, _y0, _z1);
  // Top
  glNormal3f( 0.0, +1.0,  0.0);
  glVertex3f(_x0, _y1, _z0);
  glVertex3f(_x0, _y1, _z1);
  glVertex3f(_x1, _y1, _z1);
  glVertex3f(_x1, _y1, _z0);
  // Bottom
  glNormal3f( 0.0, -1.0,  0.0);
  glVertex3f(_x0, _y0, _z0);
  glVertex3f(_x1, _y0, _z0);
  glVertex3f(_x1, _y0, _z1);
  glVertex3f(_x0, _y0, _z1);
  glEnd();
}

int Cube::add_faces(Face4* face) {
  // Front
  face[0].normal.set( 0.0,  0.0, +1.0);
  face[0].p0.set(_x0, _y0, _z1);
  face[0].p1.set(_x1, _y0, _z1);
  face[0].p2.set(_x1, _y1, _z1);
  face[0].p3.set(_x0, _y1, _z1);
  // Back
  face[1].normal.set( 0.0,  0.0, -1.0);
  face[1].p0.set(_x0, _y0, _z0);
  face[1].p1.set(_x0, _y1, _z0);
  face[1].p2.set(_x1, _y1, _z0);
  face[1].p3.set(_x1, _y0, _z0);
  // Left
  face[2].normal.set(-1.0,  0.0,  0.0);
  face[2].p0.set(_x0, _y0, _z0);
  face[2].p1.set(_x0, _y0, _z1);
  face[2].p2.set(_x0, _y1, _z1);
  face[2].p3.set(_x0, _y1, _z0);
  // Right
  face[3].normal.set(+1.0,  0.0,  0.0);
  face[3].p0.set(_x1, _y0, _z0);
  face[3].p1.set(_x1, _y1, _z0);
  face[3].p2.set(_x1, _y1, _z1);
  face[3].p3.set(_x1, _y0, _z1);
  // Top
  face[4].normal.set( 0.0, +1.0,  0.0);
  face[4].p0.set(_x0, _y1, _z0);
  face[4].p1.set(_x0, _y1, _z1);
  face[4].p2.set(_x1, _y1, _z1);
  face[4].p3.set(_x1, _y1, _z0);
  // Bottom
  face[5].normal.set( 0.0, -1.0,  0.0);
  face[5].p0.set(_x0, _y0, _z0);
  face[5].p1.set(_x1, _y0, _z0);
  face[5].p2.set(_x1, _y0, _z1);
  face[5].p3.set(_x0, _y0, _z1);

  // set colors (XXX)
  for (int i = 0; i < 6; i++) {
    face[i].r = _r;
    face[i].g = _g;
    face[i].b = _b;
  }

  // Added 6 faces
  return 6;
}

void Cube::set_color(double r, double g, double b) {
  _r = r;
  _g = g;
  _b = b;
}
