;******************************************************************************
; neo.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
neoSphereScale: dd 10.0,10.0,10.0
neoCamDist: dd -31.0
neobias: dd 0.05
neoDispScale: dd 10.0
neoBeatDamp: dd 0.4

neoColor: dd 1.9,1.7,1.5
neoRotDur: dd 2.0
neoRotSpeed: dd 3.0
;==============================================================================
section .bss
;==============================================================================
neoLight: resb light_size
neoLight2: resb light_size
gtexNoise: resb tex_size
neoSeedID: resd 1
neoSeed: resd 1
;==============================================================================
section .text
;==============================================================================
SDECL _initNeo, 0
;==============================================================================
    TexCreate   gtexNoise, 256, 1
    mov     dword[neoSeedID],-1
    mov     dword[neoSeed],0xaf73276
DECLEND
;==============================================================================
SDECL _updateNeoRot, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LVAR    4, sID, seed, angle
    LVAR    vec4_size, qr
    LENTER
    
    fld     dword[RTM_time]
    fdiv    dword[neoRotDur]
    fistp   dword[%$sID]
    mov     eax,dword[%$sID]
    cmp     eax,dword[neoSeedID]
    je      .endSeed
    mov     dword[neoSeedID],eax
    RandI   neoSeed
.endSeed:

    mov     eax,dword[neoSeed]
    mov     dword[%$seed],eax
    lea     eax,[%$seed]
    CCALL   _getRandMat, eax
    fld     dword[RTM_time]
    fmul    dword[neoRotSpeed]
    fstp    dword[%$angle]
    lea     eax,[%$qr]
    QuatFromAA eax,RTmatrix +matrix.n, [%$angle]
    lea     eax,[%$qr]
    Quat2m33 OBJ_tform +objtform.rm, eax
    
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _updateNeo, 0
;==============================================================================
    LCTX    esp
    LARG    4, _type

;set lights
    SetLightDir neoLight, AxisZ
    mov     dword[neoLight +light.on], PACKB2DW(0,LIGHTF_REV,LIGHT_DIR,1)
    mov     dword[neoLight2 +light.on], PACKB2DW(0,0,LIGHT_AMBIENT,1)
    mov     eax,REAL_1D10
    V4setImm neoLight2 +light.c, eax,eax,eax,eax
    mov     eax,dword[neoColor]
    V4setImm neoLight +light.c, eax,eax,eax,eax
;set obj tex
    RasSetTex  0, gtexFont
;set background
    TexClear myscene +scene.zb
;    CpalSetImm  cparam, 0, 256, 0x40000000, 0x00ffffff, 100, 100, 500, 0x41e28d44
;    CpalSetImm  cparam, 0, 256, 0x40000000, 0x00ffffff, 369, 239, 300, 0x41CC1E1F
    CpalSetImm  cparam, 0, 256, 0x00000000, 0x00ffffff, 369, 239, 300, 0x41C8BD6B
    cmp     byte[%$_type],0
    je      .endPal
    mov     byte[cparam +cpal.min +3],0x40
    RasSetTex  0, gtexWavy2
    mov     eax,dword[neoColor +4]
    mov     dword[neoLight +light.c +4],eax
    mov     eax,dword[neoColor +8]
    mov     dword[neoLight +light.c +8],eax
.endPal:
    Tex32MakePal gtexNoise, cparam, TEX32_CPAL
    CCALL   _updateNoise, hdrscene +scene.fb, 128,512, 256*1,2,0x01020100,256,0
    TexShadePal hdrscene +scene.fb, gtexNoise

    TexClear myscene +scene.fb
    CCALL   _TEX32_upsample, myscene +scene.fb, hdrscene +scene.fb

;set vertex disp
    mov     eax,dword[Real1d2]
    mov     dword[RND_nparam +noise.gain],eax
    fld1
    fadd    st0
    fstp    dword[RND_nparam +noise.pers]
    mov     dword[RND_nparam +noise.iter], 2
    fld     dword[RTM_time]
;    fmul    dword[Real1d2]
    fstp    dword[RND_nparam +noise.ampl]
    cmp     byte[%$_type],0
    je      .endSetAmpl
    fld     dword[beatTimer +timer.sec]
    fmul    dword[neoBeatDamp]
    fstp    dword[RND_nparam +noise.ampl]
.endSetAmpl:
;set cam
    CCALL   _setCamFOV, RAS_main +raster.cam, REAL_PID3
    M33id RTmatrix
    CCALL   _setMovingCam, [neoCamDist]
.exit:
DECLEND
;==============================================================================
SDECL _updateNoise, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _ptex, _gain, _freq, _scale, _iter, _flags, _ampl, _bias
    LVAR    4, den
    LENTER
    mov     dword[%$den],REAL_1DFIX8
    xor     eax,eax
    mov     dword[RND_nparam +noise.x],eax
    mov     dword[RND_nparam +noise.y],eax
    fild    dword[%$_bias]
    fstp    dword[RND_nparam +noise.bias]
    fld     dword[RTM_time]
    fmul    dword[Real1d2]
    fstp    dword[RND_nparam +noise.z]
    fild    dword[%$_scale]
    fmul    dword[%$den]
    fst     dword[RND_nparam +noise.scaleX]
    fstp    dword[RND_nparam +noise.scaleY]
    fild    dword[%$_gain]
    fmul    dword[%$den]
    fstp    dword[RND_nparam +noise.gain]
    fild    dword[%$_freq]
    fmul    dword[%$den]
    fstp    dword[RND_nparam +noise.pers]
    mov     eax,dword[%$_iter]
    mov     dword[RND_nparam +noise.iter],eax
    fild     dword[%$_ampl]
    fstp    dword[RND_nparam +noise.ampl]
    CCALL   _TEX8_perlin3DFast, [%$_ptex], [%$_flags]
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _VPGM_neo
;==============================================================================
    MPUSH   edi,ebp
    LCTX    ebp
    LARG    4, _pvert
    LVAR    vec3_size, rnormals
    LVAR    4, ratio
    LENTER
    
    mov     edi, dword[%$_pvert]
;transform normal
    lea     eax,[edi +vertex.nx]
    lea     edx,[%$rnormals]
    M33mulV3 edx, OBJ_tform +objtform.rm, eax

    fld1
    fadd    dword[edi +vertex.nx]
    fld1
    fadd    dword[edi +vertex.ny]
    fld1
    fadd    dword[edi +vertex.nz]
    fadd    dword[RND_nparam +noise.ampl]
    fxch    st2
    fstp    dword[RND_nparam +noise.x]
    fstp    dword[RND_nparam +noise.y]
    fstp    dword[RND_nparam +noise.z]
    CCALL   _RND_perlin3D
    fabs
    fmul    dword[neoDispScale]
;move vertices
    fld     dword[%$rnormals +vec3.z]
    fmul    st1
    fld     dword[%$rnormals +vec3.y]
    fmul    st2
    fxch    st2
    fmul    dword[%$rnormals +vec3.x]   ;x z y
    fxch    st2
    fxch    st1
    fadd    dword[edi +vertex.z]
    fld     dword[edi +vertex.y]
    faddp   st2
    fld     dword[edi +vertex.x]
    faddp   st3
    fstp    dword[edi +vertex.z]
    fstp    dword[edi +vertex.y]
    fstp    dword[edi +vertex.x]

;    fld     dword[%$rnormals +vec3.y]
;    fld     dword[%$rnormals +vec3.x]
;    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
;    fmul to st1
;    fmul to st2
;    fadd to st1
;    faddp   st2
;    fstp    dword[edi +vertex.u0]
;    fstp    dword[edi +vertex.v0]
    
;    mov     eax,REAL_FIX8
;    V4setImm edi +vertex.c, eax,eax,eax,eax
;    lea     eax,[edi +vertex.nx]
;    lea     edx,[edi +vertex.c]
;    CCALL   _LIGHT_apply, edx, edi, eax, neoLight, 2
.exit:
    LEXIT
    MPOP    edi,ebp
DECLEND
;==============================================================================
SDECL _VPGM_neo2
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _dst, _v1, _v2, _v3, _dummy
    LVAR    vec3_size, p3,p2,p1,norm, rnorm
    LVAR    vec4_size, color
    LENTER
    
    mov     eax,dword[%$_v2]
    mov     edx,dword[%$_v1]
    V3sub   %$p2,eax,edx
    mov     eax,dword[%$_v3]
    fld     dword[eax +vec3.x]
    fsub    dword[edx +vec3.x]
    fld     dword[eax +vec3.y]
    fsub    dword[edx +vec3.y]
    fld     dword[eax +vec3.z]
    fsub    dword[edx +vec3.z]
    fxch    st2
    fst     dword[%$p3 +vec3.x]
    fstp    dword[%$p1 +vec3.x]
    fst     dword[%$p3 +vec3.y]
    fstp    dword[%$p1 +vec3.y]
    fst     dword[%$p3 +vec3.z]
    fstp    dword[%$p1 +vec3.z]
    lea     edi,[%$norm]
    lea     eax,[%$p2]
    lea     edx,[%$p3]
    V3cross edi,edx,eax
    V3norm  edi
    lea     ebx,[%$p1]
    V3norm  ebx
    lea     eax,[%$p2]
    V3norm  eax
    lea     eax,[%$p3]
    V3norm  eax
;set color
    mov     eax,REAL_FIX8
    V4setImm %$color, eax,eax,eax,eax
    lea     edx,[%$color]
    CCALL   _LIGHT_apply, edx, [%$_v1], edi, neoLight, 2


    SETVDECL VDECL_RGBT0
    mov     edi,dword[%$_dst]
    mov     ecx,-3
.iter3x:
    mov     esi,dword[%$_dummy +ecx*4]
    mov     eax,dword[esi +vertex.x]
    mov     dword[edi +vertexUP.x],eax
    mov     eax,dword[esi +vertex.y]
    mov     dword[edi +vertexUP.y],eax
    mov     eax,dword[esi +vertex.z]
    mov     dword[edi +vertexUP.z],eax
;clear unused
;    xor     eax,eax
;    mov     dword[edi +vertexUP.dum1],eax
;    mov     dword[edi +vertexUP.dum2],eax
;    mov     dword[edi +vertexUP.dum3],eax

;    mov     eax,dword[esi +vertex.c +rgbaUP.r]
;    mov     dword[edi +vertexUP.cr],eax
;    mov     eax,dword[esi +vertex.c +rgbaUP.g]
;    mov     dword[edi +vertexUP.cg],eax
;    mov     eax,dword[esi +vertex.c +rgbaUP.b]
;    mov     dword[edi +vertexUP.cb],eax
 
    mov     eax,dword[%$color +rgbaUP.b]
    mov     dword[edi +vertexUP.cb],eax
    mov     eax,dword[%$color +rgbaUP.g]
    mov     dword[edi +vertexUP.cg],eax
    mov     eax,dword[%$color +rgbaUP.r]
    mov     dword[edi +vertexUP.cr],eax

%ifndef _USE_THIS_
    lea     edx,[%$rnorm]
    lea     eax,[%$norm]
    V3interpolate edx,eax,ebx,[neobias]
;    lea     eax,[%$rnorm]
;    V3norm  eax
    fld     dword[%$rnorm +vec3.y]
    fld     dword[%$rnorm +vec3.x]
    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fmul to st1
    fmul to st2
    fadd to st1
    faddp   st2
    fstp    dword[edi +vertexUP.u0]
    fstp    dword[edi +vertexUP.v0]
    add     ebx,vec3_size
%else
    mov     eax,dword[esi +vertex.u0]
    mov     dword[edi +vertexUP.u0],eax
    mov     eax,dword[esi +vertex.v0]
    mov     dword[edi +vertexUP.v0],eax
%endif
    
    add     edi,vertexUP_size
    inc     ecx
    jnz     .iter3x
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _renderNeoSphere, 0
;==============================================================================
    RasSetCulling CULLING_BACK
    RasSetFpgm _FPGM_RGBxT0bi_Z
    RasSetVpgm _VPGM_neo2
    
    V3setNull OBJ_tform +objtform.rm +matrix.t

    ObjSetScale neoSphereScale
    ObjSetVpgm _VPGM_neo
    ObjSetFlags OBJ_ICOSA, 3, OBJF_NORM
    CCALL   _OBJ_render3D
.exit:
DECLEND
;==============================================================================
SDECL _renderNeo, 0
;==============================================================================
    LCTX    esp
    LVAR    4, val
    
    CCALL   _updateNeo, 0
    CCALL   _updateNeoRot
    CCALL   _renderNeoSphere

    fld     dword[RTM_time]
    fmul    dword[greal2000pi]
    mov     dword[%$val],5000
    fidiv   dword[%$val]
    fsin
    mov     dword[%$val],32
    fimul   dword[%$val]
    mov     dword[%$val],128
    fiadd   dword[%$val]
    fistp   dword[RTmatrix]

    fld     dword[RTM_time]
    fmul    dword[greal2000pi]
    mov     dword[%$val],7249
    fidiv   dword[%$val]
    fsin
    mov     dword[%$val],24
    fimul   dword[%$val]
    mov     dword[%$val],96
    fiadd   dword[%$val]
    fistp   dword[RTmatrix +4]
    CCALL   _TEX32_downsample, glrscene +scene.fb, myscene +scene.fb
    CCALL   _TEX32_glare, glrscene +scene.fb, [RTmatrix],[RTmatrix +4], 242, 12, 30, 255
    CCALL   _TEX32_upsample, myscene +scene.fb, glrscene +scene.fb

;    TexBlit myscene +scene.fb, glrscene +scene.fb
.exit:
DECLEND
;==============================================================================
SDECL _renderNeo2, 0
;==============================================================================
    LCTX    esp
    LVAR    4, val
    
    CCALL   _updateNeo, 1
    M33id OBJ_tform +objtform.rm
    CCALL   _renderNeoSphere

    CCALL   _TEX32_downsample, hdrscene +scene.fb, myscene +scene.fb
    CCALL   _TEX_blur, hdrscene +scene.fb, hdrscene +scene.bb, 2, 50, 2
    CCALL   _TEX32_upsample, myscene +scene.fb, hdrscene +scene.fb
;    TexBlit myscene +scene.fb, hdrscene +scene.fb
.exit:
DECLEND
;==============================================================================
