;******************************************************************************
; main.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
%assign _LINKING_ 1
%include "lib.inc"
%assign _LINKING_ 0
global _mymain
;==============================================================================
; DEFINITIONS
;==============================================================================
%assign CLEAR_COLOR PACKB2DW(0, 255, 255, 255)

TCTX    timeevent
TVAR    timeevent.mark  ,4
TVAR    timeevent.total ,4
TVAR    timeevent.fadetime ,4
TVAR    timeevent.fn    ,4
TVAR    timeevent.data  ,4
TVAR    timeevent.flags ,4
ENDT    timeevent

TCTX    beatinfo
TVAR    beatinfo.bps    ,4
TVAR    beatinfo.spdMin ,4
TVAR    beatinfo.spdMax ,4
TVAR    beatinfo.count  ,4
ENDT    beatinfo

%assign EVENTF_REV 0x01
%assign EVENTF_FADEIN 0x02
%assign EVENTF_FADEOUT 0x04
%assign EVENTF_FADEIO (EVENTF_FADEIN | EVENTF_FADEOUT)

TCTX    billboard
TVAR    billboard.data  ,4
TVAR    billboard.count ,4
ENDT    billboard

;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
DATA_SEG_INIT
;==============================================================================
DEFSTR mytitle,'dmo'
DEFSTR demoMusik,'data/solaris.mp3'
defaultBeat: dd 2.33333333, 0.5,10.0,0
greal2000pi: dd 6283.185307
greal256: dd 256.0
greal1dpi: dd REAL_1DPI

Speclights:
dd 0,0,1.0,0, 0.2,0.1,1.0,0, 1.5,0.8,0.8,0.1
dd 128.0,0.10,PACKB2DW(0,0,LIGHT_SPEC2D,1)
dd 0,0,1.0,0, 0.15,0.2,1.0,0, 0.2,0.9,1.0,0.1
dd 128.0,0.10,PACKB2DW(0,0,LIGHT_SPEC2D,1)
dd 0,0,1.0,0, 0.1,0.1,1.0,0, 1.0,0.5,0.8,0.1
dd 128.0,0.25,PACKB2DW(0,0,LIGHT_SPEC2D,1)
Metal2lights:
dd 0,0,0,0, 0.19,0.2,1.0,0, 0.7,0.6,0.6,0.1
dd 64.0,0.10,PACKB2DW(0,0,LIGHT_SPEC2D,1)
dd 0,0,0,0, -0.2,-0.18,1.0,0, 0.4,0.6,0.7,0.1
dd 64.0,0.10,PACKB2DW(0,0,LIGHT_SPEC2D,1)
dd 0,0,0,0, 1.0,1.0,1.0,0, 0.05,0.05,0.06,0.1
dd 0,0,PACKB2DW(0,0,LIGHT_AMBIENT,1)
Wavy2lights:
dd 0,0,1.0,0, 0.0,0.2,1.0,0, 1.5,0.8,0.8,1.0
dd 64.0,0.10,PACKB2DW(0,0,LIGHT_SPEC2D,1)
dd 0,0,1.0,0, 0.1,0.2,1.0,0, 0.2,0.9,1.0,1.0
dd 64.0,0.10,PACKB2DW(0,0,LIGHT_SPEC2D,1)

;%define _LORENZ_TEST_

FXseq1: dd 15.0,0.08
FXseq2: dd 1.0,0.2
%ifndef _LORENZ_TEST_
FXtotal: dd 11
FXlut: dd _renderLorenz2, _renderElectric, _renderNeo, _renderWavy, _renderTunnel
dd _renderLorenz, _renderBeams, _renderMcube, _renderRod, _renderDisco, _renderNeo2
%else
FXtotal: dd 1
FXlut: dd _renderRod
geventTotal: dd 1
geventLUT:
dd 0.0, 300.0, 0, _renderAltSeq, FXseq1,0
dd 0.0, 60.0, 0.2, _renderBboard, 11,EVENTF_FADEIO
beatInterval1: dd 0,300.0
%endif


%ifndef _LORENZ_TEST_
geventTotal: dd 21
geventLUT:
dd 0.0, 30.0, 0, _renderCredits, 0,0
dd 30.0, 165.0, 0, _renderAltSeq, FXseq1,0
dd 195.0, 11.0, 0, _renderAltSeq, FXseq2,0
dd 206.0, 16.0, 0, _renderCredits, 0,0
dd 222.0, 19.0, 0, _renderBrain, 0,0
dd 241.0, 2.5, 0, _renderCredits, 0,0
dd 28.1,  3.9, 0.8, _renderBboard, 16,EVENTF_FADEIO
dd 36.0, 10.0, 4.0, _renderBboard, 0,EVENTF_FADEIO
dd 51.0, 11.0, 3.0, _renderBboard, 1,EVENTF_FADEIO
dd 61.0,  16.0, 1.0, _renderBboard, 6,EVENTF_FADEIO
dd 75.0, 11.0, 3.0, _renderBboard, 7,EVENTF_FADEIO
dd 87.0, 12.0, 1.0, _renderBboard, 4,EVENTF_FADEIO
dd 103.0, 13.0, 5.0, _renderBboard, 8,EVENTF_FADEIO
dd 115.0, 11.0, 1.0, _renderBboard, 2,EVENTF_FADEIO
dd 134.0,  14.0, 3.0, _renderBboard, 3,EVENTF_FADEIO
dd 147.0,  5.0, 0.5, _renderBboard, 5,EVENTF_FADEIO
dd 163.0, 20.0, 5.0, _renderBboard, 9,EVENTF_FADEIO
dd 182.0, 12.0, 4.0, _renderBboard, 10,EVENTF_FADEIO
dd 195.0,  5.0, 0.5, _renderBboard, 11,EVENTF_FADEIO
dd 200.0,  6.0, 0.5, _renderBboard, 16,EVENTF_FADEIO
dd 219.0, 3.0, 0.5, _renderBboard, 12,EVENTF_FADEIO

beatInterval1: dd 30.9,96.0
beatInterval2: dd 154.371,55.0
%endif
quitTime: dd 244.0

;billboards info
%assign BBOARD_ALPHA 128
%assign BBOARD_MAX 17
DEFSTR bbFile1,'data/b01.bmp'
DEFSTR bbFile2,'data/b02.bmp'
DEFSTR bbFile3,'data/b03.bmp'
DEFSTR bbFile4,'data/b04.bmp'
DEFSTR bbFile5,'data/b05.bmp'
DEFSTR bbFile6,'data/b06.bmp'
DEFSTR bbFile7,'data/b07.bmp'
DEFSTR bbFile8,'data/b08.bmp'
DEFSTR bbFile9,'data/b09.bmp'
DEFSTR bbFile10,'data/b10.bmp'
DEFSTR bbFile11,'data/b13.bmp'
DEFSTR bbFile12,'data/b11.bmp'
DEFSTR bbFile13,'data/b12.bmp'
DEFSTR bbFile14,'data/bg1.bmp'
DEFSTR bbFile15,'data/bg2.bmp'
DEFSTR bbFile16,'data/fg.bmp'
DEFSTR bbFile17,'data/b14.bmp'
bbFileLUT: dd bbFile1,bbFile2,bbFile3,bbFile4,bbFile5,bbFile6
dd bbFile7,bbFile8,bbFile9,bbFile10,bbFile11,bbFile12,bbFile13
dd bbFile14,bbFile15,bbFile16,bbFile17

%assign BGID_LORENZ1 14
%assign BGID_LORENZ2 13
%assign BGID_WAVY 14
%assign FGID_ELEC 15
;==============================================================================
BSS_SEG_INIT
;==============================================================================
musicON: resd 1
beatTimer: resb timer_size
musicTime: resd 1
gbboard: resb billboard_size
gtexBluestreak: resb tex_size
gtexWavy: resb tex_size
gtexWavy2: resb tex_size
gtexCrystal: resb tex_size
gtexMetal1: resb tex_size
gtexMetal2: resb tex_size
gtexBubbles: resb tex_size
gtexFont: resb tex_size
gtexFlare: resb tex_size
gtexFlare1d: resb tex_size
gtexRainbow: resb tex_size
gtexRainbow2: resb tex_size
RTlmap: resb tex_size
cparam: resb cpal_size
texparam: resb rtp_size
myscene: resb scene_size
hdrscene: resb scene_size
glrscene: resb scene_size
RTmatrix: resb matrix_size
myobject: resd 1
;==============================================================================
TEXT_SEG_INIT
;==============================================================================
SDECL _getRandMat, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _seed
    LVAR    4, aX, aY
    LVAR    vec4_size, qr
    LENTER
    mov     dword[%$aX],2
    RandF   [%$_seed]
    fsub    dword[Real1d2]
    fimul   dword[%$aX]
;    fldpi
;    fmulp   st1
    fstp    dword[%$aX]
    RandF   [%$_seed]
    fadd    st0
    fldpi
    fmulp   st1
    fstp    dword[%$aY]
    lea     eax,[%$qr]
    QuatFromPolar eax,[%$aX],[%$aY]
    lea     eax,[%$qr]
    Quat2m33 RTmatrix, eax
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _getTimeMat, 0
;==============================================================================
    LCTX    edx
    LARG    4, _rmat, _tx, _ty, _sec
    mov     edx,esp

    fldpi
    fld     dword[%$_sec]
    fmul    dword[greal2000pi]
    fld     st0
    fidiv   dword[%$_tx]
    fsin
    fmul    st2
    fstp    dword[%$_tx]
    fidiv   dword[%$_ty]
    fsin
    fmulp   st1
    fstp    dword[%$_ty]
    
    M33fromEuler [%$_rmat], [%$_tx], [%$_ty], [gZero]
.exit:
DECLEND
;==============================================================================
SDECL _setCamFOV, 0
;==============================================================================
    LCTX    edx
    LARG    4, _cam, _angle
    mov     edx,esp
    CameraSetFrus [%$_cam], [myscene +scene.fb +tex.w],[myscene +scene.fb +tex.h], REAL_500,[Real1d1k],[%$_angle]
.exit:
DECLEND
;==============================================================================
SDECL _initScene, 0
;==============================================================================
    SceneInit   glrscene, 256, 192, 1, 0
    SceneInit   hdrscene, 128,  96, 1, 0

    MemAlloc (vertex_size *256)
    mov     dword[myobject],eax

    CCALL   _initTextures
    CCALL   _initNeo
    CCALL   _initCredits
    CCALL   _initLorenz
    CCALL   _initTunnel
    CCALL   _initRod
    CCALL   _initElectric
    CCALL   _initWavy
    CCALL   _initBeams
    CCALL   _initBrain
    CCALL   _initDisco
%if BBOARD_MAX != 0
    CCALL   _initBboard, gbboard, bbFileLUT, BBOARD_MAX
    CCALL   _initLorenz1bg, BGID_LORENZ1
    CCALL   _initLorenz2bg, BGID_LORENZ2
%endif
    TimeInit
    TimerReset beatTimer
DECLEND
;==============================================================================
SDECL _initBboard, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _bbinfo, _nameLUT, _count
    LVAR    4, pdat
    LENTER

    imul    eax,dword[%$_count],tex_size
    MemAlloc eax
    mov     edx,dword[%$_bbinfo]
    mov     dword[edx +billboard.data],eax
    mov     dword[%$pdat],eax
    mov     eax,dword[%$_count]
    mov     dword[edx +billboard.count],eax

.iterB:
    mov     eax,dword[%$_nameLUT]
    CCALL   _TEX_loadBmp, [%$pdat], [eax]
;next
    add     dword[%$_nameLUT],4
    add     dword[%$pdat],tex_size
    dec     dword[%$_count]
    jnz     .iterB
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL   _renderBboard, 0
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade, _data, _flags
    LVAR    4, result

    imul    eax,dword[%$_data],tex_size
    add     eax,dword[gbboard +billboard.data]
    cmp     dword[eax +tex.data],0
    je      .exit
    fld     dword[%$_fade]
    mov     dword[%$result],BBOARD_ALPHA
    fimul   dword[%$result]
    fabs
    fistp   dword[%$result]
    mov     edx,dword[%$result]
    CCALL   _TEX_layer, myscene +scene.fb, eax, edx
.exit:
DECLEND
;==============================================================================
SDECL _clearBg, 0
;==============================================================================
    LCTX    esp
    LARG    4, _bmpID
    
    imul    edx,dword[%$_bmpID],tex_size
    add     edx,dword[gbboard +billboard.data]
    cmp     dword[edx +tex.data],0
    je      .clearBg
    TexBlit     myscene +scene.fb,edx
    jmp     .exit
.clearBg:
    TexClear    myscene +scene.fb
    
.exit:
DECLEND
;==============================================================================
SDECL _initLorenz1bg, 0
;==============================================================================
    LCTX    esp
    LARG    4, _bmpID
    
    imul    edx,dword[%$_bmpID],tex_size
    add     edx,dword[gbboard +billboard.data]
    cmp     dword[edx +tex.data],0
    je      .exit
    CCALL   _TEX_sadd, edx, (0xff10 << 16)
    TexCreate RTlmap, 512,384
    RtpSetImm   texparam, _TEX_flare, RTPF_REV,1,1
    TexMake     RTlmap, texparam
    CCALL   _TEX_sadd, RTlmap, 0xffffff
    imul    edx,dword[%$_bmpID],tex_size
    add     edx,dword[gbboard +billboard.data]
    CCALL   _TEX_mul, edx, edx, RTlmap
    TexDestroy RTlmap
    
.exit:
DECLEND
;==============================================================================
SDECL _initLorenz2bg, 0
;==============================================================================
    LCTX    esp
    LARG    4, _bmpID
    
    imul    edx,dword[%$_bmpID],tex_size
    add     edx,dword[gbboard +billboard.data]
    cmp     dword[edx +tex.data],0
    je      .exit
    CCALL   _TEX_sadd, edx, (0x10 << 24)
.exit:
DECLEND
;==============================================================================
SDECL _setMovingCam, 0
;==============================================================================
    LCTX    esp
    LARG    4, _rad
    
    
    fld     dword[RTmatrix +matrix.u +vec3.z]
    fmul    dword[%$_rad]
    fstp    dword[RTmatrix +matrix.t +vec3.x]
    fld     dword[RTmatrix +matrix.v +vec3.z]
    fmul    dword[%$_rad]
    fstp    dword[RTmatrix +matrix.t +vec3.y]
    fld     dword[RTmatrix +matrix.n +vec3.z]
    fmul    dword[%$_rad]
    fstp    dword[RTmatrix +matrix.t +vec3.z]

    CameraSetRot RAS_main +raster.cam, RTmatrix
    CameraSetPos RAS_main +raster.cam, RTmatrix +matrix.t
    CameraUpdate RAS_main +raster.cam
.exit:
DECLEND
;==============================================================================
SDECL _initTextures, 0
;==============================================================================
    mov     ecx,7
.iterLights:
    imul    eax,ecx,light_size
    lea     eax,[Speclights +eax +light.dir]
    V3norm  eax
    dec     ecx
    jns     .iterLights

    TexCreate   RTlmap, 256,256
%assign %$TW 256
    TexCreate   gtexWavy, %$TW, %$TW
    TexCreate   gtexWavy2, %$TW, %$TW
    TexCreate   gtexCrystal, %$TW, %$TW
    TexCreate   gtexMetal2, %$TW, %$TW
    TexCreate   gtexBubbles, %$TW, %$TW
    TexCreate   gtexFont, %$TW, %$TW
    TexCreate   gtexBluestreak, %$TW, %$TW
    TexCreate   gtexFlare1d,256,1
    TexCreate   gtexFlare, %$TW, %$TW
%assign %$TW 128
    TexCreate   gtexMetal1, %$TW, %$TW
    TexCreate   gtexRainbow, %$TW,%$TW
    TexCreate   gtexRainbow2, %$TW,%$TW
;Bluestreak
    CCALL       _TEX_pixel, gtexBluestreak, 59668, 256
    TexShade    gtexBluestreak, PACKB2DW(0,160,192,240)
    CCALL       _TEX_blurWrap, gtexBluestreak, 10, 100, 3, BLURF_X
    CCALL       _TEX_blurWrap, gtexBluestreak, 3, 140, 1, BLURF_Y
;metal2
    RtpSetImm   texparam, _TEX_poly, 0,4,4
    TexMake     RTlmap, texparam
    TexClear    gtexMetal2,PACKB2DW(255,255,255,255)
    CCALL   _TEX_bumpmap, gtexMetal2, RTlmap, Metal2lights, 3, 256, 4
    TexClear    gtexFlare1d
    SpalSetImm  cparam, 0, 240, 0xffffffff, 0xffffffff
    Tex32MakePal gtexFlare1d, cparam, TEX32_SPAL
    SpalSetImm  cparam, 240, 255, 0xffffffff, 0
    Tex32MakePal gtexFlare1d, cparam, TEX32_SPAL
    TexShadePal RTlmap, gtexFlare1d
    CCALL       _TEX_sadd, gtexMetal2, 0xff000000
    CCALL       _TEX_mul, gtexMetal2, gtexMetal2,RTlmap
;wavy2
    CCALL       _TEX_pixel, RTlmap, 3156598, 256
    CCALL       _TEX_blurWrap, RTlmap, 20, 80, 3, BLURF_XY
    RtpSetImm   texparam, _TEX_wavy, 0, 2, 1, 50, 3
    TexMake    gtexBubbles, texparam
    CCALL   _TEX_distort, RTlmap, gtexBubbles, gtexBubbles, 255
    TexClear gtexWavy2, 0x00ffffff
    CCALL   _TEX_bumpmap, gtexWavy2, RTlmap, Wavy2lights, 2, 128, 2
    CCALL       _TEX_blurWrap, gtexWavy2, 1, 35, 1, BLURF_XY
    CCALL       _TEX_sadd, gtexWavy2, 0xff000000
;wavy
    CCALL       _TEX_pixel, gtexWavy, 3156598, 256
    CCALL       _TEX_blurWrap, gtexWavy, 20, 85, 3, BLURF_XY
    RtpSetImm   texparam, _TEX_cloth, RTPF_REV, 2, 1
    TexMake     RTlmap, texparam
    CCALL   _TEX_distort, gtexWavy, RTlmap, RTlmap, 255
    TexShade    gtexWavy, PACKB2DW(0,240,128, 32)

    CCALL       _TEX_pixel, gtexCrystal, 315658, 256
    CCALL       _TEX_blurWrap, gtexCrystal, 10, 65, 3, BLURF_XY
    RtpSetImm   texparam, _TEX_wavy, 0, 2, 1
    TexMake     RTlmap, texparam
    CCALL       _TEX_distort, gtexCrystal, RTlmap, RTlmap, 128
    CCALL       _TEX_add, gtexWavy, gtexWavy, gtexCrystal
;crystal
    RtpSetImm   texparam, _TEX_cell, RTPF_CELL3, 1, 1
    mov     dword[texparam +rtp.maxPts],34
    TexMake    RTlmap, texparam
    TexClear    gtexCrystal,PACKB2DW(255,255,255,255)
    CCALL   _TEX_bumpmap, gtexCrystal, RTlmap, Speclights, 3, 256, 2
;bubbles
    RtpSetImm   texparam, _TEX_cell, RTPF_CELL2, 1, 1
    mov     dword[texparam +rtp.maxPts],30
    TexMake    RTlmap, texparam
    TexClear    gtexBubbles,PACKB2DW(0,255,255,255)
    CCALL   _TEX_bumpmap, gtexBubbles, RTlmap, Speclights, 2, 256, 2
;font
;    CpalSetImm  cparam, 0, 256, 0, 0x00ffffff, 100, 37, 366, 0x425561f3
;    CpalSetImm  cparam, 0, 256, 0, 0x00ffffff, 466, 153, 167, 0x41240B35
;    CpalSetImm  cparam, 0, 256, 0, 0x00ffffff, 466, 151, 167, 0x416FA91E
;    CpalSetImm  cparam, 0, 256, 0, 0x00ffffff, 466, 151, 167, 0x4167FA64
;    CpalSetImm  cparam, 0, 256, 0, 0x00ffffff, 491, 224, 196, 0x40D3DD36
    CpalSetImm  cparam, 0, 256, 0, 0x00ffffff, 400, 209, 102, 0x418E39E5
    Tex32MakePal gtexFlare1d, cparam, TEX32_CPAL
    CCALL       _TEX_pixel, gtexFont, 31563, 128
    CCALL       _TEX_blurWrap, gtexFont, 20, 90, 3, BLURF_XY
    TexShadePal gtexFont,gtexFlare1d
    CCALL       _TEX_blurWrap, gtexFont, 20, 35, 3, BLURF_XY
    CCALL       _TEX_sadd, gtexFont, 0xff000000
;metal1
    TexResize   RTlmap, 128,128
    RtpSetImm   texparam, _TEX_poly, RTPF_OFFSET,8,8
    TexMake     RTlmap, texparam
    TexClear    gtexMetal1,PACKB2DW(0,255,255,210)
    CCALL   _TEX_bumpmap, gtexMetal1, RTlmap, Speclights, 3, 256, 5
    TexShade    RTlmap, PACKB2DW( 30,210,128,240)
    CCALL   _TEX_add, gtexMetal1,gtexMetal1,RTlmap
;rainbow flare
    TexResize   RTlmap, 256,1
    SpalSetImm  cparam, 0,80,0x00ff8080,0x00ffff80
    Tex32MakePal RTlmap,cparam,TEX32_SPAL
    SpalSetImm  cparam, 80,96,0x00ffff80,0x0080ff80
    Tex32MakePal RTlmap,cparam,TEX32_SPAL
    SpalSetImm  cparam, 96,112,0x0080ff80,0x0080ffff
    Tex32MakePal RTlmap,cparam,TEX32_SPAL
    SpalSetImm  cparam, 112,144,0x0080ffff,0x008080ff
    Tex32MakePal RTlmap,cparam,TEX32_SPAL
    SpalSetImm  cparam, 144,224,0x008080ff,0x00ff80ff
    Tex32MakePal RTlmap,cparam,TEX32_SPAL
    SpalSetImm  cparam, 224,256,0x00ff80ff,0x00ffffff
    Tex32MakePal RTlmap,cparam,TEX32_SPAL

    RtpSetImm   texparam, _TEX_spal, 0,4,1
    TexMake     gtexFlare1d, texparam
    CCALL   _TEX_mul, gtexFlare1d, RTlmap, gtexFlare1d

    RtpSetImm   texparam, _TEX_flare, 0,1,1
    TexMake     gtexRainbow, texparam
    TexBlit     gtexRainbow2, gtexRainbow
    TexShadePal gtexRainbow, gtexFlare1d

    RtpSetImm   texparam, _TEX_spal, 0,2,1
    TexMake     gtexFlare1d, texparam
    CCALL   _TEX_mul, gtexFlare1d, RTlmap, gtexFlare1d
    TexShadePal gtexRainbow2, gtexFlare1d
;flare1d
    RtpSetImm   texparam, _TEX_flareX, 0,2,1
    TexMake     gtexFlare1d, texparam
;flare2d
    RtpSetImm   texparam, _TEX_flare, 0,2,1
    TexMake     gtexFlare, texparam

    TexDestroy RTlmap
DECLEND
;==============================================================================
SDECL _TIMER_event, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _info
    LVAR    4, ratio, dt, alpha, flags
    LENTER
    mov     edx,dword[%$_info]
    fld     dword[musicTime]
    fsub    dword[edx +timeevent.mark]
    fst     dword[%$dt]
    fdiv    dword[edx +timeevent.total]
    fstp    dword[%$ratio]
    test    dword[%$ratio],REAL_SIGNMASK
    jnz     .exit
    fld1
    _FCOMP_MEM dword[%$ratio]
    jc      .exit
    test    dword[edx +timeevent.flags],EVENTF_REV
    jz      .endRev
    fld1
    fsub    dword[%$ratio]
    fst     dword[%$ratio]
    fmul    dword[edx +timeevent.total]
    fstp    dword[%$dt]
.endRev:
;comp a linear fade in/out value
    mov     eax,dword[edx +timeevent.flags]
    and     eax,~EVENTF_FADEIO
    mov     dword[%$flags],eax
    mov     dword[%$alpha],REAL_1
    fld     dword[%$dt]
    test    dword[edx +timeevent.flags],EVENTF_FADEIN
    jz      .outTest
    _FCOM_MEM dword[edx +timeevent.fadetime]
    jnc     .outTest
    or      dword[%$flags],EVENTF_FADEIN
    jmp     .fadeio
.outTest:
    test    dword[edx +timeevent.flags],EVENTF_FADEOUT
    jz      .endfade
    fsubr   dword[edx +timeevent.total]
    _FCOM_MEM dword[edx +timeevent.fadetime]
    jnc     .endfade
    or      dword[%$flags],EVENTF_FADEOUT
.fadeio:
    fdiv    dword[edx +timeevent.fadetime]
    fst     dword[%$alpha]
.endfade:
    ffreep  st0
.docall:
    CCALL   dword[edx +timeevent.fn],[%$ratio],[edx +timeevent.total],[%$alpha],[edx +timeevent.data],[%$flags]
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _updateCustomBeat, 0
;==============================================================================
    LCTX    esp
    LARG    4, _tm, _binfo
    
    mov     edx,dword[%$_binfo]
    xor     eax,eax
    mov     dword[edx +beatinfo.count],eax
    mov     edx,dword[%$_tm]
    fld1
    fstp    dword[edx +timer.speed]
    fld     dword[musicTime]
    _FCOM_MEM dword[beatInterval1]
    jc      .exit
    fsub    dword[beatInterval1]
    _FCOM_MEM dword[beatInterval1 +4]
%ifndef _LORENZ_TEST_
    jc      .setSpeed
    fld     dword[musicTime]
    _FCOM_MEM dword[beatInterval2]
    jc      .exit
    fsub    dword[beatInterval2]
    _FCOM_MEM dword[beatInterval2 +4]
%endif
    jnc     .exit
.setSpeed:
    mov     eax,dword[%$_binfo]
    fmul    dword[eax +beatinfo.bps]
    fld     st0
    fist    dword[eax +beatinfo.count]
    frndint
    fsubp   st1
    fmul    dword[eax +beatinfo.spdMax]
    fadd    dword[eax +beatinfo.spdMin]
    fstp    dword[edx +timer.speed]
.exit:
    _EMMS
DECLEND
;==============================================================================
SDECL _updateAll, 0
;==============================================================================
    TimeUpdate
    mov     eax,dword[RTM_time]
    mov     dword[musicTime],eax
%ifndef _LORENZ_TEST_
    xor     eax,eax
    or      eax,dword[musicON]
    jz      .endMusicUpdate
    SndUpdate
    fstp    dword[musicTime]
.endMusicUpdate:
%endif
    CCALL   _updateCustomBeat, beatTimer, defaultBeat
    TimerUpdate beatTimer, [RTM_dt]

    CCALL   _updateTunnel
    CCALL   _updateRod
    CCALL   _updateElectric
    CCALL   _updateWavy
    CCALL   _updateBeams
    CCALL   _updateDisco

    IsESCpress
.exit:
DECLEND
;==============================================================================
SDECL _renderAltSeq, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _ratio, _total, _fade, _data, _flags
    LVAR    4, fxID, subratio
    LENTER
    fld     dword[%$_ratio]
    fmul    dword[%$_total]
    mov     eax,dword[%$_data]
    fdiv    dword[eax]
    fist    dword[%$fxID]
    fisub   dword[%$fxID]
    fstp    dword[%$subratio]

    xor     edx,edx
    mov     eax,dword[%$fxID]
    div     dword[FXtotal]
    CCALL   dword[FXlut +edx*4]
    fld     dword[%$subratio]
    mov     edx,dword[%$_data]
    _FCOM_MEM dword[edx +4]
    jc      .doTransition
    fld1
    fsubrp  st1
    _FCOM_MEM dword[edx +4]
    jnc     .exit
.doTransition:
    fdiv    dword[edx +4]
    fld1
    fsubrp  st1
    fstp    dword[%$subratio]
    xor     eax,eax
    CCALL   _fadeWhite, eax,eax,[%$subratio]
.exit:
    _EMMS
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _loopEventAll, 0
;==============================================================================
    LCTX    esp
    LARG    4, _events, _count
    cmp     dword[%$_count],1
    jl      .exit
.iterN:
    mov     eax,dword[%$_events]
    CCALL   _TIMER_event, eax
    add     dword[%$_events],timeevent_size
    dec     dword[%$_count]
    jnz     .iterN
.exit:
DECLEND
;==============================================================================
SDECL _offsetEventAll, 0
;==============================================================================
    LCTX    esp
    LARG    4, _events, _count, _secOffset
    cmp     dword[%$_count],1
    jl      .exit
.iterN:
    mov     eax,dword[%$_events]
    fld     dword[eax +timeevent.mark]
    fadd    dword[%$_secOffset]
    fstp    dword[eax +timeevent.mark]
    add     dword[%$_events],timeevent_size
    dec     dword[%$_count]
    jnz     .iterN
.exit:
DECLEND
;==============================================================================
SDECL _renderAll, 0
;==============================================================================
    RasSetScene myscene
    CCALL   _loopEventAll, geventLUT, [geventTotal]
.exit:
DECLEND
;==============================================================================
SDECL _endProgram, 0
;==============================================================================
    fld     dword[musicTime]
    _FCOMP_MEM  dword[quitTime]
    jc      .exit
    SysFlagSet(SYSFLAG_QUIT)
.exit:
DECLEND
;==============================================================================
SDECL _mymain, 0
;==============================================================================
.init:
    SceneInit   myscene, 512, 384, 1, 1
    RasInit

    VGAinit mytitle, 512, 384, 0, myscene +scene.fb
    test    eax,eax
    jz near .shutdown

    CCALL   _initScene
%ifndef _LORENZ_TEST_
    SndInit demoMusik
    mov     dword[musicON],eax
%endif
.update:
    CCALL   _updateAll
    CCALL   _renderAll
    CCALL   _endProgram
    Tex32dump myscene +scene.fb, "preview", 512, 384
    FpsUpdate myscene +scene.fb
    VGAupdate myscene +scene.fb
    IsSysFlagSet(SYSFLAG_QUIT)
    jz      .update

    SndShutdown
.shutdown:
    VGAshutdown

.exit:
DECLEND
;==============================================================================
%include "credits.asm"
%include "lorenz.asm"
%include "tunnel.asm"
%include "rod.asm"
%include "electric.asm"
%include "wavy.asm"
%include "beams.asm"
%include "mcube.asm"
%include "brain.asm"
%include "disco.asm"
%include "neo.asm"
