;******************************************************************************
; lorenz.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================

;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
cubeScale1: dd 50.0,50.0,50.0
cubeScale2: dd 20.0,20.0,20.0
lorenzScale: dd 100.0
lorenz1wait: dd 3.0
lorenz2lerpTime: dd 1.0
lorenz2minDist: dd 4.0
lorenz2amplDist: dd 16.0
lorenz2movingTime: dd 1.5
lorenz2TravelTime: dd 4.0
lorenz2c1: dd 600.0
;==============================================================================
section .bss
;==============================================================================
%assign LORENZ_COUNT 6000
%assign LORENZ1_STRIDE 6
%assign LORENZ2_STRIDE 2
lorenzVec: resd 1
lorenz1Timer: resb timer_size
lorenz2Timer: resb timer_size
lorenz1seed: resd 1
lorenz1posId: resd 1
lorenz2seed: resd 1
lorenz2posId: resd 1
lorenz2rgba: resd 1
;==============================================================================
section .text
;==============================================================================
SDECL _initLorenz, 0
;==============================================================================
    MemAlloc vec3_size *LORENZ_COUNT
    mov     dword[lorenzVec],eax
    CCALL   _LORENZ_init, [lorenzVec], LORENZ_COUNT
    TimerReset  lorenz1Timer
    TimerReset  lorenz2Timer
    mov     eax,dword[lorenzVec]
    mov     dword[eax +vec3.x],REAL_1D100
    mov     dword[lorenz2seed],8984579
    mov     dword[lorenz1seed],0xbadafe
;spiral1 center 950, spiral2 center 250
    mov     dword[lorenz2posId],250
    mov     dword[lorenz1posId],250
DECLEND
;==============================================================================
SDECL _updateLorenz, 0
;==============================================================================
    LCTX    esp
    LVAR    4, count
    
    TimerUpdate lorenz1Timer,[RTM_dt]

    fld     dword[lorenz1Timer +timer.sec]
    _FCOMP_MEM dword[lorenz1wait]
    jc      .endSeedUpd
    xor     eax,eax
    mov     dword[lorenz1Timer +timer.sec],eax
    RandFqd lorenz1seed
    mov     dword[%$count], 50
    fimul   dword[%$count]
    mov     dword[%$count],300
    fiadd   dword[%$count]
    fistp   dword[lorenz1posId]
.endSeedUpd:

    CCALL   _getTimeMat, RTmatrix, 42279, 38741,[RTM_time]
    imul    edx,dword[lorenz1posId],vec3_size *LORENZ1_STRIDE
    CCALL   _setLorenzCam, [lorenz2minDist],edx
.exit:
DECLEND
;==============================================================================
SDECL _updateLorenz2, 0
;==============================================================================
    LCTX    esp
    LVAR    4, radius, count
    
    TimerUpdate lorenz2Timer,[RTM_dt]

    fld     dword[lorenz2Timer +timer.sec]
    _FCOMP_MEM dword[lorenz2TravelTime]
    jc      .endSeedUpd
    xor     eax,eax
    mov     dword[lorenz2Timer +timer.sec],eax
    RandF   lorenz2seed
    mov     dword[%$count],800 ;480
    fimul   dword[%$count]
    mov     dword[%$count],200 ;220
    fiadd   dword[%$count]
    fistp   dword[lorenz2posId]
.endSeedUpd:
    
    CCALL   _getTimeMat, RTmatrix, 92279, 88741,[beatTimer +timer.sec]
    
    mov     eax,dword[lorenz2minDist]
    mov     dword[%$radius],eax
    fld     dword[lorenz2Timer +timer.sec]
    fdiv    dword[lorenz2movingTime]
    fld1
    _FCOMP  st1
    jc      .endClipMax
    fld1
    fsubrp  st1
    fmul    dword[lorenz2amplDist]
    fadd    dword[lorenz2minDist]
    fst     dword[%$radius]
.endClipMax:
    ffreep  st0
    
    mov     eax,dword[%$radius]
    imul    edx,dword[lorenz2posId],vec3_size *LORENZ2_STRIDE
    CCALL   _setLorenzCam, eax,edx
.exit:
DECLEND
;==============================================================================
SDECL _setLorenzCam, 0
;==============================================================================
    LCTX    esp
    LARG    4, _radius, _id
    
    mov     edx,dword[%$_id]
;    imul    edx,dword[%$_id],vec3_size *LORENZ1_STRIDE
    add     edx,dword[lorenzVec]
    fld     dword[RTmatrix +matrix.u +vec3.z]
    fmul    dword[%$_radius]
    fsubr   dword[edx +vec3.x]
    fmul    dword[lorenzScale]
    fstp    dword[RTmatrix +matrix.t +vec3.x]
    fld     dword[RTmatrix +matrix.v +vec3.z]
    fmul    dword[%$_radius]
    fsubr   dword[edx +vec3.y]
    fmul    dword[lorenzScale]
    fstp    dword[RTmatrix +matrix.t +vec3.y]
    fld     dword[RTmatrix +matrix.n +vec3.z]
    fmul    dword[%$_radius]
    fsubr   dword[edx +vec3.z]
    fmul    dword[lorenzScale]
    fstp    dword[RTmatrix +matrix.t +vec3.z]
    
    CameraSetRot RAS_main +raster.cam, RTmatrix
    CameraSetPos RAS_main +raster.cam, RTmatrix +matrix.t
    CameraUpdate RAS_main +raster.cam
.exit:
DECLEND
;==============================================================================
SDECL _VPGM_lorenz
;==============================================================================
    LCTX    esp
    LARG    4, _pvert
    
    mov     edx,dword[%$_pvert]
    mov     eax,dword[lorenz2rgba]
    V4setImm edx +vertex.c, eax, eax, eax,eax
.exit:
DECLEND
;==============================================================================
SDECL _lorenzRadialBlur, 0
;==============================================================================
    CCALL   _TEX_xor, myscene +scene.fb, (0xff << 24)
    CCALL   _TEX32_downsample, hdrscene +scene.fb, myscene +scene.fb
    CCALL   _TEX32_glare, hdrscene +scene.fb, 64, 48, 236, 18, 30, 255
    CCALL   _TEX32_upsample, myscene +scene.fb, hdrscene +scene.fb
;    TexBlit myscene +scene.fb, hdrscene +scene.fb
.exit:
DECLEND
;==============================================================================
SDECL _renderSpiral, 0
;==============================================================================
    MPUSH   ecx,edi,ebp
    LCTX    ebp
    LARG    4, _stride
    LVAR    4, ratio
    LENTER
    TexClear    myscene +scene.zb
    
    ObjSetVpgm _VPGM_lorenz
    ObjSetFlags OBJ_CUBE, 0, 0
    RasSetCulling CULLING_BACK
    RasSetFpgm _FPGM_RGBxT0bi_AZ
    RasSetVpgm _VPGM_RGBT0
    RasSetTex 0,gtexMetal2

    fld     dword[RTM_time]
    fdiv    dword[lorenz2lerpTime]
    fld     st0
    frndint
    fsubp   st1
    fstp    dword[%$ratio]
    mov     edi,dword[lorenzVec]
    
    xor     edx,edx
    mov     eax,LORENZ_COUNT
    div     dword[%$_stride]
    lea     ecx,[eax -2]
align 4
.iterV:
    imul    edx,dword[%$_stride],vec3_size
    lea     eax,[edi +edx]
    V3interpolate OBJ_tform +objtform.rm +matrix.t, edi, eax, [%$ratio]
    V3smul  OBJ_tform +objtform.rm +matrix.t, OBJ_tform +objtform.rm +matrix.t, lorenzScale
    CCALL   _OBJ_render3D
;next
    imul    edx,dword[%$_stride],vec3_size
    add     edi,edx
    dec     ecx
    jnz     .iterV
.exit:
    LEXIT
    MPOP    ecx,edi,ebp
DECLEND
;==============================================================================
SDECL _renderLorenz, 0
;==============================================================================
    CCALL   _clearBg, BGID_LORENZ1
    mov     eax,dword[lorenz2c1]
    mov     dword[lorenz2rgba],eax
    CCALL   _updateLorenz

    ObjSetScale cubeScale1
    CCALL   _getTimeMat, OBJ_tform +objtform.rm, 15384, 12631,[RTM_time]
    CCALL   _renderSpiral, LORENZ1_STRIDE
    CCALL   _lorenzRadialBlur
.exit:
DECLEND
;==============================================================================
SDECL _renderLorenz2, 0
;==============================================================================
    CCALL   _clearBg, BGID_LORENZ2

    mov     eax,dword[greal256]
    mov     dword[lorenz2rgba],eax
    CCALL   _updateLorenz2

    ObjSetScale cubeScale2
    CCALL   _getTimeMat, OBJ_tform +objtform.rm, 35384, 37631,[beatTimer +timer.sec]
    CCALL   _renderSpiral, LORENZ2_STRIDE
    CCALL   _TEX32_downsample, hdrscene +scene.fb, myscene +scene.fb
    CCALL   _TEX_blur, hdrscene +scene.fb, hdrscene +scene.bb, 2, 39, 3
    CCALL   _TEX32_upsample, myscene +scene.fb, hdrscene +scene.fb
;    TexBlit myscene +scene.fb, hdrscene +scene.fb
.exit:
DECLEND
;==============================================================================
