;******************************************************************************
; electric.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
reflecScale: dd 200.0,200.0,200.0
reflecScale2: dd 2000.0,2000.0,2000.0
elecRadius: dd 1000.0
elecRotSpeed: dd 0.1
elecCamRadAmpl: dd 250.0
elecCamRadMin: dd 750.0
electricStorm: dd 0,0,43765,1.5,1.5,0.5,_updateElecStrike, _renderElecStrike
maxElecFreq: dd  0.5
minElecFreq: dd 2.5
elecLTNG: dd 20.0,2.0,2.0,0.5,0.437,1.0,0.5,0.5,0,0,5,5,LTNGF_P2P
elecGlowRadius: dd 200.0
elecDistMax: dd 1200.0
elecDistMin: dd 210.0
elecPhoton: dd 0,0,gtexRainbow,PSF_RESPAWN | PSF_ZTEST,0.5,1.0,1.396,1.745,0.2,20.0,600.0,0xff37fe
dd 0,0,0, 0,0,0,1.0,  64.0,256.0,256.0,0

elecOuterAlpha: dd 92.0
elecRgbLUT:
dd 192.0,192.0,240.0
dd 240.0,192.0,192.0
dd 128.0,192.0,240.0
dd 240.0,192.0,240.0
;dd 100.0,100.0,220.0
;dd 220.0,100.0,100.0
;dd  64.0,100.0,220.0
;dd 220.0,100.0,220.0


;==============================================================================
;section .bss
;==============================================================================

;==============================================================================
section .text
;==============================================================================
SDECL _updateElecBolt, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _pseed, _fade
    LENTER
    mov     dword[ltngBolt +ltng.tr +trail.flaretex],gtexFlare
    mov     dword[ltngBolt +ltng.tr +trail.tex],gtexFlare1d
    Memcpy  ltngBolt +ltng.diam , elecLTNG, ltng_size - trail_size
    RandF   [%$_pseed]
    fmul    dword[maxElecFreq]
    fadd    dword[minElecFreq]
    fmul    dword[RTM_time]
    fstp    dword[ltngBolt +ltng.freqY]
    RandF   [%$_pseed]
    fmul    dword[maxElecFreq]
    fadd    dword[minElecFreq]
    fmul    dword[RTM_time]
    fstp    dword[ltngBolt +ltng.freqZ]
    RandI   [%$_pseed]
    and     eax,0x3
    imul    eax,vec3_size
    V3smul  ltngBolt +ltng.tr +trail.c, elecRgbLUT +eax, %$_fade
    xor     eax,eax
    mov     dword[ltngBolt +ltng.tr +trail.c +rgbaUP.a],eax
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _updateElecStrike, 0
;==============================================================================
    MPUSH   esi,ebp
    LCTX    ebp
    LARG    4, _pstr, _doinit
    LVAR    4, seed, ang
    LVAR    vec4_size, qr
    LVAR    matrix_size, rmat
    LENTER
    
    xor     eax,eax
    or      eax,dword[%$_doinit]
;    jz      .noinit
    jnz     .exit
.noinit:
    mov     esi,dword[%$_pstr]
    mov     eax,dword[esi +ltngstrike.seed]
    mov     dword[%$seed],eax
    lea     eax,[%$seed]
    CCALL   _getRandMat, eax
    V3eq    esi +ltngstrike.p2, RTmatrix +matrix.n
    V3smul  esi +ltngstrike.p1, esi +ltngstrike.p2, reflecScale
.exit:
    LEXIT
    MPOP    esi,ebp
DECLEND
;==============================================================================
SDECL _renderElecStrike, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _pstr, _seed, _fade
    LVAR    particle_size, mypt
    LENTER
    lea     eax,[%$_seed]
    CCALL   _updateElecBolt, eax, [%$_fade]
;render
	RasSetFpgm _FPGM_RGBxT0add_Z
	mov     edx,dword[%$_pstr]
    lea     eax,[edx +ltngstrike.p1]
    lea     edx,[edx +ltngstrike.p2]
    CCALL   _LTNG_render, ltngBolt, eax, edx, [elecRadius]
;render particle
    mov     eax,dword[elecGlowRadius]
    mov     dword[%$mypt +particle.rad],eax
	mov     edx,dword[%$_pstr]
    V3smul  %$mypt +particle.p, edx +ltngstrike.p2, elecDistMin
    RasSetSrcBlendImm 255,255,255,255
    RasSetTex 0, gtexRainbow
    lea     eax,[%$mypt]
    CCALL   _PT_renderFast, eax, 1
	mov     edx,dword[%$_pstr]
    V3smul  %$mypt +particle.p, edx +ltngstrike.p2, elecDistMax
    lea     eax,[%$mypt]
    CCALL   _PT_renderFast, eax, 1
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _initElectric, 0
;==============================================================================
    CCALL   _LTNGSTORM_init, electricStorm, 12
    CCALL   _PS_init, elecPhoton, 1024
    CCALL   _PS_resetPhoton, elecPhoton
DECLEND
;==============================================================================
SDECL _setElectricCam, 0
;==============================================================================
    LCTX    esp
    LVAR    4, result

    CCALL   _getTimeMat,RTmatrix,57279,49741,[beatTimer +timer.sec]
    fld     dword[elecCamRadAmpl]
    fadd    dword[elecCamRadMin]
    fchs
    fstp    dword[%$result]
    CCALL   _setMovingCam, [%$result]
.exit:
DECLEND
;==============================================================================
SDECL _updateElectric, 0
;==============================================================================
    CCALL   _LTNGSTORM_update, electricStorm, [RTM_dt]
.exit:
DECLEND
;==============================================================================
SDECL _VPGM_elec
;==============================================================================
    MPUSH   edi,ebp
    LCTX    ebp
    LARG    4, _pvert
    LVAR    vec3_size, rnormals
    LVAR    4, result, pnorm, ratio
    LENTER
    
    mov     edi, dword[%$_pvert]
    fld1
    fadd    dword[edi +vertex.nx]
    fadd    st0
    fld1
    fadd    dword[edi +vertex.ny]
    fadd    st0
    fld1
    fadd    dword[edi +vertex.nz]
    fadd    dword[RND_nparam +noise.ampl]
    fxch    st2
    fstp    dword[RND_nparam +noise.x]
    fstp    dword[RND_nparam +noise.y]
    fstp    dword[RND_nparam +noise.z]
    CCALL   _RND_perlin3D
    fld     st0
    fadd    dword[RND_nparam +noise.x]
    fcos
    fmul    dword[Real1d2]
    fadd    dword[edi +vertex.nx]
    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fadd    dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fst     dword[edi +vertex.v1]
    fstp    dword[edi +vertex.u0]
    fadd    dword[RND_nparam +noise.z]
    fsin
    fmul    dword[Real1d2]
    fadd    dword[edi +vertex.ny]
    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fadd    dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fst     dword[edi +vertex.u1]
    fstp    dword[edi +vertex.v0]
    
    mov     eax,dword[elecOuterAlpha]
    V4setImm edi +vertex.c, eax,eax,eax,eax
    LEXIT
    MPOP    edi,ebp
DECLEND
;==============================================================================
SDECL _renderElectric, 0
;==============================================================================
    mov     eax,dword[Real1d2]
    mov     dword[RND_nparam +noise.gain],eax
    fld1
    fadd    st0
    fstp    dword[RND_nparam +noise.pers]
    mov     dword[RND_nparam +noise.iter], 4
    fld     dword[RTM_time]
;    fmul    dword[Real1d2]
    fstp    dword[RND_nparam +noise.ampl]

    TexClear    myscene +scene.fb
    TexClear    myscene +scene.zb
    CCALL       _setElectricCam
    
    CCALL   _renderReflecSphere
    CCALL   _renderOuterSphere
    CCALL   _LTNGSTORM_render, electricStorm
    RasSetFpgm _PTFPGM_T0add
    mov     eax,dword[RTM_dt]
    xor     eax,REAL_SIGNMASK
    CCALL   _PS_renderPhoton, elecPhoton, eax

%ifdef FGID_ELEC    
    mov     edx,dword[gbboard +billboard.data]
    lea     edx,[edx +tex_size*FGID_ELEC]
    cmp     dword[edx +tex.data],0
    je      .exit
    CCALL   _TEX_blend, myscene +scene.fb,myscene +scene.fb,edx,256,128,0
%endif
.exit:
DECLEND
;==============================================================================
SDECL _renderReflecSphere, 0
;==============================================================================
    RasSetTex   0,gtexWavy2
    RasSetCulling CULLING_BACK
    RasSetFpgm _FPGM_T0bi_Z
    RasSetVpgm _VPGM_T0

    M33id OBJ_tform +objtform.rm
    V3setNull OBJ_tform +objtform.rm +matrix.t
    ObjSetScale reflecScale
    ObjSetVpgm _VPGM_elec
    ObjSetFlags OBJ_ICOSA, 2, OBJF_NORM
    CCALL   _OBJ_render3D
.exit:
DECLEND
;==============================================================================
SDECL _renderOuterSphere, 0
;==============================================================================
    RasSetTex   0,gtexWavy2
    RasSetCulling CULLING_FRONT
    RasSetFpgm _FPGM_RGBxT0bi_Z
    RasSetVpgm _VPGM_RGBT0

    M33id OBJ_tform +objtform.rm
    V3setNull OBJ_tform +objtform.rm +matrix.t
    ObjSetScale reflecScale2
;    ObjSetVpgm _VPGM_outerSphere
;    ObjSetVpgm 0
;    ObjSetFlags OBJ_CUBE, 0, 0
    ObjSetVpgm _VPGM_elec
    ObjSetFlags OBJ_ICOSA, 2, OBJF_NORM
    CCALL   _OBJ_render3D
.exit:
DECLEND
;==============================================================================
