;******************************************************************************
; brain.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
TCTX    shcube
TVAR    shcube.x    ,4
TVAR    shcube.y    ,4
TVAR    shcube.z    ,4
TVAR    shcube.dist ,4
TVAR    shcube.ax   ,4
TVAR    shcube.ay   ,4
TVAR    shcube.c    ,4
ENDT    shcube

TCTX    fshear
TVAR    fshear.dir  ,vec3_size
TVAR    fshear.pos  ,vec3_size
TVAR    fshear.freq ,4
TVAR    fshear.ampl ,4
ENDT    fshear
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
brainCube1: dd 0, 0, 2.5, 10.0, 10493, 11001, PACKB2DW(0,255,128,128)
brainCube2: dd 2.5, 0, -2.5, 10.0, 8512, 9451, PACKB2DW(0,128,255,128)
brainCube3: dd -2.5, 0, -2.5, 10.0, 6981, 7656, PACKB2DW(0,128,128,255)
brainCamPos: dd 0,0,0.0
brainCamPolar: dd -0.25, 0.25, 2.5
brainCamDist: dd 6.0
brainCamFov: dd 1.05
brainFieldinfo: dd 2.0,2.0,2.0, 0,0,0, 16,16,16, 1.0,1,brainMCubeInfo
brainMCubeInfo: dd 0,0,0, 0.99,_MCUBE_hexa,PACKB2DW(0,0,0,8)
brainFont: dd 16, 0.75, 0.2,0.4,0.5

brainlights:
dd 2.0,-4.0,-2.0,0, 0,0,0,0, 0.6,0.6,0.6,0.0
dd 0,0,PACKB2DW(0,0,LIGHT_POS,1)
dd -5.0,-3.0,-5.0,0, 0,0,0,0, 1.2,1.2,1.2,0.0
dd 16.0,0,PACKB2DW(0,0,LIGHT_SPEC,1)

%ifndef _LORENZ_TEST_
brainStartOffset: dd 222.0
%else
brainStartOffset: dd 0.0
%endif

brainEventTotal: dd 13
brainEvents:
dd 0.0, 20.0, 0, _updateBrain, 0, 0
dd 9.0, 2.0, 0.2, _animShear2, gshear2, EVENTF_FADEIO
dd 15.5, 3.0, 0.2, _animShear2, gshear2, EVENTF_FADEIO
dd 0.0, 2.0, 0.3, _shatterCube, brainCube1, EVENTF_FADEOUT | EVENTF_REV
dd 2.0, 14.0, 0, _animBrainCube, brainCube1, 0
dd 16.0, 1.0, 0.3, _shatterCube, brainCube1, EVENTF_FADEOUT
dd 0.5, 2.0, 0.3, _shatterCube, brainCube2, EVENTF_FADEOUT | EVENTF_REV
dd 2.5, 14.0, 0, _animBrainCube, brainCube2, 0
dd 16.5, 1.0, 0.3, _shatterCube, brainCube2, EVENTF_FADEOUT
dd 1.0, 1.5, 0.3, _shatterCube, brainCube3, EVENTF_FADEOUT | EVENTF_REV
dd 2.5, 14.5, 0, _animBrainCube, brainCube3, 0
dd 17.0, 1.0, 0.3, _shatterCube, brainCube3, EVENTF_FADEOUT
dd 2.0, 15.0, 0, _animBrainFont, 0, 0

pbTitleBrainTotal: dd 8
pbTitleBrain: 
dd 3.0, 1.0, 0, _animShear, gshear1, 0
dd 11.5, 1.0, 0, _animShear, gshear1, 0
dd 2.0, 1.0, 1.0, _passbyTitle, gpbrainTitle1, EVENTF_FADEOUT
dd 3.0, 6.0, 0, _passbyTitle, gpbrainTitle2, 0
dd 9.0, 1.0, 1.0, _passbyTitle, gpbrainTitle3, EVENTF_FADEOUT | EVENTF_REV
dd 10.5, 1.0, 1.0, _passbyTitle, gpbrainTitle4, EVENTF_FADEOUT
dd 11.5, 4.0, 0, _passbyTitle, gpbrainTitle5, 0
dd 15.5, 1.0, 1.0, _passbyTitle, gpbrainTitle6, EVENTF_FADEOUT | EVENTF_REV

gpbrainTitle1:
dd 0.0,0.5,0, 100.0, 0,0,0, sMsg1, brainFont
gpbrainTitle2:
dd 0.0,0.5,0, 0.0, 0,0,0, sMsg1, brainFont
gpbrainTitle3:
dd 0.0,0.5,0, -100.0, 0,0,0, sMsg1, brainFont
gpbrainTitle4:
dd 0.0,0.5,0, 100.0, 0,0,0, sMsg2, brainFont
gpbrainTitle5:
dd 0.0,0.5,0, 0.0, 0,0,0, sMsg2, brainFont
gpbrainTitle6:
dd 0.0,0.5,0, -100.0, 0,0,0, sMsg2, brainFont
DEFSTRX sMsg1, s,o,f,t,w,a,r,e
DEFSTRX sMsg2, a,s,s,e,m,b,l,e,r
;DEFSTRX sMsg1, m,a,r,t,i,n
;DEFSTRX sMsg2, v,e,i,l,l,e,u,x

gshear1: dd -1.0,0,0, 0,1.6,0, 4.0,0.5
gshear2: dd -1.0,0,0, 0,1.0,0, 0.5,0.5
;==============================================================================
section .bss
;==============================================================================
brainCam: resb camera_size
brainCube: resb vbuffer_size
shatterDist: resd 1
shatterAlpha2: resd 1
brainMatColor: resb rgbaUP_size
;==============================================================================
section .text
;==============================================================================
SDECL   _initBrain, 0
;==============================================================================
    CameraInit brainCam, [myscene +scene.fb +tex.w],[myscene +scene.fb +tex.h]
    CCALL   _setCamFOV, brainCam, [brainCamFov]
    CCALL   _MCUBE_precomp, brainFieldinfo, brainCube
    CCALL   _initShatterVec, brainCube
    
    CCALL   _setBrainCam, [brainCamPolar],[brainCamPolar +4],[brainCamDist],brainCamPos
    
    CCALL   _offsetEventAll, brainEvents, [brainEventTotal], [brainStartOffset]
    CCALL   _offsetEventAll, pbTitleBrain, [pbTitleBrainTotal], [brainStartOffset]
.exit:
DECLEND
;==============================================================================
SDECL   _updateBrain, 0
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade, _data, _flags
    LVAR    4, result
    
    fld     dword[%$_ratio]
    fmul    dword[brainCamPolar +8]
    fadd    dword[brainCamPolar +4]
    fstp    dword[%$result]
    mov     eax,dword[%$result]
    CCALL   _setBrainCam, [brainCamPolar],eax,[brainCamDist],brainCamPos
.exit:
DECLEND
;==============================================================================
SDECL   _setBrainCam, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _ax, _ay, _dz, _vp
    LVAR    vec4_size, qr
    LVAR    matrix_size, rmat
    LENTER
    fldpi
    fmul    dword[Real1d2]
    fmul    dword[%$_ax]
    fstp    dword[%$_ax]
    fldpi
    fadd    st0
    fmul    dword[%$_ay]
    fstp    dword[%$_ay]
    lea     eax,[%$qr]
    QuatFromPolar eax,[%$_ax],[%$_ay]
    lea     eax,[%$qr]
    lea     edx,[%$rmat]
    Quat2m33 edx, eax
    
    fld     dword[%$rmat +matrix.n +vec3.x]
    fmul    dword[%$_dz]
    fld     dword[%$rmat +matrix.n +vec3.y]
    fmul    dword[%$_dz]
    fld     dword[%$rmat +matrix.n +vec3.z]
    fmul    dword[%$_dz]
    mov     edx,dword[%$_vp]
    fxch    st2
    fsubr   dword[edx +vec3.x]
    fld     dword[edx +vec3.y]
    fsubrp  st2
    fld     dword[edx +vec3.z]
    fsubrp  st3
    fstp    dword[RTmatrix +matrix.t +vec3.x]
    fstp    dword[RTmatrix +matrix.t +vec3.y]
    fstp    dword[RTmatrix +matrix.t +vec3.z]
    lea     eax,[%$rmat]
    M33transpose RTmatrix, eax
    
    CameraSetPos brainCam, RTmatrix +matrix.t
    CameraSetRot brainCam, RTmatrix
    CameraUpdate brainCam
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL   _initShatterVec, 0
;==============================================================================
    MPUSH   ecx,edi,ebp
    LCTX    ebp
    LARG    4, _vbuf
    LVAR    4, seed
    LENTER
    
    mov     edi,dword[%$_vbuf]
    mov     eax,dword[edi +vbuffer.count]
    mov     ecx,3
    xor     edx,edx
    div     ecx
    test    eax,eax
    jz      .exit
    mov     ecx,eax
    mov     edi,dword[edi +vbuffer.data]
    mov     dword[%$seed],0xbeefee
align 4
.iterTri:
    lea     eax,[%$seed]
    CCALL   _getRandMat,eax
    V3eq    edi +vertex.c, RTmatrix +matrix.n
;next
    add     edi,vertex_size *3
    dec     ecx
    jnz     .iterTri
.exit:
    LEXIT
    MPOP    ecx,edi,ebp
DECLEND
;==============================================================================
SDECL   _resetShear, 0
;==============================================================================
    V3setNull   OBJ_tform +objtform.sdir
    V3setNull   OBJ_tform +objtform.spos
    ObjSetFlags 0,0,0
DECLEND
;==============================================================================
SDECL   _renderBrain, 0
;==============================================================================
    TexClear    myscene +scene.fb, U32
    TexClear    myscene +scene.zb
    RasSetCam   brainCam

    RasSetCulling CULLING_BACK
    RasSetFpgm _FPGM_RGB_Z
    RasSetVpgm _VPGM_RGB
    CCALL   _resetShear
    CCALL   _loopEventAll, brainEvents, [brainEventTotal]
.exit:
DECLEND
;==============================================================================
SDECL _shatterCube
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade, _data, _flags
    
    mov     edx,dword[%$_data]
    CCALL   _setBrainLightColor, [edx +shcube.c]
    mov     edx,dword[%$_data]
    fld1
    fsub    dword[%$_fade]
    fmul    dword[greal256]
    fstp    dword[shatterAlpha2]
    fld     dword[edx +shcube.dist]
    fmul    dword[%$_ratio]
    fstp    dword[shatterDist]
    
    V3smul  brainMatColor, brainMatColor, %$_fade

    ObjSetVpgm _VPGM_shatter
    V3eq    OBJ_tform +objtform.rm +matrix.t, edx
    CCALL   _getTimeMat, OBJ_tform +objtform.rm, [edx +shcube.ax],[edx +shcube.ay],[beatTimer +timer.sec]
    CCALL   _OBJ_renderTri, brainCube
.exit:
DECLEND
;==============================================================================
SDECL _animShear, 0
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade, _data, _flags
    LVAR    4, result
    
    mov     edx,dword[%$_data]
    V3eq    OBJ_tform +objtform.spos, edx +fshear.pos
    V3eq    RTmatrix, edx +fshear.dir
    V3norm  RTmatrix
    
    mov     edx,dword[%$_data]
    fldpi
    fadd    st0
    fmul    dword[%$_ratio]
    fmul    dword[edx +fshear.freq]
    fsin
    fld1
    fsub    dword[%$_ratio]
    fmul    dword[edx +fshear.ampl]
    fmulp   st1
    fstp    dword[%$result]
    V3smul  OBJ_tform +objtform.sdir, RTmatrix, %$result
    ObjSetFlags 0,0,OBJF_SHEAR
.exit:
DECLEND
;==============================================================================
SDECL _animShear2, 0
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade, _data, _flags
    LVAR    4, result
    
    mov     edx,dword[%$_data]
    V3eq    OBJ_tform +objtform.spos, edx +fshear.pos
    V3eq    RTmatrix, edx +fshear.dir
    V3norm  RTmatrix
    fld1
    fadd    st0
    fstp    dword[RND_nparam +noise.gain]
    fld     dword[Real1d2]
    fst     dword[RND_nparam +noise.x]
    fst     dword[RND_nparam +noise.y]
    fstp    dword[RND_nparam +noise.pers]
    mov     dword[RND_nparam +noise.iter],4
    fld     dword[RTM_time]
    fadd    st0
    fadd    st0
    fstp    dword[RND_nparam +noise.z]
    CCALL   _RND_perlin3D
    
    mov     edx,dword[%$_data]
    fmul    dword[edx +fshear.freq]
    fmul    dword[%$_fade]
    fld     dword[edx +fshear.ampl]
    fmul    dword[%$_fade]
    faddp   st1
    fstp    dword[%$result]
    V3smul  OBJ_tform +objtform.sdir, RTmatrix, %$result
    ObjSetFlags 0,0,OBJF_SHEAR
.exit:
DECLEND
;==============================================================================
SDECL _animBrainCube
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade, _data, _flags
    
    mov     edx,dword[%$_data]
    CCALL   _setBrainLightColor, [edx +shcube.c]
    mov     edx,dword[%$_data]
    fldz
    fst     dword[shatterAlpha2]
    fstp    dword[shatterDist]

    ObjSetVpgm _VPGM_shatter
    V3eq    OBJ_tform +objtform.rm +matrix.t, edx
    CCALL   _getTimeMat, OBJ_tform +objtform.rm, [edx +shcube.ax],[edx +shcube.ay],[beatTimer +timer.sec]
    CCALL   _OBJ_renderTri, brainCube
.exit:
DECLEND
;==============================================================================
SDECL _animBrainFont, 0
;==============================================================================
    ObjSetVpgm _VPGM_brainfont
    CCALL   _resetShear
    CCALL   _setBrainLightColor, PACKB2DW(0,255,192,128)
    CCALL   _loopEventAll, pbTitleBrain, [pbTitleBrainTotal]
.exit:
DECLEND
;==============================================================================
SDECL _setBrainLightColor, 0
;==============================================================================
    LCTX    esp
    LARG    4, _color
    rgbaUnpack  brainMatColor, [%$_color]
.exit:
DECLEND
;==============================================================================
SDECL _VPGM_brainfont
;==============================================================================
    MPUSH   edi
    LCTX    esp
    LARG    4, _pvert

    mov     edi,dword[%$_pvert]
    V4eq    edi +vertex.c, brainMatColor
    
    lea     eax,[edi +vertex.nx]
    lea     edx,[edi +vertex.c]
    CCALL   _LIGHT_apply, edx, edi, eax, brainlights, 2
.exit:
    MPOP    edi
DECLEND
;==============================================================================
SDECL _VPGM_shatter
;==============================================================================
    LCTX    esp
    LARG    4, _outV, _inV

    mov     edi,dword[%$_outV]
    mov     esi,dword[%$_inV]
    mov     ecx,vertex_size *2
.iter3x:
.shearTransform:
    lea     eax,[esi +ecx +vertex.x]
    lea     edx,[edi +ecx +vertex.x]
    M33mulV3 edx,OBJ_tform +objtform.rm, eax
    lea     edx,[edi +ecx +vertex.x]
    V3shear     edx,OBJ_tform +objtform.sdir, OBJ_tform +objtform.spos
    V3add       edi +ecx,edi +ecx,OBJ_tform +objtform.rm +matrix.t
.endTransform:
    lea     eax,[esi +ecx +vertex.nx]
    lea     edx,[edi +ecx +vertex.nx]
    M33mulV3 edx,OBJ_tform +objtform.rm, eax
;shatter dir was precomp and stored in color comp
    fld     dword[esi +vertex.c +vec3.x]
    fmul    dword[shatterDist]
    fld     dword[esi +vertex.c +vec3.y]
    fmul    dword[shatterDist]
    fld     dword[esi +vertex.c +vec3.z]
    fmul    dword[shatterDist]
    fxch    st2
    fadd    dword[edi +ecx +vertex.x]
    fld     dword[edi +ecx +vertex.y]
    faddp   st2
    fld     dword[edi +ecx +vertex.z]
    faddp   st3
    fstp    dword[edi +ecx +vertex.x]
    fstp    dword[edi +ecx +vertex.y]
    fstp    dword[edi +ecx +vertex.z]

;shade
    V4eq    edi +ecx +vertex.c, brainMatColor
    
    lea     eax,[edi +ecx +vertex.x]
    lea     ebx,[edi +ecx +vertex.nx]
    lea     edx,[edi +ecx +vertex.c]
    CCALL   _LIGHT_apply, edx, eax, ebx, brainlights, 2
    
    fld     dword[edi +ecx +vertex.c +rgbaUP.b]
    fadd    dword[shatterAlpha2]
    fld     dword[edi +ecx +vertex.c +rgbaUP.g]
    fadd    dword[shatterAlpha2]
    fld     dword[edi +ecx +vertex.c +rgbaUP.r]
    fadd    dword[shatterAlpha2]
    fxch    st2
    fstp    dword[edi +ecx +vertex.c +rgbaUP.b]
    fstp    dword[edi +ecx +vertex.c +rgbaUP.g]
    fstp    dword[edi +ecx +vertex.c +rgbaUP.r]
;next
    sub     ecx,vertex_size
    jns     .iter3x
    
.exit:
DECLEND
;==============================================================================
