//
// dont change unless you know what u doing!
//

float4x4 		World	: WORLD;
float4x4 		View	: VIEW;
float4x4 		Proj	: PROJECTION;

float4x4		WVP;			// world * view * projection matrix

float			fR;
float			fG;
float			fB;
float			fA;

float			fTime;
float			fBassValue;
float			fPitchValue;

float4			eyeVec;			// camera eye


// Simpleapp output
struct SIMPLE_APP_OUTPUT
{
	float3 position	: POSITION;
	float3 normal	: NORMAL;
	float2 texcoord0: TEXCOORD0;
};

struct SIMPLE_VS_OUTPUT
{
	float4 position		: POSITION;   // vertex position 
	float2 texcoord0	: TEXCOORD0;  // uv maps
};


// Pixel shader output structure
struct PS_OUTPUT
{
    float4 color : COLOR0;  // Pixel color    
};


texture g_BaseTexture;
sampler2D BaseTextureSampler : TEXUNIT0 = sampler_state
 {
       Texture = (g_BaseTexture);
       MIPFILTER = LINEAR;
       MAGFILTER = LINEAR;
       MINFILTER = LINEAR;
		AddressU = Wrap;
		AddressV = Wrap;
 };


SIMPLE_VS_OUTPUT SimpleVS( SIMPLE_APP_OUTPUT IN ) 
{ 
	SIMPLE_VS_OUTPUT Output;

	// transform position to clip space 
	Output.position = mul( float4(IN.position, 1.0), WVP );
	Output.texcoord0 = IN.texcoord0;
	
	return Output;
}


PS_OUTPUT SimplePS( SIMPLE_VS_OUTPUT IN ) 
{ 
	PS_OUTPUT Output;

	float4 diffuse = tex2D( BaseTextureSampler, IN.texcoord0 );

	// best color combination
	// 1st
	// R = x
	// G = B = y
	//
	// 2nd
	// R = G = x
	// B = y
	
	diffuse.r *= 1 - (1.125 * IN.texcoord0.x);//fR;
	diffuse.g *= 1 - (1.125 * IN.texcoord0.y);//fG;
	diffuse.b *= 1 - (1.125 * IN.texcoord0.y);//1.0-(fB*2)*sin(fTime*0.025) + fBassValue;
	diffuse.a = fA * 3;

	Output.color = diffuse;
	
	return Output;
}


PS_OUTPUT ScreenMaskPS( SIMPLE_VS_OUTPUT IN ) 
{ 
	PS_OUTPUT Output;

	float4 diffuse = tex2D( BaseTextureSampler, IN.texcoord0 );
	Output.color = diffuse;
	
	return Output;
}



//-----------------------------------------------------------------------------
// Simple Effect (1 technique with 1 pass)
//-----------------------------------------------------------------------------


technique RenderMask
{
    pass P0
    {
		Lighting	= False;
		CullMode	= None;
		ZEnable		= FALSE;
		ZWriteEnable= FALSE;

		AlphaBlendEnable= TRUE;
		SrcBlend	= SRCALPHA;
		DestBlend	= INVSRCALPHA;
		
		VertexShader = compile vs_1_1 SimpleVS( );
		PixelShader  = compile ps_2_0 ScreenMaskPS( );
    }
}


technique RenderTunnel
{
    pass P0
    {
		Lighting	= False;
		CullMode	= None;
		ZEnable		= FALSE;
		ZWriteEnable	= FALSE;

		AlphaBlendEnable= TRUE;
		SrcBlend	= SRCALPHA;
		DestBlend	= ONE;
		
		VertexShader = compile vs_1_1 SimpleVS( );
		PixelShader  = compile ps_2_0 SimplePS( );
    }
}