struct PS_INPUT
{
  float2 Tex0: TEXCOORD0;
};

float V_Alpha : ALPHA;

sampler texHeat = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float4 PS(PS_INPUT In) : COLOR0
{
  float4 color = tex2D(texHeat, In.Tex0);
  float  dist;
  float4 colorA;
  float4 colorB;
  if (color.r < 0.25)
  {
    dist   = color.r / 0.25;
    colorA = float4(0.5,0.5,1,V_Alpha);
    colorB = float4(0,0,1,V_Alpha);
  }
  else if (color.r < 0.35)
  {
    dist   = (color.r-0.25) / 0.10;
    colorA = float4(0,0,1,V_Alpha);
    colorB = float4(1,1,0,V_Alpha);
  }
  else
  {
    dist   = (color.r-0.35) / 0.65;
    colorA = float4(1,1,0,V_Alpha);
    colorB = float4(1,0,0,V_Alpha);
  }
  return lerp(colorA, colorB, dist);
}

technique HeatPass2
{
  pass HeatPass2
  {
    PixelShader = compile ps_2_0 PS();
  }
}
