struct PS_INPUT
{
  float2 Tex0: TEXCOORD0;
};

sampler tex = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

sampler texAnt = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

sampler texHeatAnt = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float4 PS(PS_INPUT In) : COLOR0
{
  float4 color    = tex2D(tex,    In.Tex0);
  float4 colorAnt = tex2D(texAnt, In.Tex0);
  
  float dist = (abs(color.r-colorAnt.r) + abs(color.g-colorAnt.g) + abs(color.b-colorAnt.b)) / 2;
  float4 colorHeatAnt = tex2D(texHeatAnt, In.Tex0);
  float4 colorHeat    = 0;
  colorHeat.r = colorHeatAnt.r - 0.03 + dist;
  clamp(colorHeat.r, 0, 1);
  return colorHeat;
}

technique HeatPass1
{
  pass HeatPass
  {
    PixelShader = compile ps_1_4 PS();
  }
}
