//-----------------------------------------------------------------------------
// Title : Simple Blur
// Author: Pieter Germishuys
//-----------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
float offset; //offset for the blur

//--------------------------------------------------------------------------------------
// Textures and Samplers
//--------------------------------------------------------------------------------------
texture texture0;
sampler2D texSampler0 : TEXUNIT0 = sampler_state
{
	Texture	  = (texture0);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};
 
//--------------------------------------------------------------------------------------
// Structures
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Vertex Shader to Pixel Shader
//--------------------------------------------------------------------------------------
struct v2p
{
    float4 position	   : POSITION0;
    float2 tex0        : TEXCOORD0;
};
 
//--------------------------------------------------------------------------------------
// Result of the Pixel Shader
//--------------------------------------------------------------------------------------
struct p2f
{
    float4 color    : COLOR0;
};
 
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
void PixelShader( in v2p IN, out p2f OUT )
{
	//Calculate the offsets
	float2 Offset;
	Offset.x = offset / float(256);
	Offset.y = offset / float(256);
	//Create the blur
	//By extracting pixels from the texture we can shift them as we extract them.
	float4 top = tex2D(texSampler0, float2(IN.tex0.x, IN.tex0.y + Offset.y));
	float4 top_left = tex2D(texSampler0, float2(IN.tex0.x - Offset.x, IN.tex0.y + Offset.y));
	float4 top_right = tex2D(texSampler0, float2(IN.tex0.x + Offset.x, IN.tex0.y + Offset.y));
	float4 bottom = tex2D(texSampler0, float2(IN.tex0.x, IN.tex0.y - Offset.y));
	float4 bottom_left = tex2D(texSampler0, float2(IN.tex0.x - Offset.x, IN.tex0.y - Offset.y));
	float4 bottom_right = tex2D(texSampler0, float2(IN.tex0.x + Offset.x, IN.tex0.y + Offset.y));
	float4 left = tex2D(texSampler0, float2(IN.tex0.x - Offset.x, IN.tex0.y));
	float4 right = tex2D(texSampler0, float2(IN.tex0.x - Offset.x, IN.tex0.y));
	
	//Extract the color from the texture
	float4 average = (top + bottom + right + left + top_left + top_right + bottom_left + bottom_right) / 8;
	//Color output
	OUT.color = average;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------
technique blur
{
    pass p0
    {
        pixelshader = compile ps_2_0 PixelShader();
    }
}