// El pedazo robo' pa' la euskal 14
//
// Esqueleto tomado de los bots de ejemplo de la versin 1.0.8
//
// 

// Prototipos 
// NOTA: se usa iostream en vez de iostream.h
#include <iostream>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

// Include de los defines 
#include "Messagetypes.h"

// Funciones utiles de calculo por macros
#define abs(x) ((x>0) ? (x) : -(x))
#define sgn(x) ((x>0) ? 1 : -1)
#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))

// Variables globales de control de status
volatile double acceleration = 0.0;
volatile double robot_rotate = 0.0;
volatile double cannon_rotate = 0.0, radar_rotate = 0.0;
double tid=0.0, radar_angle=0.0, prev_radar_angle, cannon_angle, tid0, slumprotate = 1.0 ;
double maxspeed =3.0, robotmaxrotate, cannonmaxrotate, radarmaxrotate, dist=0.0, prev_dist;
double robotstartenergy, robotmaxenergy, robotenergylevels, shotspeed, shotmaxenergy;
double  shotminenergy, shotenergyincreasespeed,timeout, rotend=0.0, broms=0.0;
double prev_speed, speed=0.0, prev_tid, energy, sweepleft, sweepright, prev_energy;
int robots_left = 20, rotating, enemy = 0, cookie = 0, flee = 0, wallcoll=0;
bool sweep = false, align_cro= true, align_cra = true;

// Variable global booleana de condicion de salida
volatile sig_atomic_t exit_robot = false;

// Calculo de las ltimas posiciones detectadas del enemigo, en angulo de radianes
double ultimasposiciones[3];
// Numero de ultimas posiciones detectadas
int nultimasposiciones;

// Factor de correccion para adivinacion de trayectoria
double factor_corrector;
double factor_corrector_busqueda;

// Ultimo momento en el que el enemigo es detectado
double old_tid=0;
// Ultimo momento en el que el enemigo es disparado
double old_tid_shoot=0;

// Definiciones de la IO
using std::endl;
using std::cin;
using std::cout;

// Reinicia las condiciones del entorno y borra los historicos
void InitEnvironment(void){
	old_tid=0;
	old_tid_shoot=0;
	nultimasposiciones=0;
	factor_corrector=50;
	factor_corrector_busqueda=50;
}

// Decodifica los eventos mandados al robot
message_to_robot_type
name2msg_to_robot_type(char* msg_name)
{
  for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
      if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
        return (message_to_robot_type)i;
    }
  return UNKNOWN_MESSAGE_TO_ROBOT;
}

// Callback de atencion a eventos
void
check_messages(int sig)
{
  // Robot en funcionamiento
  exit_robot = false;

  char msg_name[81];
  char text[81];
  message_to_robot_type msg_t;

  cin.clear();
  while( !cin.eof() )
    {
   	std::cin >> msg_name;
      msg_t = name2msg_to_robot_type(msg_name);
      switch(msg_t)
        {
        // Rutina de inicializacion para el primer combate
	case INITIALIZE:
          int init;
          cin >> init ;
          if (init == 1)
            {
              cout << "Name Vassili" << endl;
              cout << "Colour 9000FF" << endl;
            }
	    InitEnvironment();
          break;
	
	// Rutina que se llama en CADA combate  
        case GAME_STARTS:
	   InitEnvironment();
	   cout << "Rotate 6 " << -10 << endl;
          
	  // Sutilmente me voy hacia la pared
          acceleration = -0.1;
          cout << "Accelerate " << acceleration << endl;
          break;
        
	// Rutina de fin del juego
	case GAME_FINISHES:
          break;

	// Rutina de recuperacion de variables de entorno
        case GAME_OPTION:
          int optnr;
          double value;
          cin >> optnr >> value ;
          switch(optnr)
            {
            case ROBOT_MAX_ROTATE:
              robotmaxrotate = value;
              break;
            case ROBOT_CANNON_MAX_ROTATE:
              cannonmaxrotate = value;
              break;
            case ROBOT_RADAR_MAX_ROTATE:
              radarmaxrotate = value ;
              break;
            case ROBOT_START_ENERGY:
              robotstartenergy = value;
              break;
            case ROBOT_MAX_ENERGY:
              robotmaxenergy = value;
              break;
            case ROBOT_ENERGY_LEVELS:
              robotenergylevels = value;
              break;
            case SHOT_SPEED:
              shotspeed = value;
              break;
            case SHOT_MIN_ENERGY:
              shotminenergy = value;
              break;
            case SHOT_MAX_ENERGY:
              shotmaxenergy = value;
              break;
            case SHOT_ENERGY_INCREASE_SPEED:
              shotenergyincreasespeed = value;
              break;
            case TIMEOUT:
              timeout = value;
              break;
            }
          break;
/**        case SAVE_DATA:
          cout << "SaveDataFinished" << endl;
          break;
*/
	// Recuperacion infomracion velocidad y tiempo
        case INFO:
          prev_speed = speed;
          prev_tid = tid;
          cin >> tid >> speed  >> cannon_angle;
          break;

	// Recuperacion informacion energia
        case ENERGY:
          prev_energy=energy;
          cin >> energy;
          break;
        
	// Recuperacion informacion de robots restantes
        case ROBOTS_LEFT:
          cin >> robots_left;
          break;

	// Rutina de atencion al radar
        case RADAR:
          {
            double x1,x2,s,rot;
            int object;

            prev_dist = dist;
            prev_radar_angle = radar_angle;
            cin >> dist >> object >> radar_angle;
		// Sino le veo mucho le busco!
		if ((tid - old_tid)>2) {
			// Mnnn no seria mejor girar hacia donde se va?
			// Lo pruebo aver..
			if (factor_corrector_busqueda) cout << "Rotate 6 " << 80 << endl;
			else cout << "Rotate 6 " << -80 << endl;
		}
            switch(object)
              {
              case ROBOT:
			// Si el robot esta lejos...
			if (dist >3){
				// ... y ha pasado mas de 1u de tiempo...
				if (tid-old_tid_shoot>1) {
					// ... y sino se menea demasiado (contando angulo y distancia)...
					if (abs(ultimasposiciones[0]-ultimasposiciones[1])<1/dist){
						cout << "Shoot 50" <<endl; 
						old_tid_shoot=tid;
					}
				}
			// pero si el robot esta cerca...
			}else{
				cout <<"Shoot 10" <<endl;
			}
			
			// Roto las posiciones
			ultimasposiciones[1]=ultimasposiciones[0];
			ultimasposiciones[2]=ultimasposiciones[1];
			ultimasposiciones[0]=radar_angle;
			
			//Incremento el numero de colisiones vistas
			if (nultimasposiciones<3) nultimasposiciones++;
			
			// Calculo el factor de corrector de busqueda en base al ultimo movimiento
			if (nultimasposiciones>1) factor_corrector_busqueda=(ultimasposiciones[0]-ultimasposiciones[1]);
			
			// Calculo el factor de corrector en base al ultimo movimiento SOLO SI lo he visto hace poco y hay info historica
			if (tid-old_tid<8 &&nultimasposiciones>1) factor_corrector=(ultimasposiciones[0]-ultimasposiciones[1]);
			else factor_corrector=0;
			
			// Por si acaso hay overflow en el factor corrector...
			if (factor_corrector>3) factor_corrector=0;
			
			//cout << "Debug FC " <<factor_corrector<<" angulo actual " << radar_angle <<endl; 
			// POngo el nuevo sweep
			cout << "Sweep 6 " << cannonmaxrotate << " " << radar_angle-M_PI/8.0 +(factor_corrector*1)<< " " << radar_angle+M_PI/8.0 +(factor_corrector*1) << endl;
			
			// Actulizo ultimo momento de visto robot
			old_tid=tid;				
			break;
              case WALL:

			// Si veo pared y voy rapido, freno. Normalizo velocidad 
			if (speed>1) cout<<"Accelerate 0" <<endl;
			else cout<<"Accelerate -0.1" <<endl;
			break;
              case SHOT:
                break;
              case COOKIE:
		// Rutina para la busqueda de cookie. 
                cookie = 7;
                broms = 1.0;
                robot_rotate = 0.0;
                sweepleft=radar_angle-M_PI/20.0;
                sweepright=radar_angle+M_PI/20.0;
                if (speed<maxspeed)
                  acceleration = 2.0;
                else
                  acceleration = 0.0;

                radar_angle = asin(sin(radar_angle));
                cout << "RotateAmount 1 " << robotmaxrotate << " " << radar_angle << endl;
                cout << "Accelerate " << acceleration << endl;
                cout << "RotateAmount 6 " << robotmaxrotate << " " << -radar_angle << endl;
                cout << "Brake " << broms << endl;
		
			   InitEnvironment();
		
                break;

              case MINE:
     
                break;
              }
          break;
          }

        case COLLISION:
          {
            int tmp;
            double coll_angle;
            cin >> tmp >> coll_angle;
            switch(tmp)
              {
              case ROBOT: 
                enemy=0;
                break;
              case SHOT:
			cout << "Accelerate " << 1 << endl;
                break;
              case MINE: 
                break;
              case COOKIE: 
                cookie = 0;
                break;
              case WALL:
                wallcoll=10;
                break;
              }

          }
          break;
        case WARNING:
          break;
        case EXIT_ROBOT:
          cout << "Print Shutting down and leaving" << endl;
          exit_robot = true;
          break;
        default:
          break;
        }
    }
  signal (sig, check_messages);
}

int 
main(int argc, char * argv[])
{
  signal(SIGUSR1, check_messages);

  cout << "RobotOption " << SEND_SIGNAL << " " << true << endl;

  for(;;sleep(1))
    {
      if( exit_robot ) 
        {
          //          cerr << "Fire: Exiting normally!" << endl;
          return(EXIT_SUCCESS);
        }
    }
  return(EXIT_SUCCESS);
}

