#ifndef SAMSA_H
#define SAMSA_H

#define ROBOT_NAME		"Samsa"
#define COLOUR_PRIMARY		"0xffffff"
#define COLOUR_SECONDARY	"0xb0b0b0"
#define MAX_RAGE		5.0
#define	BUSCA_SWEEP		M_PI/30.0
#define BUSCA_MAX_FALLOS	20
#define EVASIO_TEMPS		0.9
#define	EVASIO_BRAKE		EVASIO_TEMPS+0.5

struct t_options {
        double  robot_max_rotate;
        double  robot_cannon_max_rotate;
        double  robot_radar_max_rotate;

        double  robot_max_acceleration;
        double  robot_min_acceleration;

        double  robot_start_energy;
        double  robot_max_energy;
        double  robot_energy_levels;

        double  shot_speed;
        double  shot_min_energy;
	double	shot_max_energy;

        double  robot_energy_increase_speed;
        double  timeout;
        double  debug_level;
        double  send_robot_coordinates;
};

struct t_robot {
	double	energia;
	double	energia_oponent;
	
	double	tick;
	double	temps;
	double	velocitat;
	double	angle;

	double	pos_radi;
	double	pos_angle;

	int	posicionat;
	int	estat;
	int	finalitzar;

	// ATACK
	double	busca_distancia;
	double	busca_angle;
	int	busca_rotacio;
	int	busca_fallos;

	double	rage;
};

struct t_ordre {
	double	temps;
	int	tipo;
	double	valor;	
};

enum	ordres {
	ORDRE_ESCANEJA,
	ORDRE_MOU,
	ORDRE_PARA,
	ORDRE_FRENA,
	ORDRE_DESFRENA
};

enum	estat {
	ESTAT_PARAT,
	ESTAT_ESCANEJANT,
	ESTAT_AGAFA_COOKIE,
	ESTAT_ATACANT,
	ESTAT_SEGUEIX_ROBOT,
	ESTAT_EVASIO
};

// Funcions
void insertar_ordre( struct t_ordre *nova );
#endif
