/*
 *	Robot Samsa.
 *
 *	Horror no fa res!!
 *
 */

// INCLUDES
//
#include <iostream>
#include <string>
#include <list>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <time.h>
#include <sstream>
#include <math.h>
#include "Messagetypes.h"
#include "actua.h"
#include "processa.h"
#include "samsa.h"

using namespace std;

struct t_options	options;
struct t_robot		robot;
list <struct t_ordre>	ordres;

message_to_robot_type AgafaTipusMissatge( string nom)
{
        for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
        {
                if( strcmp(message_to_robot[i].msg, nom.c_str() ) == 0 )
                        return (message_to_robot_type)i;
        }
        return UNKNOWN_MESSAGE_TO_ROBOT;
}

void BucleMissatges(int sig)
{
	string			linea;
	message_to_robot_type	t_tipus;	
	

	cin.clear();
	while( !cin.eof() )
	{
		int		i;
		stringstream	strm;
		string		ordre;
		
		if( !getline(cin,linea) )
			break;
		
		// Gitano code
		for( i=0; i<linea.size(); i++ )
			if( linea[i] == ',' )
				linea[i] =  '.';

		strm << linea;
		strm >> ordre;
		
		t_tipus = AgafaTipusMissatge( ordre );
		
		switch( t_tipus )
		{
			case INITIALIZE:
				ProcessaInitialize(strm);
				break;
			case YOUR_NAME:
				ProcessaYourName(strm);
				break;
			case YOUR_COLOUR:
				ProcessaYourColour(strm);
				break;
			case GAME_OPTION:
				ProcessaGameOption(strm);
				break;
			case GAME_STARTS:
				ProcessaGameStarts(strm);
				break;
			case RADAR:
				ProcessaRadar(strm);
				break;
			case INFO:
				ProcessaInfo(strm);
				break;
			case COORDINATES:
				ProcessaCoordinates(strm);
				break;
			case ROBOT_INFO:
				ProcessaRobotInfo(strm);
				break;
			case ROTATION_REACHED:
				ProcessaRotationReached(strm);
				break;
			case ENERGY:
				ProcessaEnergy(strm);
				break;
			case ROBOTS_LEFT:
				ProcessaRobotsLeft(strm);
				break;
			case COLLISION:
				ProcessaCollision(strm);
				break;
			case WARNING:
				ProcessaWarning(strm);
				break;
			case DEAD:
				ProcessaDead(strm);
				break;
			case GAME_FINISHES:
				ProcessaGameFinishes(strm);
				break;
        		case EXIT_ROBOT:
				ProcessaExitRobot(strm);
				break;
        		default:
				DoPrint("Missatge desconegut!");
        	}
	}
	signal (sig, BucleMissatges);
}


typedef	list<struct t_ordre>::iterator t_it;

void insertar_ordre( struct t_ordre *nova )
{
	t_it	it;
	int	i;

	for( i=0, it=ordres.begin(); it != ordres.end(); it++, i++ )
	{
		if( it->temps > nova->temps )
		{
			ordres.insert( it, *nova );
			return;
		}
	}
	ordres.push_back( *nova );
}



int main(int argc, char **argv)
{	
	sigset_t usr1set;

	signal(SIGUSR1, BucleMissatges);

	// libpthread seems to block USR1 sometimes for some reason
	sigemptyset(&usr1set);
	sigaddset(&usr1set, SIGUSR1);
	sigprocmask(SIG_UNBLOCK, &usr1set, NULL);


	DoOption( USE_NON_BLOCKING, 1 );
	DoOption( SEND_SIGNAL, 1 );
	DoOption( SEND_ROTATION_REACHED, 1 );

	DoPrint( " [i] El hackit me ha dejado incompleto :'(" );


	for(;;)
	{
		sleep(1);
      		if( robot.finalitzar ) 
        	{
			return(EXIT_SUCCESS);
        	}
    	}
	return(EXIT_SUCCESS);
}


