/*
 *	processa.cpp
 *
 * 	Funcions de processat de missatges.
 *
 */

// INCLUDES
///
#include <iostream>
#include <string>
#include <list>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <sstream>
#include "Messagetypes.h"
#include "samsa.h"
#include "actua.h"
#include "processa.h"

using namespace std;

extern	struct t_options	options;
extern	struct t_robot		robot;
extern	list<struct t_ordre>	ordres;

void PrintTime()
{
	cout << "Print TIME [" << robot.temps << "]" << endl;
}

// DONE
void ProcessaInitialize(stringstream &strm)
{
	int first;

	strm >> first;
	if( first )
	{
		DoName( ROBOT_NAME );
		DoColour( COLOUR_PRIMARY, COLOUR_SECONDARY );
	}
}

// DONE - JUNK
void ProcessaYourName(stringstream &strm)
{
	string nom;
	
	strm >> nom;
}

// DONE - JUNK
void ProcessaYourColour(stringstream &strm)
{
	string color;

	strm >> color;
}

// TO DO.
void ProcessaGameStarts(stringstream &strm)
{
	// INICIALITZACI
	memset( &robot, 0, sizeof( struct t_robot ) );
	ordres.clear();
	robot.estat = ESTAT_PARAT;
}

// DONE - AGAFA OPCIONS
void ProcessaGameOption(stringstream &strm)
{
	int	tipus;
	double	valor;

	string strout;

	strm >> tipus;
	strm >> valor;

	switch(tipus)
	{
		case ROBOT_MAX_ROTATE:
			options.robot_max_rotate = valor;
			break;
		case ROBOT_CANNON_MAX_ROTATE:
			options.robot_cannon_max_rotate = valor;
			break;
		case ROBOT_RADAR_MAX_ROTATE:
			// CHANGE!
			options.robot_radar_max_rotate = valor;
			break;
		case ROBOT_START_ENERGY:
			options.robot_start_energy = valor;
			break;
		case ROBOT_MAX_ACCELERATION:
			options.robot_max_acceleration = valor;
			break;
		case ROBOT_MIN_ACCELERATION:
			options.robot_min_acceleration = valor;
			break;
		case SHOT_MIN_ENERGY:
			options.shot_min_energy = valor;
			break;
		case SHOT_MAX_ENERGY:
			options.shot_max_energy = valor;
			break;
		case ROBOT_MAX_ENERGY:
			options.robot_max_energy = valor;
			break;
		case SHOT_SPEED:
			options.shot_speed = valor;
			break;
		case ROBOT_ENERGY_LEVELS:
			options.robot_energy_levels = valor;
			break; 
		case SHOT_ENERGY_INCREASE_SPEED:
			options.robot_energy_increase_speed = valor;
			break;
		case TIMEOUT:
			options.timeout = valor;
			break;
		case DEBUG_LEVEL:
			options.debug_level = valor;
			break;
		case SEND_ROBOT_COORDINATES:
			options.send_robot_coordinates = valor;
			break;
		default:
			DoPrint("UNKNOWN OPTION!!");
	}
}

// DONE - GUARDA EN GLOBAL [ gitano ]
void ProcessaEnergy(stringstream &strm)
{
	double nivell;

	strm >> nivell;
	robot.energia = nivell;
}

// TO DO - / Moviment recte / - Megagitano
void AfegeixMovimentFutur( double temps, double longitud )
{
	struct t_ordre	nova;
	double		t,t2;

	nova.temps = temps;
	nova.tipo  = ORDRE_MOU;
	nova.valor = options.robot_max_acceleration;
	insertar_ordre( &nova );

	for( t=robot.tick; ; t+=robot.tick )
	{
		double x;
		double a;
		double v;
		double tfreno;

		v = options.robot_max_acceleration * t;
		x = options.robot_max_acceleration * t * t / 2.0;

		a = -v/2.5;
		
		if( v > 5 )
			t2 = 4.0;
		else if( v > 4 )
			t2 = 3.7;
		else if( v > 3 )
			t2 = 3.3;
		else if( v > 2 )
			t2 = 3.0;
		else if( v > 1 )
			t2 = 1.4;
		else
			t2 = 1.0;

		x += v*t2 + a*t2*t2/2;
		if( x > longitud )
			break;
	}

	t += robot.tick; // Ens pasem un xic

	nova.temps = temps + t;
	nova.tipo  = ORDRE_FRENA;
	insertar_ordre( &nova ); 

	nova.temps = temps + t + t2 + 4.5;
	nova.tipo = ORDRE_DESFRENA;
	insertar_ordre( &nova );
	
}

// TO DO - / Estretegia de deteccio / - Megagitano
void ProcessaRadar(stringstream &strm)
{
	static int ultim_tipo = 0;
	double	distancia;
	int	tipo;
	double	angle;

	strm >> distancia >> tipo >> angle;

	if( robot.rage > 0.1)
	{
		bool 	fact=1.0;
		double	nrg;

		// CHG aria promitjari el angle
		// fact = 4.0/distancia;		
		//if( fact > 1.0 )
		//	fact = 1.0;

		if( robot.energia < 5.0 )
			nrg = 0;
		else if( robot.energia < 10.0)
			nrg = options.shot_min_energy;
		else if( robot.energia < 30.0)
			nrg = options.shot_min_energy+(options.shot_max_energy-options.shot_min_energy)/2;
		else
			nrg = options.shot_max_energy;

		DoShoot( nrg );

		robot.rage -= 0.5;
	}

	if( tipo == LAST_OBJECT_TYPE )
		tipo = ultim_tipo;

	ultim_tipo = tipo;

	for(;angle>2.0*M_PI;)
		angle = angle-2.0*M_PI;

	//if( tipo == MINE )
	//	DoShoot( options.shot_min_energy );

	if( robot.estat == ESTAT_ATACANT )
	{
		if( tipo == ROBOT )
		{
			robot.rage		= MAX_RAGE;
			robot.busca_rotacio	= 0;
			robot.busca_angle	= angle;
			robot.busca_distancia	= distancia;
			robot.busca_fallos	= 0;
			DoSweep( 2|4, options.robot_cannon_max_rotate, 
					angle - BUSCA_SWEEP,
					angle + BUSCA_SWEEP );
		}
		else
		{
			if( tipo != SHOOT )
				robot.busca_fallos++;
		}
	}

	// Gitano code!
	if( robot.estat == ESTAT_ESCANEJANT )
	{
		switch( tipo )
		{
			case	WALL:
				break;

			case 	ROBOT:
				// Gitano code
				DoPrint(" [+] ^^");

				robot.busca_fallos = 0;
				robot.busca_angle = angle;
				robot.rage = MAX_RAGE;
				robot.estat = ESTAT_ATACANT;
				
				robot.busca_distancia = distancia;
				DoSweep( 2|4, options.robot_cannon_max_rotate, 
					angle - BUSCA_SWEEP,
					angle + BUSCA_SWEEP );

				DoShoot( options.shot_min_energy );

				break;

			case	SHOT:
				break;

			case	COOKIE:
				PrintTime();
				DoPrint( " [i] Nyam!" );
				if( options.robot_max_rotate > 0 )
				{
					double abs_angle;

					// Gitano code
					if( ( 2.0*M_PI - angle ) < angle )
						angle = angle - 2.0*M_PI;
					DoRotate( 2|4, 0 );					  // Para scanner
					DoRotateAmount( 1, options.robot_max_rotate, angle );	  // Direccio robot
					DoRotateAmount( 2|4, options.robot_max_rotate, -angle );  // Scanner i atack
					if( angle>0 ) abs_angle = angle;
					else abs_angle = -angle;
					AfegeixMovimentFutur( robot.temps + abs_angle/options.robot_max_rotate, distancia);
					robot.estat = ESTAT_AGAFA_COOKIE;
				}
				break;
			default:
				break;
		}
	}
}



// TO DO - /  Actuaci cada tick / - Megagitano
void ProcessaInfo(stringstream &strm)
{
	double temps;
	double velocitat,v;
	double angle;
	static int    test = 0;
	static double vant = 1;
	static double tant = 1;

	string msg;

	strm >> temps >> velocitat >> angle;

	// Gitano code!
	for(;angle>2*M_PI;)
		angle=angle-2*M_PI;

	// Actualitzant info
	//
	robot.velocitat = velocitat;
	robot.angle	= angle;
	robot.tick	= temps - robot.temps;
	robot.temps	= temps;
	//PrintTime();

	if( ordres.size() )
	{
	   if( (ordres.begin()->temps)  < temps )
	   {
		switch( ordres.begin()->tipo )
		{
			case ORDRE_FRENA:
				DoRotate( 1, 0.0 );
				DoAccelerate( 0.0 );
				DoBrake( 1.0 );
				//break;			// TO DO: Test scan on brake
			case ORDRE_ESCANEJA:
				// DoPrint(" [i] Scanning");
				v = options.robot_cannon_max_rotate < options.robot_radar_max_rotate ? \
					options.robot_cannon_max_rotate : options.robot_radar_max_rotate;
				DoRotate( 2|4, v );
				robot.estat = ESTAT_ESCANEJANT;
				break;
			case ORDRE_MOU:
				DoAccelerate( ordres.begin()->valor );
				break;
			case ORDRE_DESFRENA:
				DoBrake( 0.0 );
				break;
		}
		ordres.erase(ordres.begin());
		return;
	   }
	}
	else 
	{
		if(  robot.estat != ESTAT_ESCANEJANT && robot.estat != ESTAT_ATACANT )
		{
			struct  t_ordre scan;
        		scan.temps = robot.temps + robot.tick;
        		scan.tipo = ORDRE_ESCANEJA;
			insertar_ordre( &scan );
		}
	}

	switch( robot.estat )
	{
		case ESTAT_PARAT:
			break;
		case ESTAT_ESCANEJANT:
			break;
		case ESTAT_ATACANT:
			if( robot.busca_fallos > BUSCA_MAX_FALLOS*2 )
			{
				//DoPrint( " [-] Perdido" );
				robot.estat = ESTAT_PARAT;
			}
			else if( robot.busca_rotacio == 0 && 
				( robot.busca_fallos > BUSCA_MAX_FALLOS ) )
			{
				double sentit = 1.0;

				//DoPrint( " [!] Rotando" );
				if( robot.angle > robot.busca_angle )
					sentit = -1.0;
				robot.busca_rotacio = 1;
				DoRotate( 2|4, options.robot_cannon_max_rotate*sentit );
				// TO DO
			}
			break;
	}
}

// TO DO: Unknown / no utilitzat en principi /
void ProcessaRotationReached(stringstream &strm)
{
	int	what;

	// TO DO:
	strm >> what;
	
}


// DONE - JUNK
void ProcessaCoordinates( stringstream &strm)
{
	double	x;
	double	y;
	double	angle;

	strm >> x >> y >> angle;
	// IGNORED
}

// DONE - JUNK
void ProcessaRobotsLeft(stringstream &strm)
{
	int	n;

	strm >> n;
	// IGNORED
}

void AfegeixEvasio()
{
	struct t_ordre	nova;

	nova.temps = robot.temps;
	nova.tipo  = ORDRE_MOU;
	nova.valor = options.robot_max_acceleration;
	insertar_ordre( &nova );

	nova.temps = robot.temps + EVASIO_TEMPS;
	nova.tipo  = ORDRE_FRENA;
	insertar_ordre( &nova ); 

	nova.temps = robot.temps + EVASIO_BRAKE;
	nova.tipo = ORDRE_DESFRENA;
	insertar_ordre( &nova );
	
}
// TO DO - unknown
void ProcessaCollision(stringstream &strm)
{
	int	tipo;
	double	angle;

	strm >> tipo >> angle;		

	if( tipo == 1 || tipo == 0 )
	{
		if( robot.estat != ESTAT_EVASIO )
		{
			DoPrint( " [i] Corre Forest!" );
			DoRotate( 1|2|4, -options.robot_max_rotate );
			AfegeixEvasio();
			robot.estat = ESTAT_EVASIO;
		}
	}
	// TO DO:
}

// DONE - JUNK
void ProcessaWarning(stringstream &strm)
{
	int	tipo;
	string	info;

	// IGNORED
}

// DONE - JUNK
void ProcessaExitRobot(stringstream &strm)
{
	robot.finalitzar = 1;
	// IGNORED
}

// TO DO: Unknown
void ProcessaGameFinishes(stringstream &strm)
{
	// TO DO:
}



// DONE - agafa a global
void ProcessaRobotInfo(stringstream &strm)
{
	double	energia;
	int	company;

	strm >> energia >> company;
	robot.energia_oponent = energia;
}

// DONE - print
void ProcessaDead(stringstream &strm)
{
	DoPrint( ":'(");
}
