///////////////////////////////////////////////////////////////////////////////
/// \file  IIndividuoIA.h
/// \brief Interfaz que describe el comportamiento de un individuo que puede ser
///        manejado por el sistema de IA del juego.
///
/// <b>F.Creacin:</b>19 de abril de 2005.         <br>
/// <b>Autor:     </b>Francisco Jos Gallego Durn <br>
///////////////////////////////////////////////////////////////////////////////
#ifndef __SR_IINDIVIDUOIA_H__
#define __SR_IINDIVIDUOIA_H__

/// INCLUDES
///
#include "CGenoma.h"

/// STRUCTS Y TIPOS
///
class IIndividuoIA;

/// <b> Vector de individuos de la inteligencia artificial. </b>
typedef vector<IIndividuoIA *> TPoblacionIA;

///
/// <b> CLASE ABSTRACTA: </b> IIndividuoIA.
///
/// Clase utilizada como interfaz de la inteligencia artificial. Todos los individuos del sistema de IA<br>
/// deben implementar esta interfaz, para poder as ser manejados por el Algoritmo Gentico.<br>
///
class IIndividuoIA
{
public:
    // Constructor y destructor por defecto
    IIndividuoIA  () { m_dPuntos = 0; m_Genoma = NULL; }
    ~IIndividuoIA () { BorrarGenoma ();                }

    // Mtodo de toma de decisiones
    virtual void TomarDecisiones () = 0;

    // Mtodos SET
    void        SetPuntuacion   (double p)   { m_dPuntos = p;     }
    void	    SetGenoma	(CGenoma* g) { m_Genoma  = g;     }
    void        AddPuntuacion   (double p)   { m_dPuntos += p;    }

    // Mtodos GET
    const CGenoma* GetGenoma	 () const  { return m_Genoma;  }
    double         GetPuntuacion () const  { return m_dPuntos;  }

    // Mtodos de trabajo
    void        BorrarGenoma  () { if (m_Genoma != NULL) { delete m_Genoma; m_Genoma = NULL; } }

     // Sobrecarga del operador < para ordenar de ms a menos Puntuacin
    friend bool
    operator< (const IIndividuoIA& Izq, const IIndividuoIA& Dcho) { return (Izq.m_dPuntos > Dcho.m_dPuntos); }
protected:
    double      m_dPuntos;  // Puntuacin obtenida
    CGenoma*    m_Genoma;   // Genoma que describe al individuo
};

#endif
