///////////////////////////////////////////////////////////////////////////////
/// \file  Genes.h
/// \brief Define las estructuras bsicas de los ladrillos que construyen genomas: los genes.
///
/// De esta forma, evitamos el problema de la redundancia cclica en la inclusin <br>
/// de archivos mediante include, que se daba entre CGenoma.h y CInnovacion.h     <br>
///
/// <b>F.Creacin:</b>  03 de abril de 2005.         <br>
/// <b>Autor:     </b>  Francisco Jos Gallego Durn.<br>
///////////////////////////////////////////////////////////////////////////////
#ifndef __SR_GENES_H__
#define __SR_GENES_H__

#include "tipos.h"
#include "CRedNeuronal.h"

/// STRUCTS Y TIPOS
///

/// <b>Estructura para definir el Gen que describe una Neurona</b>
struct SGenNeurona
{
    int      nID;
    TNeurona Tipo;
    bool     bRecurrente;
    double   dCurvaturaActivacion;
    double   dSplitX, dSplitY;

    SGenNeurona(TNeurona t, int id, double x,
                double y, bool r=false): nID(id), Tipo(t), bRecurrente(r),
                                         dSplitX(x), dSplitY(y),
                                         dCurvaturaActivacion(RandomDouble(0.0,1.0)) {}
};

/// <b>Estructura para definir el Gen que describe un enlace</b>
struct SGenEnlace
{
    int     nIDNeuronaInicio, nIDNeuronaFin;
    double  dPeso;
    bool    bHabilitado;
    bool    bRecurrente;
    int     nIDInnovacion;

    SGenEnlace(){}
    SGenEnlace(int in,  int fin,
               bool h, int tag,
               double p,bool r = false): bHabilitado   (h), nIDInnovacion (tag),
                                         nIDNeuronaInicio(in),
                                         nIDNeuronaFin (fin),
                                         dPeso(p), bRecurrente(r) {}

    // Sobrecarga del operador comparacin (Se usa el ID de innovacin para comparar)
    friend bool
    operator< (const SGenEnlace& GenIzq, const SGenEnlace& GenDcha)
    {
        return (GenIzq.nIDInnovacion < GenDcha.nIDInnovacion);
    }
};

/// <b> Tipo vector de genes enlace.</b>
typedef vector<SGenEnlace>  TGEnlaces;

/// <b> Tipo vector de genes neurona.</b>
typedef vector<SGenNeurona> TGNeuronas;

#endif
