///////////////////////////////////////////////////////////////////////////////
/// \file  CGenoma.h
/// \brief Clase que define el comportamiento de las tiras de genes (genomas).
///
/// Tambin define el comportamiento de los genes individuales.<br>
///
/// <b>F.Creacin:</b>  29 de octubre de 2004        <br>
/// <b>Autor:     </b>  Francisco Jos Gallego Durn <br>
///////////////////////////////////////////////////////////////////////////////
#ifndef __SR_CGENOMA_H__
#define __SR_CGENOMA_H__

/// INCLUDES
///
#include <vector>
#include <algorithm>
#include <iostream>
#include "CInnovacion.h"
#include "Genes.h"
//#include "tipos.h"

using namespace std;

/// DEFINES Y MACROS
///

/// CONSTANTES
///


/// Declaracin de clases a las que hace referencia CGenoma
///
class CInnovacion;

/// <b> CLASE: </b> CGenoma
///
/// <b>Ojo!</b> En esta clase es <b>MUY IMPORTANTE</b> que CGenoma::m_pFenotipo se instancie a NULL<br>
/// antes de llamar a CGenoma::Limpiar(), para evitar que se haga un delete de una direccin aleatoria<br>
/// de memoria.<br>
/// Para esto, es importante que <b>todos los constructores</b> usen un inicializador de miembro y<br>
/// <b>pongan CGenoma::m_pFenotipo a NULL.</b>
///
class CGenoma
{
public:
    // Constructores y Destructor
    CGenoma ();
    CGenoma (const CGenoma& g);
    CGenoma (int id, int entradas, int salidas);
    CGenoma (int id, TGNeuronas Neuronas, TGEnlaces Enlaces, int entradas, int salidas);

    ~CGenoma();

    // Operadores
    CGenoma&      operator= (const CGenoma& g);

    // Mtodos ADD
    void  AddEnlace  (double dRatioMutacion,   double dProbLoop,
                      CInnovacion& Innovacion, int nIntentosLoop, int nIntentosEnlace);
    //
    void  AddNeurona (double       RatioMutacion,
                      CInnovacion& Innovacion,
                      int          nIntentosEncontrarEnlaceAntiguo);


    // Sobrecarga del operador < para ordenar de ms a menos Idoneidad
    friend bool
    operator< (const CGenoma& Izq, const CGenoma& Dcho)
    {
        return (Izq.m_dIdoneidad > Dcho.m_dIdoneidad );
    }

    // Metodos de utilidad
    const
    CRedNeuronal* CrearFenotipo            ();
    void          Copiar                   (const CGenoma& g);
    void          Limpiar                  ();
    void          MutarPesos               (double dRatioMutacion, double dProbSustituirPeso, double dMaxPerturbacion);
    double        CalcularCompatibilidad   (const CGenoma &g) const;
    void          MutarCurvaturaActivacion (double RatioMutacion, double MaxPertubacion);

    void          OrdenarGenes             ()  { sort(m_vGenesEnlace.begin(), m_vGenesEnlace.end()); }
    void          BorrarFenotipo           ()  { if (m_pFenotipo != NULL) { delete m_pFenotipo; m_pFenotipo = NULL; } }


    // Mtodos Set
    void    SetID                (int val)    { m_nIDGenoma = val;         }
    void    SetIdoneidad         (double num) { m_dIdoneidad = num;        }
    void    SetIdoneidadAjustada (double num) { m_dIdoneidadAjustada = num;}
    void    SetNumHijosAExpandir (double num) { m_dHijosAExpandir = num;   }
    void    SetEspecie           (int spc)    { m_nEspecie = spc;          }

    // Mtodos Get
           unsigned int GetID                 () const { return m_nIDGenoma;            } // RONALDO:
           unsigned int GetEspecie            () const { return m_nEspecie;             } // Cambiados todos de
           unsigned int GetNumSalidas         () const { return m_nSalidasRed;          } // signed
           unsigned int GetNumEntradas        () const { return m_nEntradasRed;         } // a
           unsigned int GetNumGenesEnlace     () const { return m_vGenesEnlace.size();  } // unsigned int
           unsigned int GetNumGenesNeurona    () const { return m_vGenesNeurona.size(); } // (20/03/2006)
                 double GetIdoneidad          () const { return m_dIdoneidad;           }
                 double GetNumHijosAExpandir  () const { return m_dHijosAExpandir;      }
                 double GetIdoneidadAjustada  () const { return m_dIdoneidadAjustada;   }
                 double GetSplitY(const int val) const { return m_vGenesNeurona[val].dSplitY;}
       const TGEnlaces& GetGenesEnlace        () const { return m_vGenesEnlace;         }
      const TGNeuronas& GetGenesNeurona       () const { return m_vGenesNeurona;        }
    const CRedNeuronal* GetFenotipo           () const;
    TGEnlaces::const_iterator GetItPrimerGen  () const { return m_vGenesEnlace.begin(); }
    TGEnlaces::const_iterator GetItFinGenes   () const { return m_vGenesEnlace.end();   }

private:
             int  m_nIDGenoma;            ///< Identificador del Genoma
             int  m_nEspecie;             ///< La especie a la que pertenecen
             int  m_nSalidasRed;          ///< El nmero de salidas de la red neuronal
             int  m_nEntradasRed;         ///< El nmero de entradas que tiene la red neuronal
             int  m_nProfundidadRed;      ///< Profundidad que tendr el fenotipo (la red neuronal)
          double  m_dIdoneidad;           ///< Idoneidad del genoma en el entorno
          double  m_dHijosAExpandir;      ///< Cantidad de hijos que debe expandir el individuo
          double  m_dIdoneidadAjustada;   ///< Ajuste de la idoneidad en relacin a su especie
       TGEnlaces  m_vGenesEnlace;         ///< Vector que contiene los genes enlace
      TGNeuronas  m_vGenesNeurona;        ///< Vector que contiene todos los genes neurona
    CRedNeuronal* m_pFenotipo;            ///< Puntero al fenotipo

    bool EnlaceDuplicado    (int IDNeuronaIn, int IDNeuronaOut);
    bool IDNeuronaYaExiste  (const int IDNeurona);
    int  GetPosicionNeurona (int IDNeurona);
};

/// OPERADORES DE ENTRADA Y SALIDA
///
ostream& operator<<(ostream& out, const CGenoma& Genoma);
istream& operator>>(istream& in,        CGenoma& Genoma);

#endif
