///////////////////////////////////////////////////////////////////////////////
/// \file  CRTBot.h
/// \brief Descripcin de la clase que implementa el framework para crear Bots
///        del Real Time Battle
///
/// \author Francisco Jos Gallego Durn
/// \date   30 de Junio de 2006
///////////////////////////////////////////////////////////////////////////////

// Cosas para que la cabecera no se incluya ms de una vez
#ifndef __CRTBOT_H__
#define __CRTBOT_H__

#if _MSC_VER > 1000
#  pragma once
#endif

// INCLUDES
//
#include <iostream>
#include <sstream>
#include <string>
#include "Messagetypes.h"
#include "NEAT/CRedNeuronal.h"

// ENTRADAS DE LA RED NEURONAL
//
// de 0 a 4 son para el radar
#define IN_ANGULORADAR   5
#define IN_ENERGIABOT    6
#define IN_ANGULOCANYON  7
#define IN_VELOCIDAD     8
#define IN_TIEMPO        9
#define IN_ENERGIAOTRO   10
#define IN_COMPANYERO    11

///
/// \class CRTBot
/// \brief Clase que implementa el framework para crear bots de Real Time Battle
///        que funcionan mediante control de Reistream& serverin, ostream& serverout)des Neuronales de NEAT
///
class CRTBot //:public IIndividuoIA
{
public:
    // Constructor y Destructor
    CRTBot  (string sBotName, string sRed, istream& serverin, ostream& serverout, unsigned int numentradas);
    ~CRTBot ();

    // Mtodos Set
    void    SetEntrada (unsigned int nEntrada, double valor);

    // Mtodos Get
    bool    HaTerminado();

    // Mtodos de trabajo
    void    TomarDecisiones();

    // Comandos para enviar al servidor
    void    Inicializar();
    void    Acelerar (double v);
    void    Disparar (double v);
    void    Frenar   (double v);
    void    Girar    (TObjetoRotable objeto, double valor);

    // Manejadores de mensajes
    void    RobotInfo();
    void    Energy();
    void    Info();
    void    Radar();
    void    TerminarBot();
private:
    CRedNeuronal    m_RedNeuronal;              ///< Red Neuronal que controla el robot
    string          m_sNombreDelBot;            ///< Nombre que debe tener el Bot
    istream*        m_ServerIn;                 ///< Canal de entrada al Servidor de RTB
    ostream*        m_ServerOut;                ///< Canal de salida del Servidor de RTB
    vector<double>  m_vEntradas, m_vSalidas;    ///< Vectores de entradas y salidas de la Red Neuronal
    unsigned int    m_nNumEntradas;             ///< Nmero de entradas que tiene la red neuronal
    bool            m_bTerminado;               ///< Flag para indicar si el bot ha terminado de ejecutar
};

#endif
