//////////////////////////////////////////////////////
/// RONYBOT1
///
/// Robot de prueba para ver como funciona el RTB
/// autor ronaldo/Cheesetea
/// fecha 10/06/2006
//////////////////////////////////////////////////////

/// INCLUDES
///
#include <iostream>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#include "CRTBot.h"
#include "Messagetypes.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/// NAMESPACES
///
using namespace std;

/// GLOBAL VARS
///
CRTBot *Bot;

////////////////////////////////////////////////////////////
/// msg2enum
///
/// Transforma un mensaje en texto por parte de un robot
/// a un TMsg2Bot, que no es ms que un tipo enumerado
/// para indicarle al robot el tipo de mensaje recibido.
///
/// \param     msg_name Cadena de texto con el mensaje
/// \returns   TMsg2Bot Entero de la enumeracin TMsg2Bot
////////////////////////////////////////////////////////////
TMsg2Robot
msg2enum (char* msg)
{
   // Acortamos el nombre de la estructura;
   const struct SMensaje *Msg2R = kMensajes2Robot;

   // Buscamos el mensaje en la lista de mensajes y, si lo
   // encontramos, devolvemos el nmero de posicin que ocupa
   // en la lista
   for(int i=0; Msg2R[i].msg[0] != '\0'; i++)
   {
      if( strcmp(Msg2R[i].msg, msg) == 0 )
         return (TMsg2Robot)i;
   }

   return MSG_DESCONOCIDO_ROBOT;
}


////////////////////////////////////////////////////////////
/// manejar_senyal
///
/// Recibe las seales procedentes del RTB y procesa la
/// entrada de mensajes correspondiente.
///
/// \param senyal Seal recibida
////////////////////////////////////////////////////////////
void
manejar_senyal(int senyal)
{
   // Procesar la seal
   char comando[81];
   cin.clear();

   while(!cin.eof() && !Bot->HaTerminado())
   {
      cin >> comando;
      TMsg2Robot com = msg2enum (comando);

      switch (com)
      {
        case INFO_DEL_ROBOT: Bot->RobotInfo();   break;
        case ENERGIA:        Bot->Energy();      break;
        case INFO:           Bot->Info();        break;
        case INICIALIZANDO:  Bot->Inicializar(); break;
        case TERMINAR_ROBOT: Bot->TerminarBot(); break;
        case RADAR:          Bot->Radar();       break;
        default: break;
      }
   }
   Bot->TomarDecisiones();

   // Se vuelve a manejar la senyal otra vez con este mismo manejador
   signal(senyal, manejar_senyal);
}

////////////////////////////////////////////////////////////
/// Main
///
/// Punto de entrada de proceso del robot
////////////////////////////////////////////////////////////
int
main(int argc, char * argv[])
{
  // Inicializacin del bot
  string red = "AQUI_VA_EL_CEREBRO";
  Bot = new CRTBot (argv[0], red, cin, cout, 6);
  if (Bot == NULL)
  {
    cerr << "ERROR: No se pudo inicializar el Bot\n";
    exit(-1);
  }

  // Configuracin inicial del robot
  cout << "RobotOption "         << NO_BLOQUEANTE << " " << 1 << endl;
  cout << "RobotOption "         << SENYAL << " " << SIGUSR1 << endl;
  cout << "RobotOption "         << ENVIAR_ROTACION_ALCANZADA << " " << 2 << endl;
  cout.flush();

  // Establecer el manejador de seales
  sigset_t usr1set;
  signal(SIGUSR1, manejar_senyal);

  // Para evitar que libthread bloquee la SIGUSR1
  sigemptyset(&usr1set);
  sigaddset(&usr1set, SIGUSR1);
  sigprocmask(SIG_UNBLOCK, &usr1set, NULL);

  while (!Bot->HaTerminado())
  {
    Bot->TomarDecisiones();
    sleep(1);
  }

  return(EXIT_SUCCESS);
}
