///////////////////////////////////////////////////////////////////////////////
/// \file  CLogs.h
/// \brief Archivo de cabecera de una clase especialmente diseada para
///		   la creacin de logs en ficheros de disco
///
/// <b>Fecha Creacin: </b>12 de mayo de 2006           <br>
/// <b>Autor:          </b>Francisco Jos Gallego Durn.<br>
///////////////////////////////////////////////////////////////////////////////
#ifndef __CLOGS_H__
#define __CLOGS_H__

// Con esto solo se incluye el archivo de cabecera 1 vez
#if _MSC_VER > 1000
#  pragma once
#endif

#define _DEBUG

// INCLUDES
#include <cstdio>
#include <cassert>
#include <cstdarg>
#include <fstream>
#include <iostream>

using namespace std;

/// <b> CLASE: </b> CLog
///
///	Clase diseada para la creacin y el mantenimiento de un Log en disco <br>
/// con posibilidad de visualizarlo simultneamente en la terminal a voluntad. <br>
///
class CLog
{
public:
	/// Constructor del log
	CLog (string ruta, char* tituloLog);		  /// Crea un nuevo archivo de Log en la ruta especificada, sobreescribiendo anteriores si hubiera

	/// Mtodos para manejar el log
	void anyadirALog		(char* formato, ...);
	void mostrarPorConsola	(bool mostrar);
	void mostrarEnArchivo	(bool mostrar);

private:
	bool	m_bMostrarPorConsola;
	bool	m_bMostrarEnArchivo;
	string	m_sRuta;
};

#endif
