//////////////////////////////////////////////////////
/// PREDYBOT1
///
/// Robot de prueba para ver como funciona el RTB
/// autor predator/Cheesetea
/// fecha 22/07/2006
//////////////////////////////////////////////////////

/// INCLUDES
///
#include <iostream>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#include "Messagetypes.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/// NAMESPACES
///
using namespace std;

/// GLOBAL VARS
///
double zeroTime;
double lastTimeBotSeen;
bool   terminado;

////////////////////////////////////////////////////////////
/// msg2enum
///
/// Transforma un mensaje en texto por parte de un robot
/// a un TMsg2Bot, que no es ms que un tipo enumerado
/// para indicarle al robot el tipo de mensaje recibido.
///
/// \param     msg_name Cadena de texto con el mensaje
/// \returns   TMsg2Bot Entero de la enumeracin TMsg2Bot
////////////////////////////////////////////////////////////
TMsg2Robot
msg2enum (char* msg)
{
   // Acortamos el nombre de la estructura;
   const struct SMensaje *Msg2R = kMensajes2Robot;

   // Buscamos el mensaje en la lista de mensajes y, si lo 
   // encontramos, devolvemos el nmero de posicin que ocupa
   // en la lista
   for(int i=0; Msg2R[i].msg[0] != '\0'; i++)
   {
      if( strcmp(Msg2R[i].msg, msg) == 0 )
         return (TMsg2Robot)i;
   }

   return MSG_DESCONOCIDO_ROBOT;
}

////////////////////////////////////////////////////////////
/// getDoubleTime
///
/// Obtiene el tiempo actual del sistema como un nmero
/// double de segundos transcurridos desde 1/1/1980
///
/// \returns double  Segundos transcurridos
////////////////////////////////////////////////////////////
double
getDoubleTime ()
{
   static struct timeval  tv;
   static struct timezone tz;

   // Obtenemos el tiempo y la zona horaria
   gettimeofday (&tv, &tz);

   // Y componemos el double
   return (double)tv.tv_sec + (double)tv.tv_usec/1000000;
}

////////////////////////////////////////////////////////////
/// manejar_senyal
///
/// Recibe las seales procedentes del RTB y procesa la 
/// entrada de mensajes correspondiente.
///
/// \param senyal Seal recibida
////////////////////////////////////////////////////////////
void
manejar_senyal(int senyal)
{
   // Procesar la seal
   char comando[81];
   cin.clear();

   const double SecsInterval = 1.0;
   if ((getDoubleTime() - lastTimeBotSeen) > SecsInterval)
   {
      cout << "Brake " << 1.0 << endl;
      cout << "Rotate " << 7 << " " << 0.78 << endl;
   }
   else
   {
      cout << "Rotate " << 7 << " " << 0.0 << endl;
      cout << "Accelerate " << 1 << endl;
      cout << "Shoot " << 3 << endl;
   }

   while(!cin.eof() && !terminado)
   {
      cin >> comando;
      TMsg2Robot com = msg2enum (comando);
      
      if (com == TERMINAR_ROBOT) terminado = true;
      if (com == RADAR)
      {
         double distancia, angulo;
         int    objeto;

         cin >> distancia >> objeto >> angulo;
         switch(objeto)
         {
            case ROBOT:
            {
               cout << "Print Al Ataqueeer!" << endl;
               lastTimeBotSeen = getDoubleTime();
               break;
            }

            default:
            break;
         }
      }
   }
  
   // Se vuelve a manejar la senyal otra vez con este mismo manejador
   signal(senyal, manejar_senyal);
}

////////////////////////////////////////////////////////////
/// Main
///
/// Punto de entrada de proceso del robot
////////////////////////////////////////////////////////////
int 
main(int argc, char * argv[])
{
  // Configuracin inicial del robot
  cout << "RobotOption "         << NO_BLOQUEANTE << " " << 1 << endl;
  cout << "RobotOption "         << SENYAL << " " << SIGUSR1 << endl;
  cout << "RobotOption "         << ENVIAR_ROTACION_ALCANZADA << " " << 2 << endl;
  cout << "Name predatorcin"     << endl;
  cout << "Colour 0000FF FFFFFF" << endl;
  cout.flush();

  // Inicializar variables
  zeroTime        = getDoubleTime();
  lastTimeBotSeen = 0;
  terminado       = false;

  // Establecer el manejador de seales  
  sigset_t usr1set;
  signal(SIGUSR1, manejar_senyal);

  // Para evitar que libthread bloquee la SIGUSR1
  sigemptyset(&usr1set);
  sigaddset(&usr1set, SIGUSR1);
  sigprocmask(SIG_UNBLOCK, &usr1set, NULL);

  while (!terminado)
  {
    sleep(1);
  }

  return(EXIT_SUCCESS);
}
