/////////////////////////////////////////////
/// LIBRERA DE TIPOS DE MENSAJES
///
/// Modificacin de Messagetypes.h
/// autor ronaldo ^ Cheesetea
/// fecha 10/06/2006
/////////////////////////////////////////////

#ifndef __MESSAGETYPES__
#define __MESSAGETYPES__

/// Lista de mensajes que puede recibir un robot
enum TMsg2Robot
{
  MSG_DESCONOCIDO_ROBOT = -1,
  INICIALIZANDO,
  TU_NOMBRE,
  TU_COLOR,
  OPCION_DE_JUEGO,
  COMIENZA_EL_JUEGO,
  RADAR,
  INFO,
  TUS_COORDENADAS,
  INFO_DEL_ROBOT,
  ROTACION_ALCANZADA,
  ENERGIA,
  ROBOTS_VIVOS,
  COLISION,
  ADVERTENCIA,
  HAS_MUERTO,
  TERMINA_EL_JUEGO,
  TERMINAR_ROBOT
};

/// Lista de mensajes que puede enviar un robot
enum TMsg2RTB 
{
  MSG_DESCONOCIDO_RTB = -1,
  OPCION_DEL_ROBOT,
  NOMBRE,
  COLOR,
  ROTAR,
  ROTAR_HASTA,
  ROTAR_CANTIDAD,
  MODO_BARRIDO,
  ACELERAR,
  FRENAR,
  BREAK,
  DISPARAR,
  IMPRIMIR,
  DEPURACION,
  LINEA_DEPURACION,
  CIRCULO_DEPURACION
};

/// Tipos de argumento posibles para los mensajes
enum TArgumento
{
  NONE,
  STRING,
  DOUBLE,
  INT,
  HEX
};

/// Lista de adevertencias posibles
enum TAdvertencia
{
  MSG_DESCONOCIDO  = 0,
  TIEMPO_CPU_SOBREPASADO = 1,
  MSG_ENVIADO_EN_ESTADO_ILEGAL =2,
  OPCION_DESCONOCIDA =3,
  PALABRA_CLAVE_OBSOLETA =4,
  NOMBRE_NO_DADO = 5,
  COLOR_NO_DADO =6
};

/// Tipos de opciones de juego
enum TOpcionJuego
{
  ROBOT_ROTACION_MAX        = 0,
  ROBOT_ROTACION_MAX_CANYON = 1,
  ROBOT_ROTACION_MAX_RADAR  = 2,

  ROBOT_ACELERACION_MAX     = 3,
  ROBOT_ACELERACION_MIN     = 4,

  ROBOT_ENERGIA_INICIAL     = 5,
  ROBOT_ENERGIA_MAX         = 6,
  ROBOT_NIVELES_DE_ENERGIA  = 7,

  VELOCIDAD_DE_DISPARO      = 8,
  ENERGIA_MIN_DE_DISPARO    = 9,
  ENERGIA_MAX_DE_DISPARO    = 10,
  SHOT_ENERGY_INCREASE_SPEED= 11,

  TIMEOUT                   = 12,

  NIVEL_DE_DEPURACION       = 13,  // 0 - no debug, 5 - maximo nivel de depuracin

  ROBOT_ENVIAR_COORDENADAS  = 14   // 0 - sin coordenadas, 
                                   // 1 - relativas a la posicin inicial
                                   // 2 - absolutas 
};

/// Tipos de opciones del robot
enum TOpcionRobot
{
  SENYAL                    = 2,// 0 - sin seal, > 1 - seal a enviar (por ejemplo SIGUSR1 or SIGUSR2) 
  ENVIAR_SENYAL             = 0,// 0 - false, 1 - true
  ENVIAR_ROTACION_ALCANZADA = 1,// 0 - sin mensajes de rotacion
                                // 1 - mensajes al terminal Rotar_hasta y Rotar_Cantidad
                                // 2 - mensajes tambin cuando cambie la direccin de barrido

  NO_BLOQUEANTE             = 3  // 0 - false, 1 - true 
                                 // Debera ser enviando lo antes que se pueda para no bloquear lecturas y escrituras

};

/// Tipos de objetos
enum TObjeto
{ 
  NINGUN_OBJETO = -1, 
  ROBOT         = 0, 
  DISPARO       = 1, 
  PARED         = 2, 
  GALLETA       = 3, 
  MINA          = 4,
  ULTIMO_TIPO_DE_OBJETO = 5
};

/// Nmero de tipos de objeto
static const int kNumTiposObjeto = 5;

/// Mensajes
struct SMensaje
{
  char* msg;
  int   nArgumentos;
  enum  TArgumento tArgumento[4];
};

/// Lista de cadenas de los mensajes que puede recibir el robot con su nmero y tipo de argumentos
static const 
struct SMensaje kMensajes2Robot[25] = 
{
  {"Initialize", 1, {INT,    NONE,   NONE,   NONE}},   // arg: Si el primer argumento es 1, es la primera secuencia, enva tu nombre y color!
  {"YourName",   1, {STRING, NONE,   NONE,   NONE}},   // arg: Este es tu nombre, si no te gusta, puedes cambiarlo
  {"YourColour", 1, {HEX,    NONE,   NONE,   NONE}},   // arg: Este es el color que tienes
  {"GameOption", 2, {INT,    DOUBLE, NONE,   NONE}},   // arg 1: Nmero de opcin,  arg 2:  valor
  {"GameStarts", 0, {NONE,   NONE,   NONE,   NONE}},   // Comienza el juego
  {"Radar",      3, {DOUBLE, INT,    DOUBLE, NONE}},   // arg 1: Distancia, arg 2: Tipo de objeto, arg 3: angulo del radar
  {"Info",       3, {DOUBLE, DOUBLE, DOUBLE, NONE}},   // arg 1: Tiempo, arg 2: velocidad, arg 3: angulo del caon
  {"Coordinates",3, {DOUBLE, DOUBLE, DOUBLE, NONE}},   // arg 1: x, arg 2: y, arg 3: angle
  {"RobotInfo",  2, {DOUBLE, INT,    NONE,   NONE}},   // arg 1: Energa del robot contrario, arg 2: Enemigos->0, Compaeros-> 1
  {"RotationReached",1,{INT, NONE,   NONE,   NONE}},   // arg 1: Que es lo que ha terminado de rotar(Ver Rotate)
  {"Energy",     1, {DOUBLE, NONE,   NONE,   NONE}},   // arg: Nivel de energa
  {"RobotsLeft", 1, {INT,    NONE,   NONE,   NONE}},   // arg: Robots restantes
  {"Collision",  2, {INT,    DOUBLE, NONE,   NONE}},   // arg 1: Tipo de Objeto, arg 2: ngulo de colisin
  {"Warning",    2, {INT,    STRING, NONE,   NONE}},   // arg 1: Tipo de advertencia, arg 2: cadena de advertencia
  {"Dead",       0, {NONE,   NONE,   NONE,   NONE}},   // El robot ha muerto  
  {"GameFinishes",0,{NONE,   NONE,   NONE,   NONE}},   // El juego ha terminado
  {"ExitRobot",  0, {NONE,   NONE,   NONE,   NONE}},   // T robot debe finalizar el proceso
  {"",           0, {}}
};

/// Lista de cadenas de mensajes que puede enviar el robot, con su nmero y tipo de argumentos
static const 
struct SMensaje kMensajes2RTB[25] = 
{
  {"RobotOption",  2, {   INT,    INT,   NONE,   NONE}}, // arg 1: Nmero de opcin, arg 2: valor 
  {"Name",         1, {STRING,   NONE,   NONE,   NONE}}, // arg: Nombre del robot
  {"Colour",       2, {   HEX,    HEX,   NONE,   NONE}}, // arg 1: Color cuando se juega en casa, arg 2: Color como visitante
  {"Rotate",       2, {   INT, DOUBLE,   NONE,   NONE}}, // arg 1: Qu se quiere rotar{1 Robot, 2 Caon, 4 Radar(se pueden sumar)}
                                                         // arg 2: Velocidad angular (rad/s)
  {"RotateTo",     3, {   INT, DOUBLE, DOUBLE,   NONE}}, // args 1 y 2: Igual que en rotate, arg 3: Angulo hasta el que moverse
  {"RotateAmount", 3, {   INT, DOUBLE, DOUBLE,   NONE}}, // args 1 y 2: Igual que en rotate, arg 3: Angulo a rotar (incremento sobre el actual)
  {"Sweep",        4, {   INT, DOUBLE, DOUBLE, DOUBLE}}, // args 1 y 2: Igual que en rotate, pero slo valen caon y radar
                                                         // arg 3: ngulo izquierdo lmite, arg 4: ngulo derecho lmite(relativo al robot)
  {"Accelerate",   1, {DOUBLE,   NONE,   NONE,   NONE}}, // arg: Aceleracin en m/s^2
  {"Brake",        1, {DOUBLE,   NONE,   NONE,   NONE}}, // arg: Porcentaje de frenada [0 (no frena), 1 (freno total)]
  {"Break",        1, {DOUBLE,   NONE,   NONE,   NONE}}, // Como Brake, pero se incluye por razones de compatibilidad (error al deletrear en previas versiones).
  {"Shoot",        1, {DOUBLE,   NONE,   NONE,   NONE}}, // arg: Cantidad de energa
  {"Print",        1, {STRING,   NONE,   NONE,   NONE}}, // arg: Mensaje a imprimir   
  {"Debug",        1, {STRING,   NONE,   NONE,   NONE}}, // arg: Mensaje de depuracin
  {"DebugLine",    4, {DOUBLE, DOUBLE, DOUBLE, DOUBLE}}, // args1,2: ngulo en el punto inicial, radio (relativo al robot)
                                                         // args3,4: ngulo del punto final, Radio (relativo al robot)
  {"DebugCircle",  3, {DOUBLE, DOUBLE, DOUBLE,   NONE}}, // args1,2: ngulo en el punto central, Radio (relativo al robot)
                                                         // arg 3: Radio del Crculo
  {"",             0, {}}
};
#endif 
