
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#ifdef TIME_WITH_SYS_TIME 
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef HAVE_LOCALE_H
# include <locale.h>
#endif

#include "IntlDefs.h"
#include "mailonsrage.h"

namespace std { }
using namespace std;



// Function for sending messages from robot. 
// They do nothing but write the command and its arguments to cout.
void MailonsRage::robot_option( const int option, const int value )
{cout << "RobotOption " << option << " " << value << endl;}
void MailonsRage::name( const char* name )
{cout << "Name " << name << endl;}
void MailonsRage::colour( const char* home, const char* away )
{cout << "Colour " << home << " " << away << endl;}

//VISUALIZACION ---------------------->
void MailonsRage::print( const char* message )
{cout << "Print " << message << endl;}
void MailonsRage::debug( const char* message )
{cout << "Debug " << message << endl;}
//FIN VISUALIZACION <------------------

//FUNCIONES VARIAS -------------------->
void MailonsRage::shoot( const double energy )
{if(!panicMode)cout << "Shoot " << energy << endl;}
void MailonsRage::sweep( const int what, const double vel, const double left, const double right )
{cout << "Sweep " << what << " " << vel << " "<< left << " " << right << endl;}
void MailonsRage::game_option( const int option, const double value )
{// This function is called when a game option is changed and the robot's copy of this option will change.
  switch( option )
  {
    case ROBOT_MAX_ROTATE:
      robot_max_rotate = value;
      break;
    case ROBOT_CANNON_MAX_ROTATE:
      robot_cannon_max_rotate = value;
      break;
    case ROBOT_RADAR_MAX_ROTATE:
      robot_radar_max_rotate = value;
      break;
    case ROBOT_MAX_ACCELERATION:
      robot_max_acceleration = value;
      break;
    case ROBOT_MIN_ACCELERATION:
      robot_min_acceleration = value;
      break;
    case ROBOT_START_ENERGY:
      robot_start_energy = value;
      break;
    case ROBOT_MAX_ENERGY:
      robot_max_energy = value;
      break;
    case ROBOT_ENERGY_LEVELS:
      robot_energy_levels = value;
      break;
    case SHOT_SPEED:
      shot_speed = value;
      break;
    case SHOT_MIN_ENERGY:
      shot_min_energy = value;
      break;
    case SHOT_MAX_ENERGY:
      shot_max_energy = value;
      break;
    case SHOT_ENERGY_INCREASE_SPEED:
      shot_energy_increase_speed = value;
      break;
    case TIMEOUT:
      timeout = value;
      break;
    case DEBUG_LEVEL:
      debug_level = 8;
      break;
    case SEND_ROBOT_COORDINATES:
      send_robot_coordinates = (int)rint(value);
      break;
  }
}
//FIN FUNCIONES VARIAS <-----------------


//MOVIMIENTO----------------->
void MailonsRage::accelerate( const double amount )
{cout << "Accelerate " << amount << endl;}
void MailonsRage::brake( const double amount )
{cout << "Brake " << amount << endl;}
//FIN MOVIMIENTO <-------------



//ROTACIONES---------------->
void MailonsRage::rotate( const int what, const double vel )
{
  if(robot_rotate_allow || what!=gorka_ROBOT)
   {cout << "Rotate " << what << " " << vel << endl;}
}
void MailonsRage::rotate_to( const int what, const double vel, const double angle )
{
   if(robot_rotate_allow || what!=gorka_ROBOT)
  cout << "RotateTo " << what << " " << vel << " " << angle << endl;
}
void MailonsRage::rotate_amount( const int what, const double vel, const double angle )
{
  if(robot_rotate_allow || what!=gorka_ROBOT)
    cout << "RotateAmount " << what << " " << vel << " " << angle << endl;
}
// Check if rotation has been reached.If it is the robot. Begin normal acceleration and rotation
void MailonsRage::rotation_reached( const int what )
{
 switch(what)
  {
    case gorka_ROBOT:
    {
      robot_rotate_allow=true;
      accelerate(robot_max_acceleration);
      radar_and_cannon_rotate=robot_cannon_max_rotate;
      break;
    }
    default:
    {
//       cout<<"Print void MailonsRage::rotation_reached( const int what ):: ERROR :"<<what<<endl;
    }
  }
}
//FIN ROTACIONES <-------------

void MailonsRage::largeMision(const double dist, const double angle )
{}

void MailonsRage::mision(const double dist, const double angle )
{

}

void MailonsRage::lockTarget(const double dist, const double angle )
{
//   if(target.lastlastangle>target.lastangle)
//   {
//     cout<<"Rotate 6 "<<asin(sin(robot_cannon_max_rotate))<<endl;
//   }
//   else
//   {
//     cout<<"Rotate 6 "<<asin(sin(-robot_cannon_max_rotate))<<endl;
//   }
  cout<<"Sweep 6 " << 6 << asin(sin(robot_cannon_max_rotate)) << asin(sin(-robot_cannon_max_rotate))<<endl;
}

void MailonsRage::callMision( const double dist, const double angle )
{
  if(dist<3)
    {
      if(acceleration<1)
      {
        shoot(shot_max_energy);
        mision(dist,angle);
      }
      else
      {
        acceleration=0.0;
        brake_value=60;
        shoot(shot_max_energy);
        mision(dist,angle);
      }

    }
    else
    {
     largeMision(dist,angle);
      shoot(1);
    }
}
//FUNCIONES DE EVENTOS DEL RADAR ------------------------->
void MailonsRage::radar_robot( const double dist, const double angle )
{// Radar info when robot is seen.Lock cannon and radar on the seen robot, and if it is near enough, begin to brake. Shoot at it.
// cout<<"Print radar_robot dist:"<<dist<<" angle:"<<asin(sin(angle))<<endl;
  if(!target.isLast)
  {    
    gettimeofday(&target.lastlastTime, NULL);
    target.lastlastangle=angle;
    target.lastlastDist=dist;
    target.isLast=true;
  }
  else
  {
    if(target.iniciado)
    {
      target.lastlastDist=target.lastDist;
      target.lastlastTime=target.lastTime;
      target.lastlastangle=target.lastangle;

      gettimeofday(&target.lastlastTime, NULL);
      target.lastlastangle=angle;
      target.lastlastDist=dist;
    }
    else
    {
      gettimeofday(&target.lastTime, NULL);
      target.lastangle=angle;
      target.lastDist=dist;
      target.iniciado=true;
    }
  }
  shoot(shot_max_energy);
 cout << "Brake " << 770 << endl;
 cout << "Accelerate " << 0 << endl;
 lockTarget(dist,angle);
}
void MailonsRage::radar_shot( const double dist, const double angle )
{// Radar info when a shot is seen.
 
  acceleration=200;
}
void MailonsRage::searchTarget(const double dist, const double angle )
{
  if(target.lastlastangle>target.lastangle)
  {
    cout<<"Rotate 6 "<<-robot_cannon_max_rotate<<endl;
  }
  else
  {
    cout<<"Rotate 6 "<<robot_cannon_max_rotate<<endl;
  }
}
void MailonsRage::radar_wall( const double dist, const double angle )
{// Radar info when a wall is seen. If a wall is near in the robot direction, begin to brake, else have normal acceleration.
if(panicMode)
{if(dist<8)
  {
    cout << "Accelerate " << 1 << endl;
    cout << "Brake " << 0.3 << endl;
    cout<<"Rotate 1 "<<robot_cannon_max_rotate<<endl;
  }
  return;
}
  cout << "Accelerate " << 2 << endl;
  cout << "Brake " << 0 << endl;
  cout<<"Rotate 1 "<<robot_cannon_max_rotate<<endl;
  
  searchTarget(dist,angle);
}

void MailonsRage::radar_cookie( const double dist, const double angle )
{// Radar info when a cookie is seen.
    double newangle = asin(sin(angle));
    cout << "RotateAmount 1 " << robot_max_rotate << " " << newangle << endl;
    cout << "Accelerate " << 10 << endl;
    cout << "RotateAmount 6 " << robot_cannon_max_rotate << " " << -newangle << endl;
    cout << "Brake " << 0 << endl;
}
void MailonsRage::radar_mine( const double dist, const double angle )
{// Radar info when a mine is seen.
   if (dist < 5.0)
    {
      cout << "Shoot " << shot_min_energy << endl;
      //cout << "Print Skjuter" << endl;
    }
}
//FIN FUNCIONES DE EVENTOS DEL RADAR <----------------------




void MailonsRage::energy( const double energylevel )
{// Our energy level.
  if(energylevel<10)
   {panicMode=true;}
  else
   {panicMode=false;}
}



// You have been ordered to exit the robot
void MailonsRage::exit_robot()
{
  print( _("Shutting down and leaving") );
  quitting = true;
}

// This function is called before checking messages.
// Every hundred time, change the direction of the rotation.
void MailonsRage::pre_checking_messages()
{

//   accelerate(acceleration);
//   brake(brake_value);
}

// This function handles all the message checking and
// calls the appropriate function.
// This function is called whenever a SIGUSR1 (decided in the
// robotoption sent to the server) signal is received.
void MailonsRage::check_messages( )
{
  quitting = false;

  char msg_name[81];
  message_to_robot_type msg_t;

  cin.clear();
  while( !cin.eof() && !quitting )
    {
      pre_checking_messages();

      cin >> msg_name;
      msg_t = name2msg_to_robot_type(msg_name);

      switch(msg_t)
      {
        case INITIALIZE:
          {
            cout<<"Print check_messages( ):: Inicializando"<<endl;
            int init;
            cin >> init;
            initialize( init );
          }
          break;
        case YOUR_NAME:
          {
            cout<<"Print check_messages( ):: mi nombre"<<endl;
            char name[81];
            cin >> name;
          }
          break;
        case YOUR_COLOUR:
          {
            cout<<"Print check_messages( ):: mi color"<<endl;
            char col[81];
            cin >> col;
          }
          break;
        case GAME_OPTION:
          {
            cout<<"Print check_messages( ):: game_option"<<endl;
            int nr;
            double value;
            cin >> nr >> value;
            game_option( nr, value );
          }
          break;
        case GAME_STARTS:
          {
          cout<<"Print check_messages( ):: game_starts"<<endl;
          game_starts();
          break;
          }
        case RADAR:
          {
//             cout<<"Print check_messages( ):: radar"<<endl;
            double dist, angle;
            int object;

            cin >> dist >> object >> angle;
            switch(object)
              {
              case NOOBJECT:
            //    radar_noobject( dist, angle );
                break;
              case ROBOT:
               radar_robot( dist, angle );
                break;
              case WALL:
                radar_wall( dist, angle );
                break;
              case SHOT:
            //    radar_shot( dist, angle );
                break;
              case COOKIE:
                  radar_cookie( dist, angle );
                break;
              case MINE:
                  radar_mine( dist, angle );
                break;
              default:
                cout << "Print" << _("Unknown Object seen!") << endl;
                break;
              }
          }
          break;          

        case INFO:
          {
            double time, speed, cannon_angle;
            cin >> time >> speed >> cannon_angle;
//             cout<<"Print Info - speed:"<<speed<<"; cannon_angle:"<<cannon_angle<<"; time:"<<time<<endl; 
//              info( time, speed, cannon_angle );
          break;
          }

        case ROTATION_REACHED:
          {
            cout<<"Print ROTACION FINALIZADA"<<endl;
             int what;
             cin >> what;
             rotation_reached( what );
          break;
          }
        case ENERGY:
          {
            double en;
            cin >> en;
            energy( en );
          break;
          }
        case ROBOTS_LEFT:
          {
            cout<<"Print check_messages( ):: robots_left"<<endl;
//             int nr;
//             cin >> nr;
//             robots_left( nr );
          break;
          }

        case DEAD:
        {
          cout<<"Print check_messages( ):: muerto"<<endl;
          
          break;
        }
        case GAME_FINISHES:
        {
          cout<<"Print check_messages( ):: game_finishes"<<endl;
//           game_finishes();
          break;
        }
        case EXIT_ROBOT:
        {
          cout<<"Print check_messages( ):: exit_robot"<<endl;
          exit_robot();
          break;
        }
        default:{break;}
        
    }
  }
}

// A function to convert the messagename to an enum message_to_robot_type
message_to_robot_type
name2msg_to_robot_type(char* msg_name)
{
  for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
      if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
        return (message_to_robot_type)i;
    }
  return UNKNOWN_MESSAGE_TO_ROBOT;
}
//INICIALIZACION --------------------->   
void MailonsRage::initialize( const int first_seq )
{ // Send name and colour if it is the first sequence.
  if( first_seq == 1 )
  {
    name( robot_name );
    colour( robot_colour, robot_colour );
  }
}
void MailonsRage::game_starts()
{// Reset the robot when a new game starts. Send initial rotate and accelerate commands.
  radar_rotate = 0.0;
  robot_rotate = 0.0;
  radar_and_cannon_rotate = 1.0;
  acceleration = 0.0;
  brake_value =  0.0;
  rotateAmount=  0.0;
  target.iniciado=false;
  target.isLast=false;
  target.lastlastangle=0.0;
  target.lastangle=0.0;
  panicMode=false;
  robotIsRotatingTo=false;
  robot_rotate_allow=false;
  shots_hit = 0;
  last_shot_hit_time = -2.0;
  current_time = 0;
}
//FIN INICIALIZACION <-----------------
MailonsRage::MailonsRage(const char* name, const char* colour)
{
  robot_name = new char[strlen(name) + 1];
  strcpy(robot_name, name);

  robot_colour = new char[strlen(colour) + 1];
  strcpy(robot_colour, colour);

  quitting = false;

  robot_rotate = 0.0;
  acceleration = 0.0;
  brake_value = 0.0;

  // Get random seed from the clock
  //timeval current_time;
  //gettimeofday(&current_time, NULL);
  //srand(current_time.tv_usec);

  // We want to know when RotateTo and RotateAmount finishes
  robot_option( SEND_ROTATION_REACHED, 1 );
}

MailonsRage::~MailonsRage()
{
  delete [] robot_name;
  delete [] robot_colour;
}
