#include <iostream>
#include </usr/include/realtimebattle/Messagetypes.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <math.h>
#define abs(x) ((x>0) ? (x) : -(x))
#define sgn(x) ((x>0) ? 1 : -1)
#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
// Constantes de Entorno
double g=9.82, k=0.005, mu= 0.002, f=0.1;
// Variables
double energia, angulo_robot, aceleracion, angulo_radar, angulo_canon, velocidad;
double rotacion_canon, intervalo_energia, energia_relativa, tiempo, energia_disparo;
double rotacion_radar, barrido_min, barrido_max, rotar_a, distancia_frenado, freno, velocidad_angular=1;
int cual_termino;
// Constantes de cada juego
double limite_rotacion, limite_rotacion_canon, limite_rotacion_radar, aceleracion_max, aceleracion_min;
double energia_inicial, energia_max, energia_error, velocidad_disparo, disparo_min=0, disparo_max=0, disparo_incremento;
double velocidad_max=4.0;
volatile sig_atomic_t exit_robot = false;
using std::endl;
using std::cin;
using std::cout;
message_to_robot_type
nombre_mensaje(char* n_mensaje)
{
  for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
      if( strcmp(message_to_robot[i].msg, n_mensaje ) == 0 )
        return (message_to_robot_type)i;
    }
  return UNKNOWN_MESSAGE_TO_ROBOT;
}

void
leermensaje(int sig)
{
	exit_robot = false;
	char n_mensaje[81];
	message_to_robot_type tipomensaje;	
	cin.clear();
	while (!cin.eof())	
	{
		barrido_min=-M_PI/4;
		barrido_max=M_PI/4;
		std::cin >> n_mensaje;
		tipomensaje = nombre_mensaje(n_mensaje);
		switch (tipomensaje)
		{			
			case INITIALIZE:
				int inicio;
				cin >> inicio ;
				if (inicio == 1)
           			{
					cout << "Name juanluputa" << endl;
					cout << "Colour AA56DE  FF0000" << endl;
				}
				break;
			case GAME_FINISHES:
        			break;
			case GAME_STARTS:
				rotacion_radar=2*M_PI;
				aceleracion=3.0;
				barrido_min=angulo_radar - (M_PI/4);
				barrido_max=angulo_radar + (M_PI/4);
				cout << "Sweep 6 " << rotacion_radar << " " << barrido_min << " " << barrido_max << endl;
				cout << "Accelerate " << aceleracion << endl;
				break;
			case GAME_OPTION:
				int opcion;
				double valor;
				cin >> opcion >> valor;
				switch (opcion)
				{
					case ROBOT_MAX_ROTATE:
						limite_rotacion=valor;
						break;
					case ROBOT_CANNON_MAX_ROTATE:
						limite_rotacion_canon=valor;
						break;
					case ROBOT_RADAR_MAX_ROTATE:
						limite_rotacion_radar=valor;
						break;
					case ROBOT_MAX_ACCELERATION:
						aceleracion_max=valor;
						break;
					case ROBOT_MIN_ACCELERATION:
						aceleracion_min=valor;
						break;
					case ROBOT_START_ENERGY:
						energia_inicial=valor;
						break;
					case ROBOT_MAX_ENERGY:
						energia_max=valor;
						break;
					case ROBOT_ENERGY_LEVELS:
						energia_error=valor;
						break;
					case SHOT_SPEED:
						velocidad_disparo=valor;
						break;
					case SHOT_MIN_ENERGY:
						disparo_min=valor;
						intervalo_energia = disparo_max - disparo_min;
						break;
					case SHOT_MAX_ENERGY:
						disparo_max=valor;
						intervalo_energia = disparo_max - disparo_min;
						break;
					case SHOT_ENERGY_INCREASE_SPEED:
						disparo_incremento=valor;
						break;
					break;
				}
				break;
			case ENERGY:
				cin >> energia;
				energia_relativa = energia_max / energia;
				break;
			case INFO:
				cin >> tiempo >> velocidad >> angulo_canon;
				if (velocidad >= velocidad_max)
				{
					cout << "Accelerate 0.3" << endl;
				}
				else
				{
					cout << "Accelerate " << aceleracion << endl;
				}
				if (velocidad = 0)
				{
					cout << "Brake 0" << endl;
				}
				break;
			case RADAR:
				int objeto;
				double distancia;
				cin >> distancia >> objeto >> angulo_radar;
				switch (objeto)
				{
					case ROBOT:
						barrido_min=angulo_radar - M_PI/36;
						barrido_max=angulo_radar + M_PI/36;
						energia_disparo = disparo_min + (intervalo_energia * energia_relativa);
						if (energia_relativa >0.05)
						{
							cout << "Shoot " << energia_disparo << endl;
						}
						if (angulo_radar != 0)
						{
							rotar_a=angulo_radar;
							if (angulo_radar <= M_PI)
							{
								velocidad_angular=limite_rotacion;
							}
							else
							{
								velocidad_angular=-1*limite_rotacion;
							}
						cout << "RotateAmount 1 " << velocidad_angular << " " << rotar_a << endl;	
						}
						break;
					case WALL:						
						if ((distancia < 3) and (-M_PI/12 < angulo_radar < M_PI/12))
						{
							cout << "RotateAmount 1 " << velocidad_angular << " " << M_PI << endl;
						}
						break;
					case COOKIE:
						barrido_max=angulo_radar+ asin(0.3/distancia);
						barrido_min=angulo_radar-+ asin(0.3/distancia);
						rotar_a=angulo_radar;
						if (angulo_radar <= M_PI)
						{
							velocidad_angular=limite_rotacion;
						}
						else
						{
							velocidad_angular=-1*limite_rotacion;
						}
						cout << "RotateAmount 1 " << velocidad_angular << " " << rotar_a << endl;
						break;
					case MINE:						
						if (energia_relativa >0.05)
						{
							cout << "Shoot " << disparo_min << endl;
						}
						break;
					break;
				}
				break;
			case ROTATION_REACHED:
				cin >> cual_termino;
				if ((cual_termino ==1) or (cual_termino ==3) or (cual_termino == 5) or (cual_termino==7))
				{
					cout << "Rotate 1 0" << endl;
				}
				break;
			case COLLISION:
				int objeto_colision;
				int angulo_colision;
				cin >> objeto_colision >> angulo_colision;
				switch (objeto_colision)
				{
					case MINE:
						cout << "Print Ouch!!!" << endl;
						break;
					case COOKIE:
						cout <<"Print Mmmmmm.... Galletita" << endl;
						break;
					case SHOT:
						if (abs(angulo_colision)<(M_PI/4))
						{
							cout << "RotateAmount 1 " << velocidad_angular << " " << angulo_colision << endl;
						}
						break;
					case ROBOT:
						if (abs(angulo_colision)<(M_PI/4))
						{
							cout << "RotateAmount 1 " << velocidad_angular << " " << angulo_colision << endl;
						}
						break;
					break;
				}
				break;
			default:
				break;
		}
	cout << "Sweep 6 " << rotacion_radar << " " << barrido_min << " " << barrido_max << endl;
	}	
	signal (sig, leermensaje);
}
int
main()
{	
	signal (SIGUSR1, leermensaje);
	cout << "RobotOption " << SEND_SIGNAL << " " << true << endl;
	cout << "RobotOption " << SEND_ROTATION_REACHED << " " << 1 << endl;
	for(;;sleep(1))
	{
      		if( exit_robot ) 
        	{
          
          	return(EXIT_SUCCESS);
       		}
    	}
  	return(EXIT_SUCCESS);
}

