#!/usr/bin/php
<?php

/*
Robot: patroller
Autor: jjguti/Linuca (AJ30)
Description: a robot that patrols a zone and shoots anyone mwahaha
Needs: php-cli to run
*/

error_reporting(0);
$name='jjguti';
$color='ff0000';
$color_away='00ff00';

global $shoot;
$shoot=-1;

define('DEBUG',0);

define('ROBOT',1);
define('CANNON',2);
define('RADAR',4);

define('OBJ_ROBOT',0);
define('OBJ_SHOT',1);
define('OBJ_WALL',2);
define('OBJ_COOKIE',3);
define('OBJ_MINE',4);



function initialize()
{
  echo "RobotOption 3 0\n";

  $matches=0;
  while($line_read=fgets(STDIN))
    if(preg_match('/^Initialize (\d)/',$line_read,$matches))
      break;

  if($matches[1]==1)
    return true;
  else
    return false;
}

function process_message($message,$params)
{
  global $shoot;
  if(DEBUG>0) echo "Print $message  --> ".implode($params,' ')."\n";
  switch($message)
  {
    case 'Radar':
      switch($params[1])
      {
        case OBJ_WALL:case OBJ_SHOT:
//          send_message('Break',1.0);
          //if($params[1]===OBJ_SHOT||$params[2]<6)
            send_message('RotateAmount',array(ROBOT,2,-($params[2]*1.1)));break;
        case OBJ_MINE:
          if($shoot<0) send_message('Shoot',0.5);$shoot=10;break;
        case OBJ_COOKIE:
          //send_message('RotateAmount',array(ROBOT,2,$params[2]*1.2));break;
          //send_message('Accelerate',10);break;
          break;
        case OBJ_ROBOT:
          if($params[0]<20/*&&$shoot<0*/)
            send_message('Shoot',5);$shoot=1;
      }
      break;
    case 'ExitRobot': exit('Print Exiting!!');
  }
  $shoot--;
}

function wait_for_message($message)
{
  while(strpos($message,fgets(STDIN))!==false){};
}

function send_message($message,$params)
{
  $message_string='';
  switch($message)
  {
    default:
      if(!is_array($params))
        $message_string="$message $params";
      else
        $message_string="$message ".implode($params,' ');
  }
  echo "$message_string\n";
  if(DEBUG>0) echo "Print $message_string\n";

}


if(initialize())
{
  send_message('Name',$name);
  send_message('Color',array($color,$color_away));
}
sleep(2);
wait_for_message("GameStarts\n");

while(1)
{
  send_message('Accelerate',3);
  send_message('Sweep',array(CANNON+RADAR,5,0.5,5.9));
  if(rand(0,20)>18)
    send_message('Break',0.5);
  /*if(rand(0,50)>38)
    send_message('RotateAmount',array(CANNON|ROBOT,2,rand(0,628)/10));*/
  $line_read=fgets(STDIN);
  $message=array();
  if(preg_match('/^(\w+)\s*(.*)/',$line_read,$message))
    process_message($message[1],explode(' ',$message[2]));
}
?>
