#include "gwilgen.h"

// Radar info when no object is seen, should never happen.
void
Gwilgen::radar_noobject( const double dist, const double angle )
{
}

// Radar info when robot is seen.
// Lock cannon and radar on the seen robot,
// and if it is near enough, begin to brake. Shoot at it.
void
Gwilgen::radar_robot( const double dist, const double angle )
{
  rotate(1,PI-PIdiv4/angle);
  accelerate(0);
  brake(1);

  //Check out the last time we the bot
  timeval current_time;
  gettimeofday(&current_time, NULL);
  long actual_time = current_time.tv_usec/1000;
  long dTime = actual_time - last_seen_robot_time;

  if (dist<12 && dTime < 100 && dTime > 0)
  {//Close enough for us, shoot!
    if ((angle - last_seen_robot_angle) < 0.1)  shoot(30);
    else shoot(20); //He is moving too fast...
  }else shoot(10); //Just in case we hit him

  //Update db
  last_seen_robot_time = actual_time;
  last_seen_robot_angle2 = last_seen_robot_angle;
  last_seen_robot_angle = angle;
  rotate(1,0);
}

// Radar info when a shot is seen.
void
Gwilgen::radar_shot( const double dist, const double angle )
{
  //Check out the last time we the bot
  timeval current_time;
  gettimeofday(&current_time, NULL);
  long actual_time = current_time.tv_usec/1000;
  long dTime = actual_time - last_seen_robot_time;

  if (dTime > 100 || dTime < 0)
  {//We don't know where is the bot, think about flee...
//    cerr << "Where is the bot?!" << endl;
    //Check out the last time we saw the shot
    dTime = actual_time - last_seen_shot_time;
  
    if (dTime < 100 && dTime > 0 && ((angle - last_seen_shot_angle) < 0.15) && (dist < last_seen_shot_distance))
    {//if is focusing us, we move
      brake(0);
      accelerate(robot_max_acceleration);
  
      //But we cannot leave the bot accelerating without control
      sleep(1); //Wait until the bot is far enough
      accelerate(0); //Stop
      brake(1);
  
      if (actual_time - last_rotation_change_time > 1000)
      {//We haven't change the sense of the rotation recently, change is healthy!
        //As we have lost the focus, begin to rotate again
        brake(0);
        rotate(1,robot_rotate); //Change the rotation 
        last_rotation_change_time = actual_time;
      }else rotate(1,-robot_rotate);
    }
  }

  //Update db
  last_seen_shot_time = actual_time;
  last_seen_shot_distance = dist;
  last_seen_shot_angle = angle;
}

// Radar info when a wall is seen.
// If a wall is near in the robot direction, begin to brake,
// else have normal acceleration.
void
Gwilgen::radar_wall( const double dist, const double angle )
{
  if (dist<5)
  {//Brake down!!
    accelerate(0);
    brake(1);
    flag_wall_close = true;
  }else flag_wall_close = false;

  //Check out the last time we the bot
  timeval current_time;
  gettimeofday(&current_time, NULL);
  long actual_time = current_time.tv_usec/1000;
  if (abs(actual_time - last_seen_robot_time) > 300)
  {//Oops, we lost the focus!
    brake(0);
    rotate(1,robot_rotate=(((last_seen_robot_angle - last_seen_robot_angle2)>0)?-1:1));
  }
}

// Radar info when a cookie is seen.
void
Gwilgen::radar_cookie( const double dist, const double angle )
{
  rotate(1,PI*dist/angle); //Focus the cookie
  brake(0);
  accelerate(3*dist/8);
  sleep(1);
  accelerate(dist/16);
  sleep(1);
  accelerate(0);
}

// Radar info when a mine is seen.
void
Gwilgen::radar_mine( const double dist, const double angle )
{
  shoot(1);
}


