#include "gwilgen.h"
// Information about the position of the robot. Coordinates are given either absolute,
// relative to the starting position, or not at all, depending on the option
// SEND_ROBOT_COORDINATES.
void
Gwilgen::coordinates( const double x, const double y, const double rotation)
{
  if( send_robot_coordinates == 0 )
    return;

  current_x_coordinate = x;
  current_y_coordinate = y;
  current_robot_angle = rotation;
}

// Get information about time, speed and cannon_angle
// Update current time and check how long time has passed since
// we were last hit by a shot.
void
Gwilgen::info( const double time, const double speed,
                     const double cannon_angle )
{
  current_time = time;

  if( current_time - last_shot_hit_time > 2.0 )
    shots_hit = 0;
}

// Information about seen robots
void
Gwilgen::robot_info( const double energy, int enemy )
{
}

// This function is called before checking messages.
// Every hundred time, change the direction of the rotation.
void
Gwilgen::pre_checking_messages()
{
/*  if(rand() < (RAND_MAX/200) && rotate_allowed )
    {
      robot_rotate = -robot_rotate;
      rotate( 1, robot_rotate );
      if( debug_level >= 2 )
        cout << "Debug " << _("New") << " robot_rotate : " << robot_rotate << endl;
    }*/
}

// Our energy level.
void
Gwilgen::energy( const double energylevel )
{
}

// How many robots is left in the game.
void
Gwilgen::robots_left( const int number_of_robots )
{
  number_of_robots_left = number_of_robots;
}

