#include "gwilgen.h"


Gwilgen::~Gwilgen()
{
  delete [] robot_name;
  delete [] robot_colour;
}

// Function for sending messages from robot. 
// They do nothing but write the command and its arguments to cout.
void
Gwilgen::robot_option( const int option, const int value )
{
  cout << "RobotOption " << option << " " << value << endl;
}

void
Gwilgen::name( const char* name )
{
  cout << "Name " << name << endl;
}

void
Gwilgen::colour( const char* home, const char* away )
{
  cout << "Colour " << home << " " << away << endl;
}

void
Gwilgen::rotate( const int what, const double vel )
{
  cout << "Rotate " << what << " " << vel << endl;
}

void
Gwilgen::rotate_to( const int what, const double vel,
                          const double angle )
{
  cout << "RotateTo " << what << " " << vel << " " << angle << endl;
}

void
Gwilgen::rotate_amount( const int what, const double vel,
                              const double angle )
{
  cout << "RotateAmount " << what << " " << vel << " " << angle << endl;
}

void
Gwilgen::sweep( const int what, const double vel,
                      const double left, const double right )
{
  cout << "Sweep " << what << " " << vel << " "
       << left << " " << right << endl;
}

void
Gwilgen::accelerate( const double amount )
{
  cout << "Accelerate " << amount << endl;
//   cerr << "Acelerando " << amount << endl;
}

void
Gwilgen::brake( const double amount )
{
  cout << "Brake " << amount << endl;
}

void
Gwilgen::shoot( const double energy )
{
  cout << "Shoot " << energy << endl;
}

void
Gwilgen::print( const char* message )
{
  cout << "Print " << message << endl;
}

void
Gwilgen::debug( const char* message )
{
  cout << "Debug " << message << endl;
}

void
Gwilgen::debug_line( const double start_angle,
                           const double start_radius,
                           const double end_angle,
                           const double end_radius )
{
  cout << "DebugLine " << start_angle << " " << start_radius
       << " " << end_angle << " " << end_radius << endl;
}

void
Gwilgen::debug_circle( const double center_angle,
                             const double center_radius,
                             const double circle_radius )
{
  cout << "DebugCircle " << center_angle << " " << center_radius 
       << " " << circle_radius << endl;
}

// Here are all functions that is called whenever a message of
// corresponding type is recieved.

// Send name and colour if it is the first sequence.
void
Gwilgen::initialize( const int first_seq )
{
  if( first_seq == 1 )
    {
      name( robot_name );
      colour( robot_colour, robot_colour );
    }
}

// The name the robot got in the game.
void
Gwilgen::your_name( const char* prev_name )
{
}

// The colour the robot got in the game.
void
Gwilgen::your_colour( const char* colour )
{
}

// This function is called when a game option is changed and
// the robot's copy of this option will change.
void
Gwilgen::game_option( const int option, const double value )
{
  switch( option )
    {
    case ROBOT_MAX_ROTATE: // cerr << "ROBOT_MAX_ROTATE: " << value << endl;
      robot_max_rotate = value;
      break;
    case ROBOT_CANNON_MAX_ROTATE: // cerr << "ROBOT_CANNON_MAX_ROTATE: " << value << endl;
      robot_cannon_max_rotate = value;
      break;
    case ROBOT_RADAR_MAX_ROTATE: // cerr << "ROBOT_RADAR_MAX_ROTATE: " << value << endl;
      robot_radar_max_rotate = value;
      break;
    case ROBOT_MAX_ACCELERATION: // cerr << "ROBOT_MAX_ACCELERATION: " << value << endl;
      robot_max_acceleration = value;
      break;
    case ROBOT_MIN_ACCELERATION: // cerr << "ROBOT_MIN_ACCELERATION: " << value << endl;
      robot_min_acceleration = value;
      break;
    case ROBOT_START_ENERGY: // cerr << "ROBOT_START_ENERGY: " << value << endl;
      robot_start_energy = value;
      break;
    case ROBOT_MAX_ENERGY: // cerr << "ROBOT_MAX_ENERGY: " << value << endl;
      robot_max_energy = value;
      break;
    case ROBOT_ENERGY_LEVELS: // cerr << "ROBOT_ENERGY_LEVELS: " << value << endl;
      robot_energy_levels = value;
      break;
    case SHOT_SPEED: // cerr << "SHOT_SPEED: " << value << endl;
      shot_speed = value;
      break;
    case SHOT_MIN_ENERGY: // cerr << "SHOT_MIN_ENERGY: " << value << endl;
      shot_min_energy = value;
      break;
    case SHOT_MAX_ENERGY: // cerr << "SHOT_MAX_ENERGY: " << value << endl;
      shot_max_energy = value;
      break;
    case SHOT_ENERGY_INCREASE_SPEED: // cerr << "SHOT_ENERGY_INCREASE_SPEED: " << value << endl;
      shot_energy_increase_speed = value;
      break;
    case TIMEOUT: // cerr << "    case TIMEOUT: " << value << endl;
      timeout = value;
      break;
    case DEBUG_LEVEL: // cerr << "    case DEBUG_LEVEL: " << value << endl;
      debug_level = value;
      break;
    case SEND_ROBOT_COORDINATES: // cerr << "    case SEND_ROBOT_COORDINATES: " << value << endl;
      send_robot_coordinates = (int)rint(value);
      break;
    }
}

// We have received a warning message.
// Print the message.
void
Gwilgen::warning( const int type, const char* message )
{
  char full_message[200];

  switch( type )
    {
    case UNKNOWN_MESSAGE:
      strcpy( full_message, _("Unknown message: ") );
      break;
    case PROCESS_TIME_LOW:
      strcpy( full_message, _("Process time low: ") );
      break;
    case MESSAGE_SENT_IN_ILLEGAL_STATE:
      strcpy( full_message, _("Message sent in illegal state: ") );
      break;
    case UNKNOWN_OPTION:
      strcpy( full_message, _("Unknown option: ") );
      break;
    case OBSOLETE_KEYWORD:
      strcpy( full_message, _("Obsolete Keyword: ") );
      break;
    }

  strcat( full_message, message );
  print( full_message );
}

// Unfortunately we have died.
void
Gwilgen::dead()
{
}

// The game has finished
void
Gwilgen::game_finishes()
{
}

// You have been ordered to exit the robot
void
Gwilgen::exit_robot()
{
  print( _("Shutting down and leaving") );
  quitting = true;
}

// This function handles all the message checking and
// calls the appropriate function.
// This function is called whenever a SIGUSR1 (decided in the
// robotoption sent to the server) signal is received.
void
Gwilgen::check_messages( )
{
  quitting = false;

  char msg_name[81];
  message_to_robot_type msg_t;

  cin.clear();
  while( !cin.eof() && !quitting )
    {
      pre_checking_messages();

      cin >> msg_name;
      msg_t = name2msg_to_robot_type(msg_name);

      switch(msg_t)
        {
        case INITIALIZE:
          {
            int init;
            cin >> init;
            initialize( init );
          }
          break;
        case YOUR_NAME:
          {
            char name[81];
            cin >> name;
            your_name( name );
          }
          break;
        case YOUR_COLOUR:
          {
            char col[81];
            cin >> col;
            your_colour( col );
          }
          break;
        case GAME_OPTION:
          {
            int nr;
            double value;
            cin >> nr >> value;
            game_option( nr, value );
          }
          break;
        case GAME_STARTS:
          game_starts();
          break;
        case RADAR:
          {
            double dist, angle;
            int object;

            cin >> dist >> object >> angle;
            switch(object)
              {
              case NOOBJECT:
                radar_noobject( dist, angle );
                break;
              case ROBOT:
                radar_robot( dist, angle );
                break;
              case WALL:
                radar_wall( dist, angle );
                break;
              case SHOT:
                radar_shot( dist, angle );
                break;
              case COOKIE:
                radar_cookie( dist, angle );
                break;
              case MINE:
                radar_mine( dist, angle );
                break;
              default:
                cout << "Print" << _("Unknown Object seen!") << endl;
                break;
              }
          }
          break;
        case COORDINATES:
          {
            double x, y, rotation;
            cin >> x >> y >> rotation;
            coordinates( x, y, rotation );
          }
          break;
        case INFO:
          {
            double time, speed, cannon_angle;
            cin >> time >> speed >> cannon_angle;
            info( time, speed, cannon_angle );
          }
          break;
        case ROBOT_INFO:
          {
            double energy;
            int enemy;
            cin >> energy >> enemy;
            robot_info( energy, enemy );
          }
          break;
        case ROTATION_REACHED:
          {
            int what;
            cin >> what;
            rotation_reached( what );
          }
          break;
        case ENERGY:
          {
            double en;
            cin >> en;
            energy( en );
          }
          break;
        case ROBOTS_LEFT:
          {
            int nr;
            cin >> nr;
            robots_left( nr );
          }
          break;
        case COLLISION:
          {
            int object;
            double angle;

            cin >> object >> angle;
            switch( object )
              {
              case NOOBJECT:
                collision_noobject( angle );
                break;
              case ROBOT:
                collision_robot( angle );
                break;
              case WALL:
                collision_wall( angle );
                break;
              case SHOT:
                collision_shot( angle );
                break;
              case COOKIE:
                collision_cookie( angle );
                break;
              case MINE:
                collision_mine( angle );
                break;
              default:
                cout << "Print " << _("Collided with Unknown Object!") << endl;
                break;
              }
          }
          break;
        case WARNING:
          {
            int type;
            char text[81];
            cin >> type;
            cin.getline(text,80,'\n');
            warning( type, text );
          }
          break;
        case DEAD:
          dead();
          break;
        case GAME_FINISHES:
          game_finishes();
          break;
        case EXIT_ROBOT:
          exit_robot();
          break;
        default:
          break;
        }
    }
}

// A function to convert the messagename to an enum message_to_robot_type
message_to_robot_type
name2msg_to_robot_type(char* msg_name)
{
  for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
      if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
        return (message_to_robot_type)i;
    }
  return UNKNOWN_MESSAGE_TO_ROBOT;
}
