#include "gwilgen.h"

// We have collided with no object. Should not happen.
void
Gwilgen::collision_noobject( const double angle )
{
}

// We have collided with another robot.
void
Gwilgen::collision_robot( const double angle )
{
}

// We have collided with a shot.
// Set last_shot_hit_time and increase shots_hit.
// If shots_hit is too high, begin fleeing acceleration and rotation.

void
Gwilgen::collision_shot( const double angle )
{//D'oh!
  timeval current_time;
  gettimeofday(&current_time, NULL);
  long actual_time = current_time.tv_usec/1000;
  long dTime = actual_time - last_received_shot_time;
//  cerr << "collision_shot dTime: " << dTime << endl;
  if ((dTime < 100) && (dTime>0))
  {//They are shooting us!
    brake(0);
    if (!flag_wall_close)
      rotate(1,PIdiv4); //We have a wall near, we should rotate to dodge it
    accelerate(robot_max_acceleration);
    sleep(1);
    accelerate(0); //Stop
    brake(1);
  }
  last_received_shot_time = actual_time;
}

// We have collided with a wall.
void
Gwilgen::collision_wall( const double angle )
{//If we crash directly we turn a lot, if not, just a little
  rotate(1,robot_rotate*angle);

  sleep(1);
  checkRotation();
}

// We have collided with a cookie.
void
Gwilgen::collision_cookie( const double angle )
{
  print( _("Cookie eaten!") );

  //Brake down!!
  accelerate(0);
  brake(1);

  sleep(1);
  //Seek the enemy again
  brake(0);
  rotate(1,robot_rotate);
}

// We have collided with a mine.
void
Gwilgen::collision_mine( const double angle )
{
  print( _("Oh no! A mine") );
}

