#include "gwilgen.h"
Gwilgen::Gwilgen(const char* name, const char* colour)
{
  robot_name = new char[strlen(name) + 1];
  strcpy(robot_name, name);

  robot_colour = new char[strlen(colour) + 1];
  strcpy(robot_colour, colour);

  quitting = false;

  robot_rotate = 0.5;
  acceleration = 0.5;
  brake_value = 0.0;

   robot_cannon_max_rotate = 1.5;//We suppose a maximum, for being able to move before we now the real value
//   robot_radar_max_rotate;
//   robot_max_acceleration;
//   robot_min_acceleration;
//   robot_start_energy;
//   robot_max_energy;
//   robot_energy_levels;
//   shot_speed;
//   shot_min_energy;
//   shot_max_energy;
//   shot_energy_increase_speed;


  // Get random seed from the clock
  //timeval current_time;
  //gettimeofday(&current_time, NULL);
  //srand(current_time.tv_usec);

  // We want to know when RotateTo and RotateAmount finishes
  robot_option( SEND_ROTATION_REACHED, 1 );
}

// Reset the robot when a new game starts. Send initial rotate and
// accelerate commands.
void
Gwilgen::game_starts()
{
  robot_rotate = 0.7;
  acceleration = 0.54;
  brake_value = 0.0;

  rotate_allowed = true;
  shots_hit = 0;
  last_shot_hit_time = -2.0;
  current_time = 0;

  accelerate(0);
  rotate(1,0);
  brake(0);

  robot_acceleration = 0.1;
  last_seen_robot_angle = 0;
  last_seen_shot_angle = PI;
  last_seen_robot_time = 0;
  last_seen_shot_time = 0;
  last_rotation_change_time = 65535;
  last_seen_shot_distance = 0;
  flag_wall_close = false;
  last_received_shot_time = 0;
  last_rotation_check_time = 65535;
/*  radar_and_cannon_rotate =
    robot_cannon_max_rotate - fabs(robot_rotate) - robot_rotate;
  rotate( 1, robot_rotate );
  rotate( 6, radar_and_cannon_rotate );
  accelerate( acceleration );*/
  //Rotate at max speed to get the alfa position

  rotate_amount(6,robot_cannon_max_rotate,PIdiv2); //The cannon is the slowest between cannon and radar
}

void Gwilgen::checkRotation()
{//Just in case...
  timeval current_time;
  gettimeofday(&current_time, NULL);
  long actual_time = current_time.tv_usec/1000;
  long dTime = actual_time - last_rotation_check_time;

//  cerr << "Checking rotation : " << dTime << endl;
  if ((actual_time - last_rotation_check_time)<0)
  {//Time to move
    brake(0);
    accelerate(0);
    rotate(1,robot_rotate);
  }
  last_rotation_check_time = actual_time;
}

// Check if rotation has been reached.
// If it is the robot. Begin normal acceleration and rotation
void
Gwilgen::rotation_reached( const int what )
{
  rotate(1,robot_rotate);
}

