#include <signal.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#ifdef TIME_WITH_SYS_TIME 
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef HAVE_LOCALE_H
# include <locale.h>
#endif

#include "./Messagetypes.h"

namespace std { }
using namespace std;

const int O_RADAR = 4;
const int O_CANYON = 2;
const int O_ROBOT = 1;

  double robot_max_rotate;
  double robot_cannon_max_rotate;
  double robot_radar_max_rotate;
  double robot_max_acceleration;
  double robot_min_acceleration;
  double robot_start_energy;
  double robot_max_energy;
  double robot_energy_levels;
  double shot_speed;
  double shot_min_energy;
  double shot_max_energy;
  double shot_energy_increase_speed;
  double timeout;
  double debug_level;
  int send_robot_coordinates;
  int comienzo;   
  int process_time_low;
  double distancia_lejos;
  int disparos_pendientes;
  int num_tics_radar_perdido;
	int estadisticas_radar_robot;
	int estadisticas_radar_total;
	int estadisticas_radar_perdido;
  double factor_apertura_disparo;
  double ultima_distancia;  

double dif_angulo;  
double dif_distancia; 

double distancia_esperada;  
typedef enum t_modo {BUSCANDO, CERCA, LEJOS};
typedef enum t_estado_radar {BLANCO_POS, BLANCO_NEG, AGUA_POS, AGUA_NEG};

typedef enum t_estrategia {NORMAL, MINA, CIEGO};


typedef struct t_instante {

	t_modo modo;
	t_estrategia estrategia;
	t_estado_radar estado_radar;
	double aceleracion;
	double freno;
	double energia;
	double energia_enemigo; 
	double disparo; 
	object_type colision_objeto;
	double colision_angulo;

	double tiempo;
	double velocidad;
	double angulo_canyon;
	double energia_propia; 
	object_type rad_objeto;
	double rad_distancia;
	double rad_angulo;
};


const int tam_tiempo = 15;	
t_instante * tiempo[tam_tiempo];


typedef struct t_pasada {
	int tics;
	int robots;
	double probabilidad;	
	double angulo;
	double distancia;
	double tiempo;
};

const int max_pasadas = 500;
int ultima_pasada;
t_pasada pasada[max_pasadas];


typedef struct t_futuro {
	double tiempo;
	double angulo;
	double distancia;
	double probabilidad;	
};

const int tam_futuro = 80;
int presente;   
t_futuro futuro[tam_futuro];






class Robot 
{
public:	


Robot(const char* name, const char* colour)
{
  robot_name = new char[strlen(name) + 1];
  strcpy(robot_name, name);

  robot_colour = new char[strlen(colour) + 1];
  strcpy(robot_colour, colour);

  quitting = false;

  robot_rotate = 0.53;
  acceleration = 0.54;
  brake_value = 0.0;

  robot_option( SEND_ROTATION_REACHED, 1 );
}




~Robot()
{
  delete [] robot_name;
  delete [] robot_colour;
}




message_to_robot_type name2msg_to_robot_type(char* msg_name)
{
  for(int i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
      if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
        return (message_to_robot_type)i;
    }
  return UNKNOWN_MESSAGE_TO_ROBOT;
}

void robot_option( const int option, const int value )
{
  cout << "RobotOption " << option << " " << value << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT RobotOption " << option << " " << value << endl;
}

void name( const char* name )
{
  cout << "Name " << name << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT Name " << name << endl;
}

void colour( const char* home, const char* away )
{
  cout << "Colour " << home << " " << away << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT Colour " << home << " " << away << endl;
}

void rotate( const int what, const double vel )
{
  cout << "Rotate " << what << " " << vel << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT Rotate " << what << " " << vel << endl;
}

void rotate_to( const int what, const double vel,
                          const double angle )
{
  cout << "RotateTo " << what << " " << vel << " " << angle << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT RotateTo " << what << " " << vel << " " << angle << endl;
}

void rotate_amount( const int what, const double vel,
                              const double angle )
{
  cout << "RotateAmount " << what << " " << vel << " " << angle << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT RotateAmount " << what << " " << vel << " " << angle << endl;
}

void sweep( const int what, const double vel,
                      const double left, const double right )
{
  cout << "Sweep " << what << " " << vel << " " << left << " " << right << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT Sweep " << what << " " << vel << " "  << left << " " << right << endl;
}

void accelerate( const double amount )
{
  cout << "Accelerate " << amount << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT Accelerate " << amount << endl;
}

void brake( const double amount )
{
  cout << "Brake " << amount << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT Brake " << amount << endl;
}

void shoot( const double energy )
{
  cout << "Shoot " << energy << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT Shoot " << energy << endl;
}

void print( const char* message )
{
  cout << "Print " << message << endl;
}

void debug( const char* message )
{
  cout << "Debug " << message << endl;
}

void debug_line( const double start_angle,
                           const double start_radius,
                           const double end_angle,
                           const double end_radius )
{
  cout << "DebugLine " << start_angle << " " << start_radius
       << " " << end_angle << " " << end_radius << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT DebugLine " << start_angle << " " << start_radius
      << " " << end_angle << " " << end_radius << endl;

}

void debug_circle( const double center_angle,
                             const double center_radius,
                             const double circle_radius )
{
  cout << "DebugCircle " << center_angle << " " << center_radius 
       << " " << circle_radius << endl;
  if ( debug_level >= 3 ) cout << "Debug OUT DebugCircle " << center_angle << " " << center_radius 
      << " " << circle_radius << endl;

}








void your_name( const char* prev_name )
{
  if ( debug_level >= 3 ) cout << "Debug IN your_name" << prev_name << endl;
}
// The colour the robot got in the game.
void your_colour( const char* colour )
{
	if ( debug_level >= 3 ) cout << "Debug IN your_colour" << colour << endl;
}
// This function is called when a game option is changed and
// the robot's copy of this option will change.
void game_option( const int option, const double value )
{
  switch( option )
    {
    case ROBOT_MAX_ROTATE:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION ROBOT_MAX_ROTATE " << value << endl;
      robot_max_rotate = value;
      break;
    case ROBOT_CANNON_MAX_ROTATE:
      if ( debug_level >= 3 ) cout << "Debug IN ROBOT_CANNON_MAX_ROTATE " << value << endl;
      robot_cannon_max_rotate = value;
      break;
    case ROBOT_RADAR_MAX_ROTATE:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION ROBOT_RADAR_MAX_ROTATE " << value << endl;
      robot_radar_max_rotate = value;
      break;
    case ROBOT_MAX_ACCELERATION:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION ROBOT_MAX_ACCELERATION " << value << endl;
      robot_max_acceleration = value;
      break;
    case ROBOT_MIN_ACCELERATION:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION ROBOT_MIN_ACCELERATION " << value << endl;
      robot_min_acceleration = value;
      break;
    case ROBOT_START_ENERGY:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION ROBOT_START_ENERGY " << value << endl;
      robot_start_energy = value;
      break;
    case ROBOT_MAX_ENERGY:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION ROBOT_MAX_ENERGY " << value << endl;
      robot_max_energy = value;
      break;
    case ROBOT_ENERGY_LEVELS:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION ROBOT_ENERGY_LEVELS " << value << endl;
      robot_energy_levels = value;
      break;
    case SHOT_SPEED:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION SHOT_SPEED " << value << endl;
      shot_speed = value;
      break;
    case SHOT_MIN_ENERGY:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION SHOT_MIN_ENERGY " << value << endl;
      shot_min_energy = value;
      break;
    case SHOT_MAX_ENERGY:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION SHOT_MAX_ENERGY " << value << endl;
      shot_max_energy = value;
      break;
    case SHOT_ENERGY_INCREASE_SPEED:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION SHOT_ENERGY_INCREASE_SPEED " << value << endl;
      shot_energy_increase_speed = value;
      break;
    case TIMEOUT:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION TIMEOUT " << value << endl;
      timeout = value;
      break;
    case DEBUG_LEVEL:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION DEBUG_LEVEL " << value << endl;
//      debug_level = value;
      break;
    case SEND_ROBOT_COORDINATES:
      if ( debug_level >= 3 ) cout << "Debug IN GAME_OPTION SEND_ROBOT_COORDINATES " << value << endl;
      send_robot_coordinates = (int)rint(value);
      break;
    }
}




// Send name and colour if it is the first sequence.
void initialize( const int first_seq )
{
  if ( debug_level >= 3 ) cout << "Debug IN INITIALIZE " << first_seq << endl;	
  if( first_seq == 1 )
    {
      name( robot_name );
      colour( robot_colour, robot_colour );
    }
}




// Reset the robot when a new game starts. Send initial rotate and
// accelerate commands.
void game_starts()
{
	if ( debug_level >= 3 ) cout << "Debug IN GAME_STARTS " << endl;	

}

// Radar info when no object is seen, should never happen.
void radar_noobject( const double dist, const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN RADAR NOOBJECT " << dist << " " << angle << endl;
	tiempo[0]->rad_objeto = NOOBJECT;
	tiempo[0]->rad_distancia = dist;
	tiempo[0]->rad_angulo = angle;

}




void radar_robot( const double dist, const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN RADAR ROBOT " << dist << " " << angle << endl;
	tiempo[0]->rad_objeto = ROBOT;
	tiempo[0]->rad_distancia = dist;
	tiempo[0]->rad_angulo = angle;
	
	ultima_distancia = dist;
	angulo_enemigo = angle;
}




// Radar info when a shot is seen.
void radar_shot( const double dist, const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN RADAR SHOT " << dist << " " << angle << endl;
	tiempo[0]->rad_objeto = SHOT;
	tiempo[0]->rad_distancia = dist;
	tiempo[0]->rad_angulo = angle;


}




void radar_wall( const double dist, const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN RADAR WALL " << dist << " " << angle << endl;
	tiempo[0]->rad_objeto = WALL;
	tiempo[0]->rad_distancia = dist;
	tiempo[0]->rad_angulo = angle;


}




// Radar info when a cookie is seen.
void radar_cookie( const double dist, const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN RADAR COOKIE " << dist << " " << angle << endl;
	tiempo[0]->rad_objeto = COOKIE;
	tiempo[0]->rad_distancia = dist;
	tiempo[0]->rad_angulo = angle;


	// Destruimos todas las cookies y las minas
	if (tiempo[0]->estrategia != MINA) {
		tiempo[0]->estrategia = MINA;
		rotate_to (O_CANYON, robot_cannon_max_rotate, tiempo[0]->rad_angulo);
	 	if ( debug_level >= 2 ) debug ("-- S:Estrategia MINA");
	}


}


 

// Radar info when a mine is seen.
void radar_mine( const double dist, const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN RADAR MINE " << dist << " " << angle << endl;
	tiempo[0]->rad_objeto = MINE;
	tiempo[0]->rad_distancia = dist;
	tiempo[0]->rad_angulo = angle;

	// Destruimos todas las cookies y las minas
	if (tiempo[0]->estrategia != MINA) {
		tiempo[0]->estrategia = MINA;
	 	if ( debug_level >= 2 ) debug ("-- S:Estrategia MINA");
		rotate_to (O_CANYON, robot_cannon_max_rotate, tiempo[0]->rad_angulo);
	}

}




// Information about the position of the robot. Coordinates are given either absolute,
// relative to the starting position, or not at all, depending on the option
// SEND_ROBOT_COORDINATES.
void coordinates( const double x, const double y, const double rotation)
{
	if ( debug_level >= 3 ) cout << "Debug IN COORDINATES " << x << " " << y << " " << rotation << endl;
  if( send_robot_coordinates == 0 )
    return;

  current_x_coordinate = x;
  current_y_coordinate = y;
  current_robot_angle = rotation;
}




// Get information about time, speed and cannon_angle
// Update current time and check how long time has passed since
// we were last hit by a shot.
void info( const double time, const double speed,
                     const double cannon_angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN INFO " << time << " " << speed << " " << cannon_angle << endl;
	char texto [50];


	// Fijamos el tiempo en el instante actual
	tiempo[0]->tiempo = time;
	tiempo[0]->velocidad = speed;
	tiempo[0]->angulo_canyon = cannon_angle;
	

}




// Information about seen robots
void robot_info( const double energy, int enemy )
{
	if ( debug_level >= 3 ) cout << "Debug IN ROBOT_INFO " << energy << " " << enemy << endl;
}




// Check if rotation has been reached.
// If it is the robot. Begin normal acceleration and rotation
void rotation_reached( const int what )
{
	if ( debug_level >= 3 ) cout << "Debug IN ROTATION_REACHED " << what << endl;

	if (tiempo[0]->estrategia == MINA) {
		tiempo[0]->estrategia = NORMAL;
	 	if ( debug_level >= 2 ) debug ("-- S:Estrategia NORMAL");
		shoot (shot_min_energy);
	}
	
	if (tiempo[0]->estrategia == CIEGO) {
		tiempo[0]->estrategia = NORMAL;
	 	if ( debug_level >= 2 ) debug ("-- S:Estrategia NORMAL");
		shoot (shot_max_energy);
		disparos_pendientes = 30;
	}

}




// Our energy level.
void energy( const double energylevel )
{
	if ( debug_level >= 3 ) cout << "Debug IN ENERGY " << energylevel << endl;
	tiempo[0]->energia_propia = energylevel;
}




// How many robots is left in the game.
void robots_left( const int number_of_robots )
{
	if ( debug_level >= 3 ) cout << "Debug IN ROBOTS_LEFT " << number_of_robots << endl;
  number_of_robots_left = number_of_robots;
}




// We have collided with no object. Should not happen.
void collision_noobject( const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN COLLISION NOOBJECT " << angle << endl;
}




// We have collided with another robot.
void collision_robot( const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN COLLISION ROBOT" << angle << endl;
}




// We have collided with a shot.
// Set last_shot_hit_time and increase shots_hit.
// If shots_hit is too high, begin fleeing acceleration and rotation.
void collision_shot( const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN COLLISION SHOT " << angle << endl;
	
}




// We have collided with a wall.
void collision_wall( const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN COLLISION WALL " << angle << endl;
	
}




// We have collided with a cookie.
void collision_cookie( const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN COLLISION COOKIE" << angle << endl;

  print( ("am!") );
}




// We have collided with a mine.
void collision_mine( const double angle )
{
	if ( debug_level >= 3 ) cout << "Debug IN COLLISION MINE " << angle << endl;
  print( ("Ay!") );
}




// We have received a warning message.
// Print the message.
void warning( const int type, const char* message )
{
  char full_message[200];

  switch( type )
    {
    case UNKNOWN_MESSAGE:
      strcpy( full_message, ("Unknown message: ") );
      break;
    case PROCESS_TIME_LOW:
      strcpy( full_message, ("Process time low: ") );
      process_time_low = 1;
      break;
    case MESSAGE_SENT_IN_ILLEGAL_STATE:
      strcpy( full_message, ("Message sent in illegal state: ") );
      break;
    case UNKNOWN_OPTION:
      strcpy( full_message, ("Unknown option: ") );
      break;
    case OBSOLETE_KEYWORD:
      strcpy( full_message, ("Obsolete Keyword: ") );
      break;
    }

  strcat( full_message, message );
  print( full_message );
}




// Unfortunately we have died.
void dead()
{
	if ( debug_level >= 3 ) cout << "Debug IN DEAD" << endl;
	
}




// The game has finished
void game_finishes()
{
	if ( debug_level >= 3 ) cout << "Debug IN GAME_FINISHES" << endl;
}




// You have been ordered to exit the robot
void exit_robot()
{
	double estadistica_robot;
	double estadistica_perdido;

	if ( debug_level >= 3 ) cout << "Debug IN EXIT_ROBOT" << endl;

  print( ("Adios!") );
  estadistica_robot = ((double)estadisticas_radar_robot / (double)estadisticas_radar_total)*100;
  estadistica_perdido = ((double)estadisticas_radar_perdido / (double)estadisticas_radar_total)*100;

  cout << "Debug Estadistica Radar: robot=" << (int)estadistica_robot 
  		<< "%  perdido=" << (int)estadistica_perdido << "%" << endl;
  if (process_time_low) print ("Ocupo mucha CPU");
  quitting = true;
}




// This function is called before checking messages.
// Every hundred time, change the direction of the rotation.
void pre_checking_messages()
{
}




// This function handles all the message checking and
// calls the appropriate function.
// This function is called whenever a SIGUSR1 (decided in the
// robotoption sent to the server) signal is received.
void check_messages( )
{
//	char texto[50];
  quitting = false;

  char msg_name[81];
  message_to_robot_type msg_t;

  cin.clear();
  while( !cin.eof() && !quitting )
    {
      pre_checking_messages();

      cin >> msg_name;
      msg_t = name2msg_to_robot_type(msg_name);

      switch(msg_t)
        {
        case INITIALIZE:
          {
            int init;
            cin >> init;
            initialize( init );
          }
          break;
        case YOUR_NAME:
          {
            char name[81];
            cin >> name;
            your_name( name );
          }
          break;
        case YOUR_COLOUR:
          {
            char col[81];
            cin >> col;
            your_colour( col );
          }
          break;
        case GAME_OPTION:
          {
            int nr;
            double value;
            cin >> nr >> value;
            game_option( nr, value );
          }
          break;
        case GAME_STARTS:
          game_starts();
          break;
        case RADAR:
          {
            double dist, angle;
            int object;

            estadisticas_radar_total++;
            if (tiempo[0]->modo == BUSCANDO) estadisticas_radar_perdido++;
		// En el primer mensaje fijamos 
		//los estados iniciales del robot.
		if (comienzo) {
			comienzo = 0;
			inicio();
		}
            cin >> dist >> object >> angle;

			if( debug_level == 5 ) debug_line (angle, dist, angle, dist-0.5);

            switch(object)
              {
              case NOOBJECT:
                radar_noobject( dist, angle );
                break;
              case ROBOT:
                radar_robot( dist, angle );
                estadisticas_radar_robot++;
                break;
              case WALL:
                radar_wall( dist, angle );
                break;
              case SHOT:
                radar_shot( dist, angle );
                break;
              case COOKIE:
                radar_cookie( dist, angle );
                break;
              case MINE:
                radar_mine( dist, angle );
                break;
              default:
                cout << "Print" << ("Unknown Object seen!") << endl;
                break;
              }
          }
          break;          
        case COORDINATES:
          {
            double x, y, rotation;
            cin >> x >> y >> rotation;
            coordinates( x, y, rotation );
          }
          break;
        case INFO:
          {
            double time, speed, cannon_angle;
            cin >> time >> speed >> cannon_angle;
            info( time, speed, cannon_angle );
          }
          break;
        case ROBOT_INFO:
          {
            double energy;
            int enemy;
            cin >> energy >> enemy;
            robot_info( energy, enemy );
          }
          break;
        case ROTATION_REACHED:
          {
            int what;
            cin >> what;
            rotation_reached( what );
          }
          break;
        case ENERGY:
          {
            double en;
            cin >> en;
            energy( en );
          }
          break;
        case ROBOTS_LEFT:
          {
            int nr;
            cin >> nr;
            robots_left( nr );
          }
          break;
        case COLLISION:
          {
            int object;
            double angle;

            cin >> object >> angle;
            switch( object )
              {
              case NOOBJECT:
                collision_noobject( angle );
                break;
              case ROBOT:
                collision_robot( angle );
                break;
              case WALL:
                collision_wall( angle );
                break;
              case SHOT:
                collision_shot( angle );
                break;
              case COOKIE:
                collision_cookie( angle );
                break;
              case MINE:
                collision_mine( angle );
                break;
              default:
                cout << "Print " << ("Collided with Unknown Object!") << endl;
                break;
              }
          }
          break;
        case WARNING:
          {
            int type;
            char text[81];
            cin >> type;
            cin.getline(text,80,'\n');
            warning( type, text );
          }
          break;
        case DEAD:
          dead();
          break;
        case GAME_FINISHES:
          game_finishes();
          break;
        case EXIT_ROBOT:
          exit_robot();
          break;
        default:
          break;
        }
    }
}

// We have to quit
bool is_quitting () { return quitting; }

void inicio () {
// ESTE ES EL COMIENZO DEL JUEGO. Ponemos los estados iniciales y mandamos las ordenes iniciales.

// Fijamos los estados iniciales
tiempo[0]->estrategia = tiempo[1]->estrategia = NORMAL;
tiempo[0]->estado_radar = tiempo[1]->estado_radar = AGUA_POS;
tiempo[0]->modo = tiempo[1]->modo = BUSCANDO;
// Y las acciones iniciales
rotate (O_RADAR, robot_radar_max_rotate/2);
	
	
}

  // These variables contains the current values of the robot rotation,
  // acceleration and brake.
  double radar_and_cannon_rotate;
  double robot_rotate;
  double acceleration;
  double brake_value;

  // Is set if th robot gets the 'EXIT_ROBOT' message
  bool quitting;

  // The robot name and colour are set in the constructor
  char* robot_name;
  char* robot_colour;

  // Boolean variables to control if it is allowed to change robot
  // rotation and acceleration.
  bool rotate_allowed;
  bool acceleration_change_allowed;

  // Variables that controls how frequent the robot has been hit by shots.
  int shots_hit;
  double last_shot_hit_time;
  int number_of_robots_left;

  // The current time is stored in this variable.
//  double current_time;

  // If we get coordinates, these are stored here.
  double current_x_coordinate;
  double current_y_coordinate;
  double current_robot_angle;
  

   double angulo_enemigo;
}; // Class Robot




class Robot robot("Durkheim", "ff00ff");





void nuevo_instante(){
	// This is called when a new time slice begins
	// Advance an instant in the time array
	t_instante *temp;
	char texto[50];
	int i;

	// Rotamos los tiempos
	temp = tiempo[tam_tiempo - 1];
	for (i=tam_tiempo-1;i>0;i--){
		tiempo[i] = tiempo[i-1];		
	}
	tiempo[0] = temp;
	
	// Ponemos los valores por defecto de tiempo[0]:
	tiempo[0]->modo = tiempo[1]->modo;
	tiempo[0]->estrategia = tiempo[1]->estrategia;
	tiempo[0]->estado_radar = tiempo[1]->estado_radar;
	tiempo[0]->aceleracion = tiempo[1]->aceleracion;
	tiempo[0]->freno = tiempo[1]->freno;
	tiempo[0]->energia_enemigo = tiempo[1]->energia_enemigo;
	tiempo[0]->disparo = 0;
	tiempo[0]->colision_objeto = NOOBJECT;
	tiempo[0]->colision_angulo = 0.0;

}

int pasada_radar(){
	ultima_pasada++;


	if (ultima_pasada == max_pasadas) ultima_pasada = 0;

	int i = 1; // numero de tics de la pasada
	int r = 0; // numero de veces que hemos visto al robot.
	pasada[ultima_pasada].angulo = 0.0;
	pasada[ultima_pasada].distancia = 0.0;
	pasada[ultima_pasada].tiempo = 0.0;
	
	
	while ((i<tam_tiempo) && 
	 ((tiempo[i]->estado_radar == BLANCO_POS) || (tiempo[i]->estado_radar == BLANCO_NEG))){
		if (tiempo[i]->rad_objeto == ROBOT) {
			r++;
			pasada[ultima_pasada].angulo = pasada[ultima_pasada].angulo + tiempo[i]->rad_angulo;
			pasada[ultima_pasada].distancia = pasada[ultima_pasada].distancia + tiempo[i]->rad_distancia;	
			pasada[ultima_pasada].tiempo = pasada[ultima_pasada].tiempo + tiempo[i]->tiempo;
		}
		i++;	
	}
	i--;
	if (r == 0) return i;  // ESTO NO PUEDE SER!!!
	
	pasada[ultima_pasada].tics = i;
	pasada[ultima_pasada].robots = r;
	pasada[ultima_pasada].probabilidad = r/i;	
	// calculamos las medias
	pasada[ultima_pasada].angulo = pasada[ultima_pasada].angulo / r;
	pasada[ultima_pasada].distancia = (pasada[ultima_pasada].distancia / r)+0.4;
	pasada[ultima_pasada].tiempo = pasada[ultima_pasada].tiempo / r;
	
	if ( debug_level >= 2 ) cout << "Debug Pasada " << ultima_pasada << " angulo=" 
	   << pasada[ultima_pasada].angulo << " distancia="<< pasada[ultima_pasada].distancia 
	   << " tiempo=" << pasada[ultima_pasada].tiempo << endl;
	
}

// Aqui miramos todas las variables actuales, los estados pasados, y pensamos que hacemos
void pensar_radar (){
	int i;
	double velocidad_angular;  // la velocidad angular = arco / radio

	// RADAR
	if (tiempo[0]->estado_radar == AGUA_POS) {
		if (tiempo[0]->rad_objeto == ROBOT){
			if (tiempo[0]->estrategia == CIEGO) tiempo[0]->estrategia = NORMAL;

			 tiempo[0]->estado_radar = BLANCO_POS;
			 if ( debug_level >= 2 ) robot.debug ("-- S:Rad AGUA_POS -> BLANCO_POS");
			 velocidad_angular = 3.0 / tiempo[0]->rad_distancia;
			 robot.rotate (O_RADAR, velocidad_angular);
			 if (tiempo[0]->rad_distancia > distancia_lejos) {
			 	tiempo[0]->modo = LEJOS;
			 	if ( debug_level >= 2 ) robot.debug ("-- S:Modo LEJOS");
			 } else {
			 	tiempo[0]->modo = CERCA;
			 	if ( debug_level >= 2 ) robot.debug ("-- S:Modo CERCA");
			 }
			 
		}
	}
	if (tiempo[0]->estado_radar == BLANCO_POS) {
		if (tiempo[0]->rad_objeto == WALL){
			 tiempo[0]->estado_radar = AGUA_NEG;
			 if ( debug_level >= 2 ) robot.debug ("-- S:Rad BLANCO_POS -> AGUA_NEG");
			 velocidad_angular = 3.0 / ultima_distancia;
			 robot.rotate (O_RADAR, - velocidad_angular);
		}
	}
	if (tiempo[0]->estado_radar == AGUA_NEG) {
		if (tiempo[0]->rad_objeto == ROBOT){
			if (tiempo[0]->estrategia == CIEGO) tiempo[0]->estrategia = NORMAL;

			 tiempo[0]->estado_radar = BLANCO_NEG;
			 if ( debug_level >= 2 ) robot.debug ("-- S:Rad AGUA_NEG -> BLANCO_NEG");
			 velocidad_angular = 3.0 / tiempo[0]->rad_distancia;
			 robot.rotate (O_RADAR, - velocidad_angular);
			 if (tiempo[0]->rad_distancia > distancia_lejos) {
			 	tiempo[0]->modo = LEJOS;
			 	if ( debug_level >= 2 ) robot.debug ("-- S:Modo LEJOS");
			 } else {
			 	tiempo[0]->modo = CERCA;
			 	if ( debug_level >= 2 ) robot.debug ("-- S:Modo CERCA");
			 }
		}
	}
	if (tiempo[0]->estado_radar == BLANCO_NEG) {
		if (tiempo[0]->rad_objeto == WALL){
			 tiempo[0]->estado_radar = AGUA_POS;
			 if ( debug_level >= 2 ) robot.debug ("-- S:Rad BLANCO_NEG -> AGUA_POS");
			 velocidad_angular = 3.0 / ultima_distancia;
			 robot.rotate (O_RADAR, velocidad_angular);
		}
	}

	if ((tiempo[0]->modo != BUSCANDO) &&
	   (tiempo[0]->rad_objeto != ROBOT) &&
	   (tiempo[1]->rad_objeto != ROBOT) &&
	   (tiempo[2]->rad_objeto != ROBOT) &&
	   (tiempo[3]->rad_objeto != ROBOT) &&
	   (tiempo[4]->rad_objeto != ROBOT) &&
	   (tiempo[5]->rad_objeto != ROBOT) &&
	   (tiempo[6]->rad_objeto != ROBOT) &&
	   (tiempo[7]->rad_objeto != ROBOT) &&
	   (tiempo[8]->rad_objeto != ROBOT) &&
	   (tiempo[9]->rad_objeto != ROBOT)){
	   	if (tiempo[0]->estado_radar == AGUA_POS) {
		   	tiempo[0]->modo = BUSCANDO;
		 	if ( debug_level >= 2 ) robot.debug ("-- S:Modo BUSCANDO");
			velocidad_angular = 15.0 / ultima_distancia;
			tiempo[0]->estado_radar == AGUA_NEG;
			robot.rotate (O_RADAR, - velocidad_angular);

	   	} else if (tiempo[0]->estado_radar == AGUA_NEG){
		   	tiempo[0]->modo = BUSCANDO;
		 	if ( debug_level >= 2 ) robot.debug ("-- S:Modo BUSCANDO");
			velocidad_angular = 15.0 / ultima_distancia;
			tiempo[0]->estado_radar == AGUA_POS;
			robot.rotate (O_RADAR, velocidad_angular);
	   	}
		
		
	   	ultima_pasada = -1;
	}

	if ((tiempo[0]->estado_radar == AGUA_POS) || (tiempo[0]->estado_radar == AGUA_NEG))  {
		int num_disparos = 0;
		for (i=0;i<10;i++) if (tiempo[i]->rad_objeto == SHOT) num_disparos++;
		if (num_disparos > 4) {
			// Hay una nube de disparos. Nos ponemos en estrategia ciega
			tiempo[0]->estrategia = CIEGO;
		 	if ( debug_level >= 2 ) robot.debug ("-- S:Estrategia CIEGO");
			robot.rotate_to (O_CANYON, robot_cannon_max_rotate, robot.angulo_enemigo);
		}
	}


}


void predecir_futuro(){
	int i;
	double longitud_tic = ((tiempo[0]->tiempo - tiempo[1]->tiempo)/2 + 
						(tiempo[1]->tiempo - tiempo[2]->tiempo)/2 +
						(tiempo[2]->tiempo - tiempo[3]->tiempo)/2)/3;
	
	double dif_tiempo;
	double dif_probabilidad;
	dif_angulo = 0;
	dif_distancia = 0;
	double cuenta = 0;

	if (ultima_pasada < 2) return;  

	for (i=ultima_pasada;(i>0 && i>ultima_pasada-10);i--){
		dif_tiempo = pasada[i].tiempo - pasada[i-1].tiempo;
		dif_probabilidad = (pasada[i].probabilidad + pasada[i-1].probabilidad) / 2;
		dif_angulo += dif_probabilidad*(pasada[i].angulo - pasada[i-1].angulo)/dif_tiempo;
		dif_distancia += dif_probabilidad*(pasada[i].distancia - pasada[i-1].distancia)/dif_tiempo;
		cuenta += dif_probabilidad;
	}
	dif_angulo = dif_angulo / cuenta;
	dif_distancia = dif_distancia / cuenta;
	

	double tiempo_futuro = tiempo[0]->tiempo + 0.8;
	double angulo_futuro = dif_angulo * (tiempo_futuro - pasada[ultima_pasada].tiempo) + pasada[ultima_pasada].angulo;
	double distancia_futuro = dif_distancia * (tiempo_futuro - pasada[ultima_pasada].tiempo) + pasada[ultima_pasada].distancia;

	distancia_esperada = distancia_futuro;

	if (( debug_level >= 4 )) cout << "Debug Posicion Enemigo. t= " << tiempo_futuro << ": ang=" << angulo_futuro << ",dist=" << distancia_futuro << endl;

	robot.rotate_to (O_CANYON, robot_cannon_max_rotate, angulo_futuro);

	presente = -1;	
}

double posible_acierto(){
	double prob_max = 0;
	int mejor_futuro = 0;
	int i;

	if (ultima_pasada < 2) return 0.0;

	double tiempo_futuro = tiempo[0]->tiempo + distancia_esperada/shot_speed;
	double angulo_futuro = dif_angulo * (tiempo_futuro - pasada[ultima_pasada].tiempo) + pasada[ultima_pasada].angulo;
	double distancia_futuro = dif_distancia * (tiempo_futuro - pasada[ultima_pasada].tiempo) + pasada[ultima_pasada].distancia;
	 if (( debug_level == 5 )) robot.debug_circle(angulo_futuro, distancia_futuro, 0.5);

	if (( debug_level >= 4 )) cout << "Debug Posicion Disparo. t= " << tiempo_futuro << ": ang=" << tiempo[0]->angulo_canyon << ",dist=" << distancia_esperada << endl;

	double x0 = distancia_futuro * cos(angulo_futuro);
	double y0 = distancia_futuro * sin(angulo_futuro);
	double x1 = distancia_esperada * cos(tiempo[0]->angulo_canyon);
	double y1 = distancia_esperada * sin(tiempo[0]->angulo_canyon);
	
	double distancia_enemigo = sqrt (pow(x1-x0,2) + pow(y1-y0,2));
	if (( debug_level >= 4 )) cout << "Debug Distancia de ambos: " << distancia_enemigo << endl;
	if ((distancia_enemigo < 0.5) && (distancia_enemigo > 0)) robot.shoot (shot_max_energy);
	
	
	
}


void pensar_canyon (){
	if (disparos_pendientes > 0) {
		robot.shoot (shot_max_energy);
		disparos_pendientes--;
		return;
	}
	
	if ((tiempo[1]->modo == BUSCANDO) && (tiempo[0]->modo != BUSCANDO)) {
	}


	if (((tiempo[0]->estado_radar == AGUA_POS) && (tiempo[1]->estado_radar == BLANCO_NEG)) 
		|| ((tiempo[0]->estado_radar == AGUA_NEG) && (tiempo[1]->estado_radar == BLANCO_POS))) {
			 pasada_radar();
			 predecir_futuro();
	}
	posible_acierto();	

}

// We need a function to be called when a signal arrives
void
handle_signal(int signr)
{
	nuevo_instante();
//	if ( debug_level >= 2 ) cout << "Debug tic " << tiempo[1]->tiempo - tiempo[2]->tiempo << endl;
	if ( debug_level >= 2 ) robot.debug("tic");
	robot.check_messages();
	pensar_radar();
	pensar_canyon();

  // Call this function next time too
  signal(signr, handle_signal);
}


int 
main(int argc, char * argv[])
{
  // Use non blocking and signals

  robot.robot_option( USE_NON_BLOCKING, true );
  robot.robot_option( SIGNAL, SIGUSR1 );


  // Initialize signal function
  sigset_t usr1set;
  signal(SIGUSR1, handle_signal);


  // libpthread seems to block USR1 sometimes for some reason
  sigemptyset(&usr1set);
  sigaddset(&usr1set, SIGUSR1);
  sigprocmask(SIG_UNBLOCK, &usr1set, NULL);


debug_level = 5;
comienzo = 1;
process_time_low = 0;
estadisticas_radar_total = 0;
estadisticas_radar_robot = 0;
estadisticas_radar_perdido = 0;
distancia_lejos = 2.0;
disparos_pendientes = 0;
factor_apertura_disparo = 0.04;  
num_tics_radar_perdido = 3; 
ultima_distancia = 20.0;
ultima_pasada = -1;   

int i;
for (i=0;i<tam_tiempo;i++){
	tiempo[i] = new t_instante;
} 

  while( !robot.is_quitting() )
    {
      // Here you can to whatever you like, but we have nothing 
      // to do...
      sleep(1);
    }
  return( EXIT_SUCCESS );
}

