#pragma once

#include <math.h>
#include "Matrix.h"
#include <string.h>
#include <vector>

using std::vector;

class CVector3f;
class CMatrix4x4f;
class CQuaternion;

struct matrix_interpolation_t
{
	vector<CMatrix4x4f> matrix;
	vector<float> interpolate;
	
	matrix_interpolation_t() {}
};

class CVector2f
{
public:
	float x;
	float y;
	CVector2f() : x(0),y(0) {}
	CVector2f(const CVector2f& arg) : x(arg.x),y(arg.y) {}
	CVector2f(float X, float Y) : x(X),y(Y) {}
	CVector2f& operator=(const CVector2f& arg) {x=arg.x;y=arg.y; return (*this);}
};

class CVector4f
{
public:
	float x;
	float y;
	float z;
	float w;
	
	CVector4f(const CVector3f& arg);
	CVector4f();
	CVector4f(float X, float Y, float Z, float W){x=X;y=Y;z=Z;w=W;}
	CVector4f operator*(float scalar){return CVector4f(x*scalar,y*scalar,z*scalar,w);}
	CVector4f operator*=(float scalar){return (*this)=(*this)*scalar;}
	CVector4f operator+(CVector3f arg);
	CVector4f operator=(const CVector4f& arg);
};

class CVector3f
{
public:
	
	float x;
	float y;
	float z;
	
	// Constructors and stuff ;-)
	CVector3f(float X, float Y, float Z = 0) {
		x = X; y=Y; z=Z;
	}
	CVector3f() : x(0.0f),y(0.0f),z(0.0f) {}
	CVector3f(const CVector3f& arg) : x(arg.x),y(arg.y),z(arg.z) {}
	CVector3f(const CQuaternion& arg);
	CVector3f(const CVector4f& arg);
	
	// Other stuff
	
	CVector3f combineMatrix(const matrix_interpolation_t& arg);
	
	float dot(const CVector3f& arg) const {
		return x*arg.x+y*arg.y+z*arg.z;
	}
	
	CVector3f cross(const CVector3f& arg) const {
		return CVector3f(y*arg.z-z*arg.y, z*arg.x-x*arg.z, x*arg.y-y*arg.x);
	}
	
	float magnitude() const {
		return sqrt(pow(x, 2)+pow(y, 2)+pow(z, 2));
	}
	
	void normalize(){
		float scalar = 1.0f / magnitude();
		x*=scalar; y*=scalar; z*=scalar;
	}
	
	CVector3f normalized(){
		float scalar = 1.0f / magnitude();
		return CVector3f(x*scalar, y*scalar, z*scalar);
	}
	
	CVector3f operator/(const CVector3f& arg){
		return CVector3f(x/arg.x, y/arg.y, z/arg.z);
	}
	
	CVector3f& operator=(const CVector3f& arg){
		x=arg.x; y=arg.y; z=arg.z;
		return (*this);
	}
	
	bool operator==(const CVector3f& arg){
		return (x==arg.x&&y==arg.y&&z==arg.z);
	}
	
	CVector3f operator*(float scalar) const {
		return CVector3f(x*scalar, y*scalar, z*scalar);
	}
	CVector3f operator*=(float scalar){
		return (*this) = CVector3f(x*scalar, y*scalar, z*scalar);
	}
	
	CVector3f operator/(float scalar) const {
		return CVector3f(x/scalar, y/scalar, z/scalar);
	}
	CVector3f operator/=(float scalar){
		return (*this) = CVector3f(x/scalar, y/scalar, z/scalar);
	}
	
	CVector3f operator+(const CVector3f arg) const {
		return CVector3f(arg.x+x,arg.y+y,arg.z+z);
	}
	CVector3f operator+=(const CVector3f arg) {
		return (*this) = (*this)+arg;
	}
	
	CVector3f operator-(const CVector3f arg) const {
		return CVector3f(x-arg.x,y-arg.y,z-arg.z);
	}
	CVector3f operator-() const {
		return CVector3f(-x,-y,-z);
	}
	CVector3f operator-=(const CVector3f arg) {
		return (*this) = (*this)-arg;
	}
	
	CVector3f operator+(float arg) const {
		return CVector3f(x+arg,y+arg,z+arg);
	}
	CVector3f operator+=(float arg) {
		return (*this) = (*this)+arg;
	}
	
	void rotate(float X, float Y, float Z);
	void translate(float X, float Y, float Z);
	void scale(float X, float Y, float Z);
	
};