#pragma once
#include <math.h>
#include "Matrix.h"
#include "Vector.h"

class CMatrix4x4f;
class CVector3f;

class CQuaternion{
public:
	float w, x, y, z;
	CQuaternion() : w(1.0f), x(0.0f), y(0.0f), z(0.0f) {}
	CQuaternion(float W, float X, float Y, float Z) : w(W),x(X),y(Y),z(Z){}
	CQuaternion(const CQuaternion& arg) : w(arg.w),x(arg.x),y(arg.y),z(arg.z){}
	CQuaternion(const CVector3f& arg);
	CQuaternion(const CMatrix4x4f& arg);
	CQuaternion operator=(const CQuaternion& arg){w=arg.w;x=arg.x;y=arg.y;z=arg.z; return *this;}
	
	CQuaternion slerp(CQuaternion& to, float t);
	
	CVector3f operator*(const CVector3f& arg);
	
	CQuaternion operator*(const CQuaternion& arg);
	CQuaternion operator*=(const CQuaternion& arg){
		return (*this)=(*this)*arg;
	}
	
	CQuaternion operator/(float scalar) {return CQuaternion(w/scalar,x/scalar,y/scalar,z/scalar);}
	CQuaternion operator/=(float scalar) {return (*this)=(*this)/scalar;}
	
	float separation(CQuaternion& arg);
	
	void rotate(float Angle, float X, float Y, float Z);
	void normalize(){
		float mag = sqrtf(w*w+x*x+y*y+z*z);
		float scalar=1.0f/mag;
		w*=scalar;
		x*=scalar;
		y*=scalar;
		z*=scalar;
	}
	
	float norm() {return w*w+x*x+y*y+z*z;}
	CQuaternion conjugate() {return CQuaternion(w,-x,-y,-z);}
	CQuaternion inverse() {return conjugate()/norm();}
};