from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import pygame
from pygame.locals import *

from core import *
from splash import Splash
from math import sqrt


class Rainbow(Splash):

    def __init__(self):
        Splash.__init__(self)

    def drawFrame(self, time, delta):

        colors = [
            (.5, 0, .5),
            (0, 0, .5),
            (0, 0, 1),
            (0, 1, 0),
            (1, 1, 0),
            (1, .5, 0),
            (1, 0, 0)
            ]

        glBlendFunc(GL_SRC_ALPHA, GL_ONE)
        glEnable(GL_BLEND)
       

        glDisable(GL_DEPTH_TEST)
 
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(-1,1,-.75,.75,0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        glEnable(GL_POLYGON_SMOOTH)
        glBegin(GL_QUADS)

        thickness = 0.025
#        if time > pi and time < pi + pi /4:
#            thickness += sin(time*4) * 0.01;

        radius = .4
        sides = 40


        start = 0
        end = min(time, pi)


        intensity0 = 1
        if time > pi + pi/2:
            intensity0 = max(0, 1.0 - (time-(pi + pi/2)))


        # draw stripes and reflection
        for i in xrange(7):
            color = colors[i]

            intensity = intensity0
            color = (color[0] * intensity, color[1] * intensity, color[2] * intensity)
            
            intensity = .25 + cos(time*2) * .05
            darkColor = (color[0] * intensity, color[1] * intensity, color[2] * intensity)
           
            glColor3f(*color)
            drawFilledRing(radius + i*thickness, radius + (i+1)*thickness, 0, 0 ,sides, start, end)
            #reflection
            glColor3f(*darkColor)
            drawFilledRing(radius + i*thickness, radius + (i+1)*thickness, 0, 0 ,sides, -start, -end)
        
        glColor3f(1,1,1)
        if time > pi+pi/8 and time < pi + pi*2 /8:
            a = sin((time - pi/8)*8)*2
            drawFilledRing(.01*a,.02*a, sqrt(2)*.275, sqrt(2)*.275, 10, 0, pi*2)
        glEnd()



        glDisable(GL_POLYGON_SMOOTH)
        

        glColor3f(0,0,0)
        glBegin(GL_LINES)


        for i in xrange(10):
            y = cos(cos(i*.49)*time*.315+i*10*.132)*.3 - .3
            glVertex2f(-1,y)
            glVertex2f(1,y)

        glEnd()
      
        glDisable(GL_BLEND)
