from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import random
import math # for sqrt
import cPickle
import struct

# bbox: 

# 0 3.216229 0.976119 0.990393       1 1 1 
# 1 3.216229 0.976119 -1.009607      1 1 0
# 2 1.216228 0.976119 -1.009607      0 1 0
# 3 1.216229 0.976119 0.990393       0 1 1
# 4 3.216229 -1.023881 0.990392      1 0 1
# 5 3.216228 -1.023881 -1.009608     1 0 0
# 6 1.216228 -1.023881 -1.009607     0 0 0
# 7 1.216229 -1.023881 0.990393      0 0 1

# x 0 -- 3
# y 0 -- 4
# z 0 -- 1

quickLoadMap = {}


def loadFromPickle(pfile):

  numverts = struct.unpack("I",pfile.read(4))[0]

  colors = pfile.read(numverts*4)
  normal = pfile.read(numverts*4)
  position = pfile.read(numverts*4)
#  glColorPointer(3, GL_FLOAT, 0, colors)
  glNormalPointer(GL_FLOAT, 0, normal)
  glVertexPointer(3, GL_FLOAT, 0, position)

#  glEnableClientState(GL_COLOR_ARRAY)
  glEnableClientState(GL_VERTEX_ARRAY)
  glEnableClientState(GL_NORMAL_ARRAY)


  gllist = glGenLists(1)
  glNewList(gllist, GL_COMPILE)
  glColorMaterial ( GL_FRONT_AND_BACK, GL_DIFFUSE ) ;
  glEnable ( GL_COLOR_MATERIAL ) ;



  glDrawArrays(GL_TRIANGLES,0, numverts/3)




  glEndList()
#  glDisableClientState(GL_COLOR_ARRAY)
  glDisableClientState(GL_VERTEX_ARRAY)
  glDisableClientState(GL_NORMAL_ARRAY)


  return (gllist, None)


def simpleLoader(filename):
  global quickLoadMap
  if filename in quickLoadMap:
    return quickLoadMap[filename]

  try:
    infile = file(filename+".bin","rb")
    print "found cached bin, loadin from bin"
    return loadFromPickle(infile)
  except IOError,e:
    try:
      infile = file(filename,"r")
      print "no bin, loading from raw instead"
      return loadFromRaw(filename,infile)
    except IOError, e:
      print filename, "not found"
      return None
  

def loadFromRaw(filename, infile):

  gllist = glGenLists(1)
  glNewList(gllist, GL_COMPILE)
  print "gllist = ", gllist

  glEnable(GL_LIGHTING)
  glEnable(GL_NORMALIZE)

  glColorMaterial ( GL_FRONT_AND_BACK, GL_DIFFUSE ) ;
  glEnable ( GL_COLOR_MATERIAL ) ;

  glBegin(GL_TRIANGLES)
  bbox = None
  
  lnr = 0
  normals = []
  positions = []
  colors = []

  for line in infile:
    a = line.strip().split(" ")
    if a[0] == "triangle:":
      vals = map(float, a[1:])
      # normal, color, position
      if len(vals) != 27:
        print "error loading vals:",vals,len(vals)
      for triangleVals in [ vals[0:9], vals[9:18], vals[18:27] ]:
        glColor3f( *triangleVals[0:3] )
        colors +=  triangleVals[0:3]
        glNormal3f( *triangleVals[3:6] )
        normals += triangleVals[3:6]
        glVertex3f(  *triangleVals[6:9] )
        positions += triangleVals[6:9]
    elif a[0] == "extend:":
      # we don't handle extends
      pass
    elif a[0] == "bbox:":
      coords = map(float, a[1:])
      center = [ sum( coords[i::3] )/(len(coords)/3) for i in range(3) ]
      coord = {}
      coord[0] = coords[0:3]
      coord[4] = coords[4*3:4*3+3]
      coord[3] = coords[3*3:3*3+3]
      coord[1] = coords[1*3:1*3+3]
      
      xaxis = [ b-a for (a,b) in zip( coord[3], coord[0] ) ]
      yaxis = [ b-a for (a,b) in zip( coord[4], coord[0] ) ]
      zaxis = [ b-a for (a,b) in zip( coord[1], coord[0] ) ]

      # x 0 -- 3
      # y 0 -- 4
      # z 0 -- 1

      #print "bbox center at",center
      #print "axes:"
      #print "x:",xaxis
      #print "y:",yaxis
      #print "z:",zaxis
      bbox = {}
      bbox['xaxis'] = xaxis
      bbox['yaxis'] = yaxis
      bbox['zaxis'] = zaxis
      bbox['center'] = center
    else:
      print "unable to handle type",a[0],"in line",a
    
  glEnd()

  glDisable(GL_LIGHTING)
  glDisable ( GL_COLOR_MATERIAL ) ;
  glShadeModel(GL_SMOOTH)

  if False:
    glLineWidth(1.0)
    glBegin(GL_LINES)

    lnr = 1
    l = 0.3

    for normal,position in zip(normals, positions):
        glColor3f(0,0,1)
        glVertex3f( *position )
        glColor3f(0,1,1)
        glVertex3f( *[position[i] + l * normal[i] for i in range(3)]  )


    glEnd()
    
  glEndList()
 
  retval = (gllist, bbox)
  quickLoadMap[filename] = retval


  
  flFile = file(filename+".bin", "w")
  format = "f"*len(positions)
    
  flFile.write(struct.pack("I", len(positions)))
  flFile.write(struct.pack(format, *colors))
  flFile.write(struct.pack(format, *normals))
  flFile.write(struct.pack(format, *positions))


  flFile.close()
   
  
  return retval
