#include "scroller.hpp"
#include "font.hpp"

#include <stdlib.h>
#include <string.h>

Scroller::Scroller(int vlag) {
  _t0 = -1.0;
  if (vlag == 0) {
    _message = "          ecfh presents +out_of_touch-";
    _font = getFont14x16();
  }
  else if (vlag == 1) {
    _message = "        wat nou credits";
    _font = getFont12x12();
  }
  else if (vlag == 2) {
    _message = " greetings to limp ninja                                        haha smoke kan niet coden";
    _font = getFont12x12();
  }
  else if (vlag == 3) {
     _message = "                                limp ninja presents a limp ninja demo called back in the place";
     //    _message = "limp ninja presents a limp ninja demo called called";
    _font = getFont12x12();
  }
}




void Scroller::effect(double t) {
  draw(t);
}

/**
 * Returns an offset in message, giving spaces slightly less space than a character.
 * Will someone actually notice this?
 */
double space_hack(char* message, int max) {
  double count = 0;
  for (int i = 0; i < (int) strlen(message); i++) {
    if (message[i] == '_') {
      count += 0.3;
    } else {
      count += 1.0;
    }
    if (i == max) {
      return count;
    }
  }
  return count;
}

void Scroller::draw(double t) {
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  glBlendFunc(GL_ONE, GL_SRC_ALPHA);
  glEnable(GL_BLEND);		

  glDisable(GL_LIGHTING);

  glLoadIdentity();
  glTranslatef(-1.0, -1.0, -8.0);

  for (int i = 0; i < (int) strlen(_message); i++) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
//     glRotatef(20.0, 0.0, 0.0, 1.0);

    double x = space_hack(_message, i) * 1.2 - t * 5.0;
    double wobble = sin(t * 1.7 + 2.5) * cos(t + 2.5) * 0.5;
    double y = 0.0 + sin(t * wobble + i) * 0.4;
    double z = 0.0;
    char c = _message[i];
    if ((c != ' ') && (c != '_')) {
      glTranslatef(x, y, z);
      glRotatef(- y * 40 + i * 2 - t * 10 + 10, 0.0, 0.0, 1.0);
      Vector3 v(0.0, 0.0, 0.0);
      glColor3f(0.0, 0.0, 0.0);
      _font->paint(v, _message[i]);
      
      glTranslatef(-0.1, 0.1, 0.0);
      glColor3f(1, 1, 1);
      _font->paint(v, _message[i]);
    }
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
  }

  glDisable(GL_BLEND);
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
}


void Scroller::draw2(double t2) {
  if (_t0 < 0) {
    _t0 = t2;
  }

  double t = t2 - _t0;


  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glBlendFunc(GL_SRC_COLOR, GL_SRC_ALPHA);
  glEnable(GL_BLEND);		

  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glLoadIdentity();
  glTranslatef(-1.0, -1.0, -3.0);
  glColor4f(1.0,0.0,1.0,0.5);


  
  for (int i = 0; i < (int) strlen(_message); i++) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
//     glRotatef(20.0, 0.0, 0.0, 1.0);

    double x = space_hack(_message, i) * 1.2 - t * 7.0;
    double wobble = sin(t * 1.7 + 2.5) * cos(t + 2.5) * 0.5;
    double y = 0.0 + sin(t * wobble + i) * 0.4 + 0.6;
    double z = 0.0;
    char c = _message[i];
    if ((c != ' ') && (c != '_')) {
      glTranslatef(x, y, z);
          glRotatef(- y * 10 + i * 1 - t * 2 + 10, 0.0, 0.0, 1.0);
      Vector3 v(0.0, 0.0, 0.0);
      glColor3f(0.0, 0.0, 0.0);
      _font->paint(v, _message[i]);
      
      glTranslatef(-0.1, 0.1, 0.0);
      glColor4f(1,y, 1,1);
      _font->paint(v, _message[i]);
    }
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
  }

  glDisable(GL_BLEND);
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
}

void Scroller::draw3(double t2) {
  if (_t0 < 0) {
    _t0 = t2;
  }

  double t = t2 - _t0;


  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glBlendFunc(GL_SRC_COLOR, GL_SRC_ALPHA);
  glEnable(GL_BLEND);		

  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glLoadIdentity();
  glTranslatef(1.7, -1.0, -8.0);
  glColor4f(1.0,0.0,1.0,0.5);


  
  for (int i = 0; i < (int) strlen(_message); i++) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
//     glRotatef(20.0, 0.0, 0.0, 1.0);

    double y = space_hack(_message, i) * 1.2 - t * 7.0;
    //    double wobble = sin(t * 1.7 + 2.5) * cos(t + 2.5) * 0.5;
    double x = 2.0; // 0.0 + sin(t * wobble + i) * 0.4 + 0.6;
    double z = 0.0;
    char c = _message[i];
    if ((c != ' ') && (c != '_')) {
      glTranslatef(x, y, z);
          glRotatef(- y * 10 + i * 1 - t * 2 + 10, 0.0, 0.0, 1.0);
      Vector3 v(0.0, 0.0, 0.0);
      glColor3f(0.0, 0.0, 0.0);
      _font->paint(v, _message[i]);
      
      glTranslatef(-0.1, 0.1, 0.0);
      glColor4f(1,y, 1,1);
      _font->paint(v, _message[i]);
    }
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
  }

  glDisable(GL_BLEND);
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
}

void Scroller::draw4(double t2) {
  if (_t0 < 0) {
    _t0 = t2;
  }

  double t = t2 - _t0;


  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glBlendFunc(GL_SRC_COLOR, GL_SRC_ALPHA);
  glEnable(GL_BLEND);		

  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glLoadIdentity();
  glTranslatef(-1.0, -0.8, -12.0);
  glColor4f(1.0,1.0,0.0,0.5);
  glScalef(0.6,1.0,1.0);
  
  for (int i = 0; i < (int) strlen(_message); i++) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
//     glRotatef(20.0, 0.0, 0.0, 1.0);

    double wobble = sin(t * 1.7 + 2.5) * cos(t + 2.5) * 0.5;
    double x = space_hack(_message, i) * 1.2 - t * 7.0 + wobble * 10.0;
    double y = 0.0 + sin(t * wobble + i) * 0.2 + 0.6;
    double z = 0.0;
    char c = _message[i];
    if ((c != ' ') && (c != '_')) {
      glTranslatef(x, y, z);
      //          glRotatef(- y * 10 + i * 1 - t * 2 + 10, 0.0, 0.0, 1.0);
      Vector3 v(0.0, 0.0, 0.0);

      // SUPER SHADOW
      glColor3f(0.0, 0.0, 0.0);
      _font->paint(v, _message[i]);
      
      glColor3f(0.0, 0.0, 0.0);
      glTranslatef(-0.4, 0.4, 0.0);
      _font->paint(v, _message[i]);
      
      glTranslatef(-0.07, 0.07, 0.0);
      glColor4f(1.0, 0.5, 1.0, 1.0);
      _font->paint(v, _message[i]);

//       glTranslatef(-0.4, 0.4, 0.0);
//       glColor4f(1.0, 0.5, 1.0, 1.0);
//       _font->paint(v, _message[i]);
    }
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
  }

  glDisable(GL_BLEND);
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
}
