#ifndef GRAPHICS_HPP
#define GRAPHICS_HPP

#include <GL/gl.h>
#include <GL/glu.h>

#include "vector.hpp"

struct Color {
  Color(float r, float g, float b) : r(r), g(g), b(b) {
    // Empty
  };
  float r, g, b;
};

/**
 * Loads a texture from a file and installs it in OpenGL.
 * @param filename the file to load, typically "foo.png"
 * @return an OpenGL texture identifier
 */
GLuint load_texture_from_file(const char *filename, int mask);

void draw_faces(IndexFace3* faces, int nFaces, Vector3* coords);

void calc_face_normal(IndexFace3& face, Vector3* coords);

/**
 * Reset OpenGL settings to the default drawing mode.
 */
void reset_gl();

/**
 * Set OpenGL settings for polygon smoothing.
 */
void set_gl_polygon_smoothing();

void set_gl_lighting();

#endif
